/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FileStore.java
 *
 * LastModified: 2009-09-17 03:21:11
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.file;

import com.gtis.fileCenter.ex.CapabilityNotEnoughException;
import com.gtis.fileCenter.ex.FileIOException;
import com.gtis.fileCenter.model.impl.StoreUrl;

import java.io.File;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-15
 */
public interface FileStore {

    String getName();

    File getDirectory();

    long getCapability();

    long getUsed();

    boolean isAvailable();

    void increaseUsed(StoreUrl storeUrl, long size);

    boolean exists(StoreUrl storeUrl);

    File createFile(com.gtis.fileCenter.model.impl.File file) throws CapabilityNotEnoughException, FileIOException;

    StoreUrl getStoreUrl(File file);

    File getFile(StoreUrl storeUrl);

    boolean delete(StoreUrl storeUrl);

    void init() throws Exception;

    void save() throws Exception;

    void countUsed() throws Exception;
}
