/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: NoPermissionException.java
 *
 * LastModified: 2009-10-23 11:18:37
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.ex;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-10-23
 */
public class NoPermissionException extends NestedRuntimeException {

    private static final long serialVersionUID = 927858202290123709L;
    private Integer nodeId;

    public Integer getNodeId() {
        return nodeId;
    }

    public NoPermissionException(Integer nodeId) {
        super("no permission to access node:" + nodeId);
        this.nodeId = nodeId;
    }

    public NoPermissionException(String msg) {
        super(msg);
    }

    public NoPermissionException(String msg, Throwable cause) {
        super(msg, cause);
    }

}
