/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: UnzipDialog.js
 *
 * LastModified: 2009-10-14 04:22:57
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.UnzipDialog = function(config) {
    Ext.apply(this, config);

    this.formPanel = new Ext.FormPanel({
        labelWidth: 45,
        url:this.getUrl('node/unzip.do'),
        frame:true,
        border:false,
        bodyStyle:'padding:5px',
        defaultType: 'textfield',
        items: [
            {
                fieldLabel: '解压到',
                name: 'name',
                anchor:'100%'
            },
            {
                xtype:'checkboxgroup',
                fieldLabel: '选项',
                style:{paddingTop:'2px'},
                items:[
                    {
                        boxLabel: '解压到当前文件夹',
                        name: 'current',
                        listeners:{'check': function(box, c) {
                            this.formPanel.form.findField('name').setDisabled(c);
                        }, scope: this}
                    },
                    {
                        boxLabel: '覆盖同名文件',
                        name: 'cover'
                    }
                ]
            }
        ],
        buttons: [
            {
                text:'解压',
                handler: function() {
                    this.save();
                },
                scope:this
            },
            {
                text: '关闭',
                handler: function() {
                    this.hide();
                },
                scope:this
            }
        ]
    });

    this.addEvents('success');

    Fc.UnzipDialog.superclass.constructor.call(this, {
        title:'解压文件',
        iconCls:'fc-zip',
        layout:'fit',
        width:400,
        height:140,
        border:false,
        closeAction:'hide',
        modal: true,
        plain: true,
        items:this.formPanel
    });
};

Ext.extend(Fc.UnzipDialog, Ext.Window, {
    show:function(nid, name) {
        this.nid = nid;
        Fc.UnzipDialog.superclass.show.call(this);
        var form = this.formPanel.form;
        form.findField('name').setValue(name);
    },
    save:function() {
        var fp = this.items.item(0);
        if (fp.getForm().isValid()) {
            fp.getForm().submit({
                waitMsg: '正在解压...',
                params: {nid:this.nid},
                success: function() {
                    this.hide();
                    this.fireEvent('success', this, this.id);
                },
                failure:function(fp, action) {
                    var data = Ext.decode(action.response.responseText);
                    if (data.type == 2)
                        fp.findField('name').markInvalid('该名称已被使用！');
                    else
                        Fc.errorDialog.show(data['msg'], data['detail'], data['type']);
                },
                scope:this
            });
        }
    }
});

