/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: TreePanel.js
 *
 * LastModified: 2009-09-28 07:14:33
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.TreePanel = function(config) {
    Ext.apply(this, config);
    this.addEvents('nodeChange');

    var rootNode = new Ext.tree.AsyncTreeNode({
        id:this.rootId,
        text:'/',
        iconCls:'fc-space'
    });
    this.loader = new Ext.tree.TreeLoader({
        dataUrl:this.getUrl('node/tree.do'),
        listeners:{

            "beforeload":function(treeLoader, node) {
                treeLoader.baseParams.nid = node.id;
            }
        }
    });

    var treeMenu = new Ext.menu.Menu({
        enableScrolling:false,
        cls:'fc-context-menu',
        items: [
            {
                itemId:'create',
                iconCls:'fc-create',
                text: '创建子目录',
                scope: this,
                handler: function() {
                    this.addChildNode();
                }
            },
            {
                itemId:'rename',
                iconCls:'fc-props',
                text: '重命名',
                scope: this,
                handler: function() {
                    this.rename();
                }
            },
            '-',
            {
                itemId:'refresh',
                iconCls:'fc-refresh',
                text: '刷新',
                scope:this,
                handler:function() {
                    this.refresh();
                }
            },
            '-',
            {
                itemId:'cut',
                iconCls:'fc-cut',
                text: '剪切',
                scope: this,
                handler: function() {
                    this.cut();
                }
            },
            {
                itemId:'copy',
                iconCls:'fc-copy',
                text: '复制',
                scope: this,
                handler: function() {
                    this.copy();
                }
            },
            {
                itemId:'paste',
                iconCls:'fc-paste',
                text: '粘贴',
                scope: this,
                handler: function() {
                    this.paste();
                }
            },
            {
                itemId:'delete',
                iconCls:'fc-delete',
                text: '删除',
                scope: this,
                handler: function() {
                    Ext.MessageBox.confirm('确认', '确定要删除这 ' + this.currentNode.text + ' 吗?', function(btn) {
                        if (btn != 'yes')
                            return;
                        Fc.Ajax.request({
                            url:this.getUrl('node/del.do'),
                            params:{nid:this.currentNode.id},
                            success:function() {
                                this.currentNode.remove();
                            },
                            scope:this
                        });
                    }, this);
                }
            }
        ]});

    this.treeEditor = new Ext.tree.TreeEditor(this, {
        allowBlank:false,
        selectOnFocus:true
    });

    this.treeEditor.on({
        'beforestartedit':function(e) {
            var n = e.editNode;
            return n != rootNode;
        },
        'complete':function(e, value, s) {
            if (value == s && Ext.isNumber(e.editNode.id))
                return;
            var node = e.editNode;
            var name = node.attributes['name'];
            var params = s == name ? {name:value} : {viewName:value};
            var pNodeId = node.attributes['pNodeId'];
            if (pNodeId)
                params['pnid'] = pNodeId;
            else
                params['nid'] = node.id;
            Fc.Ajax.request({
                url:this.getUrl('node/edit.do'),
                params:params,
                success:function(response) {
                    var data = Ext.decode(response.responseText);
                    node.setId(data.id);
                    node.select();
                    this.fireEvent('nodeChange', node.id, node);
                },
                failure:function() {
                    if (pNodeId) {
                        this.treeEditor.editNode = node;
                        this.treeEditor.startEdit(node.ui.textNode);
                    }
                    else
                        node.setText(s);
                },
                scope:this
            });
        },
        scope:this
    });
    this.getSelectionModel().on({
        'selectionchange':function(sm, node) {
            if (node) {
                if (node && Ext.isNumber(node.id))
                    this.fireEvent('nodeChange', node.id, node);
            } else
                this.currentNode.parentNode.select();
        },
        scope:this
    });

    Fc.TreePanel.superclass.constructor.call(this, {
        region:'center',
        animate:false,
        autoScroll: true,
        border: false,
        rootVisible: true,
        useArrows: true,
        root:rootNode
    });
    this.on({
        'contextmenu':function(node, e) {
            e.stopEvent();
            this.currentNode = node;
            treeMenu.showAt(e.getXY());
            treeMenu.getComponent('delete').setDisabled(node.id == this.rootId);
            treeMenu.getComponent('paste').setDisabled(this.fcPanel.cutIds.length == 0 && this.fcPanel.copyIds.length == 0);
            if (this.readOnly) {
                treeMenu.getComponent('create').setDisabled(true);
                treeMenu.getComponent('rename').setDisabled(true);
                treeMenu.getComponent('cut').setDisabled(true);
                treeMenu.getComponent('copy').setDisabled(true);
                treeMenu.getComponent('paste').setDisabled(true);
                treeMenu.getComponent('delete').setDisabled(true);
            }
        },
        scope:this
    });
};

Ext.extend(Fc.TreePanel, Ext.tree.TreePanel, {
    addChildNode:function() {
        this.currentNode.expand(false, false);
        var node = this.currentNode.appendChild(new Ext.tree.TreeNode({
            pNodeId:this.currentNode.id,
            iconCls:'fc-folder',
            text:'新建文件夹',
            allowDrag:false
        }));
        this.getSelectionModel().select(node);
        var ge = this.treeEditor;
        setTimeout(function() {
            ge.editNode = node;
            ge.startEdit(node.ui.textNode);
        }, 200);
    },
    reloadNodes:function(ids) {
        for (var i = 0; i < ids.length; i++) {
            var node = this.getNodeById(ids[i]);
            if (node)
                node.reload();
        }
    },
    selectNode:function(id) {
        var node = this.getNodeById(id);
        if (node)
            node.select();
    },
    removeNodes:function(ids) {
        for (var i = 0; i < ids.length; i++) {
            var node = this.getNodeById(ids[i]);
            if (node)
                node.remove();
        }
    },
    rename:function() {
        this.treeEditor.editNode = this.currentNode;
        this.treeEditor.startEdit(this.currentNode.ui.textNode);
    },
    refresh:function() {
        this.currentNode.reload();
    },
    cut:function() {
        this.fcPanel.cutIds = [this.currentNode.id];
        this.fcPanel.copyIds = [];
        this.fcPanel.updateToolbar();
    },
    copy:function() {
        this.fcPanel.copyIds = [this.currentNode.id];
        this.fcPanel.cutIds = [];
        this.fcPanel.updateToolbar();
    },
    paste:function() {
        if (this.fcPanel.cutIds && this.fcPanel.cutIds.length > 0 || this.fcPanel.copyIds && this.fcPanel.copyIds.length > 0) {
            var isCopy = this.fcPanel.copyIds.length > 0;
            Fc.Ajax.request({
                url:this.getUrl('node/' + (isCopy ? 'copy' : 'move') + '.do'),
                params:{nid:isCopy ? this.fcPanel.copyIds : this.fcPanel.cutIds,dnid:this.currentNode.id},
                success:function() {
                    if (this.fcPanel.cutIds) {
                        this.removeNodes(this.fcPanel.cutIds);
                    }
                    this.fcPanel.copyIds = [];
                    this.fcPanel.cutIds = [];
                    this.currentNode.reload();
                    this.selectNode(this.currentNode.id);
                },
                scope:this
            });
        }
    },
    del:function() {
        Ext.MessageBox.confirm('确认', '确定要删除这 ' + this.currentNode.text + ' 吗?', function(btn) {
            if (btn != 'yes')
                return;
            Fc.Ajax.request({
                url:this.getUrl('node/del.do'),
                params:{nid:this.currentNode.id},
                success:function() {
                    this.currentNode.remove();
                },
                scope:this
            });
        }, this);
    }
});

