/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: MicroView.js
 *
 * LastModified: 2009-09-28 07:16:22
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */
Fc.MicroView = function(config) {
    Ext.apply(this, config);
    var tpl = new Ext.XTemplate(
            '<tpl for=".">',
            '<div class="thumb-wrap thumb-wrap-micro" id="fc-node-{id}">',
            '<div class="thumb" style="background: url({bigIcon}) no-repeat center center;" title="{name}">{childCount}</div>',
            '<span class="x-editable<tpl if="childCount"> child</tpl>">{shortName}</span></div>',
            '</tpl>',
            '<div class="x-clear"></div>'
            );
    var plgs=[new Ext.DataView.DragSelector()];
    if(!this.readOnly){
        plgs.push(new Ext.DataView.LabelEditor({dataIndex: 'name',viewIndex:'viewName'}));
    }
    Fc.MicroView.superclass.constructor.call(this, {
        cls:'fc-view',
        tpl: tpl,
        multiSelect: true,
        overClass:'x-view-over',
        itemSelector:'div.thumb-wrap-micro',
        plugins: plgs
    });
};
Ext.extend(Fc.MicroView, Ext.DataView, {
    getSelections:function() {
        return Fc.MicroView.superclass.getSelectedRecords.call(this);
    },
    getCount:function() {
        return Fc.MicroView.superclass.getSelectionCount.call(this);
    }
});
