/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: ListGrid.js
 *
 * LastModified: 2009-09-28 07:16:09
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.ListGrid = function(config) {
    Ext.apply(this, config);

    var cm = new Ext.grid.ColumnModel([
        {
            header: "名称",
            dataIndex: 'name',
            width: 200,
            renderer: this.formatName,
            sortable:true
        },
        {
            header: "大小",
            dataIndex: 'size',
            align:'right',
            width: 100,
            renderer: this.formatSize,
            sortable:true
        },
        {
            header: "更新时间",
            dataIndex: 'updateTime',
            width: 130,
            renderer: this.formatDate,
            sortable:true
        },
        {
            header: "所有者",
            dataIndex: 'owner',
            width: 70,
            sortable:true
        },
        {
            header: "下级个数",
            dataIndex: 'childCount',
            width: 50,
            sortable:true
        },
        {
            header: "说明",
            dataIndex: 'description',
            width: 200,
            sortable:true
        }
    ]);

    Fc.ListGrid.superclass.constructor.call(this, {
        cls:'fc-view',
        viewConfig: {
            forceFit:true
        },
        cm:cm,
        border: false,
        sm:new Ext.grid.RowSelectionModel(),
        loadMask: false
    });
};
Ext.extend(Fc.ListGrid, Ext.grid.GridPanel, {
    getSelections:function() {
        return this.getSelectionModel().getSelections();
    },
    getCount:function() {
        return this.getSelectionModel().getCount();
    },
    setStore:function(store) {
        this.getView().bind(store, this.getColumnModel());
    },
    formatName:function(name, p, record) {
        var viewName = record.data.viewName;
        return String.format('<div class="thumb-list' + (record.data.childCount ? ' child' : '') + '" style="background: url({0}) no-repeat left center;" title="{1}">{2}</div>', record.data.smallIcon, name, viewName || name);
    },
    formatSize:function(size, p, record) {
        if (record.data.type == 1)
            return Ext.util.Format.fileSize(size);
        return '';

    },formatDate:function(date) {
        return date.format('Y-m-d H:i');
    }
});

