/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FcStore.js
 *
 * LastModified: 2009-10-13 05:39:02
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.FcStore = function(config) {
    Ext.apply(this, config);
    this.addEvents('datachanged', 'nodechanged');

    var fields = ['id','parentId','path', 'name','viewName','description','type','size','usedSize','icon','owner','isDoc','isImage','childCount','attrs',
        {
            name:'updateTime',
            type:'date',
            dateFormat:'time'
        },
        {
            name: 'shortName',
            mapping: 'name',
            convert: this.convertName
        },
        {
            name: 'bigIcon',
            mapping: 'icon',
            convert: this.convertBigIcon,
            getUrl:this.getUrl
        },
        {
            name: 'smallIcon',
            mapping: 'icon',
            convert: this.convertSmallIcon,
            getUrl:this.getUrl
        },
        {
            name: 'url',
            mapping: 'id',
            convert: this.convertUrl,
            getUrl:this.getUrl
        }];

    Fc.FcStore.superclass.constructor.call(this, {
        url: this.getUrl(this.url ? this.url : 'node/list.do'),
        baseParams:this.baseParams || {},
        fields:fields,
        root: 'items',
        totalProperty: 'total'
    });
};

Ext.extend(Fc.FcStore, Fc.data.JsonStore, {
    getCurrentNode:function() {
        if (!this.cNode || this.cNode.id != this.getNodeId()) {
            var reader = this.reader;
            var data = reader.jsonData.node;
            var items = reader.recordType.prototype.fields.items;
            this.cNode = reader.extractValues(data, items, items.length);
        }
        return this.cNode;
    },
    getNodeId:function() {
        return this.baseParams['nid'];
    },
    getEditUrl:function(name) {
        return this.getWebdavUrl(name);
    },
    loadNode:function(nodeId, params) {
        if (nodeId == this.getNodeId())
            return;
        if (nodeId) {
            this.setBaseParam('nid', nodeId);
            this.fireEvent('nodechanged', nodeId);
        }
        this.load({params:params || {}});
    },
    convertName:function(name, record) {
        name = record.viewName || name;
        return name.length > 10 ? name.substr(0, 7) + '...' : name;
    },
    convertBigIcon:function(icon, record) {
        return record.isImage ? this.getUrl('file/get.do?type=micro&fid=' + record.id) : this.getUrl('images/icon/big/' + icon);
    },
    convertSmallIcon:function(icon) {
        return this.getUrl('images/icon/small/' + icon);
    },
    convertUrl:function(id) {
        return this.getUrl('file/get.do?fid=' + id);
    }
});

