/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FcPanel.js
 *
 * LastModified: 2009-09-28 07:14:20
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.FcPanel = function(config) {
    Ext.apply(this, config);
    this.addEvents('selectionchange', 'childchange');
    this.backStack = [];
    this.forwardStack = [];
    this.cutIds = [];
    this.copyIds = [];

    var toolBar = new Ext.Toolbar({
        enableOverflow: true,
        items: [
            {
                itemId:'back',
                iconCls:'fc-back',
                text: '后退',
                scope:this,
                handler:function() {
                    this.back();
                }
            },
            {
                itemId:'forward',
                iconCls:'fc-forward',
                text: '前进',
                scope:this,
                handler:function() {
                    this.forward();
                }
            },
            {
                itemId:'refresh',
                iconCls:'fc-refresh',
                text: '刷新',
                scope:this,
                handler:function() {
                    this.refresh();
                }
            },
            {
                itemId:'up',
                iconCls:'fc-up',
                text: '向上',
                scope:this,
                handler:function() {
                    this.up();
                }
            },
            '-',
            {
                itemId:'create',
                iconCls:'fc-create',
                text: '创建',
                scope:this,
                handler:function() {
                    this.create();
                }
            },
            {
                itemId:'upload',
                iconCls:'fc-upload',
                text: '普通上传',
                scope:this,
                handler:function() {
                    this.upload();
                }
            },
            {
                itemId:'uploadOriginal',
                iconCls:'fc-upload',
                text: '直接上传',
                hidden:true,
                scope:this,
                handler:function() {
                    this.uploadOriginal();
                }
            },
            {
                itemId:'uploadExe',
                iconCls:'fc-upload',
                text: '控件上传',
                hidden:true,
                scope:this,
                handler:function() {
                    this.uploadExe();
                }
            },
            {
                itemId:'download',
                iconCls:'fc-download',
                text: '下载',
                scope:this,
                handler:function() {
                    this.showPreview = true;
                    this.download();
                }
            },
            {
                itemId:'preview',
                iconCls:'fc-preview',
                text: '查看',
                scope:this,
                handler:function() {
                    this.showPreview = false;
                    this.preview();
                }
            },

            '-',
            {
                itemId:'zip',
                iconCls:'fc-zip',
                text: '压缩',
                scope:this,
                handler:function() {
                    this.zip();
                }
            },
            {
                itemId:'unzip',
                iconCls:'fc-unzip',
                text: '解压',
                scope:this,
                handler:function() {
                    this.unzip();
                }
            },
            '-',
            {
                itemId:'cut',
                iconCls:'fc-cut',
                text: '剪切',
                scope:this,
                handler:function() {
                    this.cut();
                }
            },
            {
                itemId:'copy',
                iconCls:'fc-copy',
                text: '复制',
                scope:this,
                handler:function() {
                    this.copy();
                }
            },
            {
                itemId:'paste',
                iconCls:'fc-paste',
                text: '粘贴',
                scope:this,
                handler:function() {
                    this.paste();
                }
            },
            {
                itemId:'delete',
                iconCls:'fc-delete',
                text: '删除',
                scope:this,
                handler:function() {
                    this.del();
                }
            },
            '-',
            /*{
                itemId:'edit',
                iconCls:'fc-edit',
                text: '编辑',
                scope:this,
                handler:function() {
                    this.edit();
                }
            },*/
            {
                itemId:'props',
                iconCls:'fc-props',
                text: '属性',
                scope:this,
                handler:function() {
                    this.props();
                }
            },
            '-',
            {
                itemId:'ftp',
                iconCls:'fc-ftp',
                hidden:true,
                text: 'Ftp访问',
                scope:this,
                handler:function() {
                    this.openFtpFolder();
                }
            },
            {
                itemId:'smb',
                iconCls:'fc-smb',
                hidden:true,
                text: '共享访问',
                scope:this,
                handler:function() {
                    this.openSmbFolder();
                }
            },
            '->',
            {
                itemId:'viewMode',
                iconCls:'fc-micro',
                text: '视图',
                menu: {
                    items: [
                        {
                            itemId:'micro',
                            iconCls:'fc-micro',
                            text: '缩略图',
                            scope:this,
                            handler:function() {
                                this.setViewMode('micro');
                            }
                        },
                        {
                            itemId:'tile',
                            iconCls:'fc-tile',
                            text: '平铺',
                            scope:this,
                            handler:function() {
                                this.setViewMode('tile');
                            }
                        },
                        {
                            itemId:'list',
                            iconCls:'fc-list',
                            text: '列表',
                            scope:this,
                            handler:function() {
                                this.setViewMode('list');
                            }
                        }
                        ,
                        {
                            itemId:'webdav',
                            iconCls:'fc-webdav',
                            text: 'web文件夹',
                            scope:this,
                            handler:function() {
                                this.openWebFolder();
                            }
                        }
                    ]
                }
            },
            {
                itemId:'sortMode',
                iconCls:'fc-desc',
                text: '排列',
                menu: {
                    items: [
                        {
                            itemId:'desc',
                            iconCls:'fc-desc',
                            text: '降序',
                            scope:this,
                            handler:function() {
                                this.setSortOrder('DESC');
                                this.getTopToolbar().getComponent('sortMode').setIconClass('fc-desc');
                            }
                        },
                        {
                            itemId:'asc',
                            iconCls:'fc-asc',
                            text: '升序',
                            scope:this,
                            handler:function() {
                                this.setSortOrder('ASC');
                                this.getTopToolbar().getComponent('sortMode').setIconClass('fc-asc');
                            }
                        },
                        '-',
                        {
                            itemId:'byName',
                            iconCls:'fc-byName',
                            text: '名称',
                            scope:this,
                            handler:function() {
                                this.setSortMode('name');
                            }
                        },
                        {
                            itemId:'byTime',
                            iconCls:'fc-byTime',
                            text: '更新时间',
                            scope:this,
                            handler:function() {
                                this.setSortMode('updateTime');
                            }
                        },
                        {
                            itemId:'bySize',
                            iconCls:'fc-bySize',
                            text: '大小',
                            scope:this,
                            handler:function() {
                                this.setSortMode('size');
                            }
                        }
                    ]
                }
            }

        ]});
    this.toolBarBtns = {};
    for (var i = 0; i < toolBar.items.length; i++) {
        var btn = toolBar.items.get(i);
        if (btn.itemId) {
            this.toolBarBtns[btn.itemId] = btn;
        }
    }

    this.contextMenu = new Ext.menu.Menu({
        width:150,
        enableScrolling:false,
        shadow:'frame',
        cls:'fc-context-menu',
        items: [
            {
                itemId:'create',
                iconCls:'fc-create',
                text: '创建',
                scope:this,
                handler:function() {
                    this.create();
                }
            },
            {
                itemId:'upload',
                iconCls:'fc-upload',
                text: '普通上传',
                scope:this,
                handler:function() {
                    this.upload();
                }
            },
            {
                itemId:'uploadOriginal',
                iconCls:'fc-upload',
                text: '直接上传',
                hidden:true,
                scope:this,
                handler:function() {
                    this.uploadOriginal();
                }
            },{
                itemId:'uploadExe',
                iconCls:'fc-upload',
                text: '控件上传',
                hidden:true,
                scope:this,
                handler:function() {
                    this.uploadExe();
                }
            },
            {
                itemId:'download',
                iconCls:'fc-download',
                text: '下载',
                scope:this,
                handler:function() {
                    this.showPreview = true;
                    this.download();
                }
            },
            {
                itemId:'preview',
                iconCls:'fc-preview',
                text: '查看',
                scope:this,
                handler:function() {
                    this.showPreview = false;
                    this.preview();
                }
            },
            {
                itemId:'print',
                iconCls:'fc-print',
                text: '打印',
                scope:this,
                handler:function() {
                    this.imagePrint();
                }
            },
            {
                itemId:'refresh',
                iconCls:'fc-refresh',
                text: '刷新',
                scope:this,
                handler:function() {
                    this.refresh();
                }
            },

            '-',
            {
                itemId:'zip',
                iconCls:'fc-zip',
                text: '压缩',
                scope:this,
                handler:function() {
                    this.zip();
                }
            },
            {
                itemId:'unzip',
                iconCls:'fc-unzip',
                text: '解压',
                scope:this,
                handler:function() {
                    this.unzip();
                }
            },
            '-',
            {
                itemId:'cut',
                iconCls:'fc-cut',
                text: '剪切',
                scope:this,
                handler:function() {
                    this.cut();
                }
            },
            {
                itemId:'copy',
                iconCls:'fc-copy',
                text: '复制',
                scope:this,
                handler:function() {
                    this.copy();
                }
            },
            {
                itemId:'paste',
                iconCls:'fc-paste',
                text: '粘贴',
                scope:this,
                handler:function() {
                    this.paste();
                }
            },
            {
                itemId:'delete',
                iconCls:'fc-delete',
                text: '删除',
                scope:this,
                handler:function() {
                    this.del();
                }
            },
            '-',
            /*{
                itemId:'edit',
                iconCls:'fc-edit',
                text: '编辑',
                scope:this,
                handler:function() {
                    this.edit();
                }
            },*/
            {
                itemId:'props',
                iconCls:'fc-props',
                text: '属性',
                scope:this,
                handler:function() {
                    this.props();
                }
            }
        ]
    });

    this.microView = new Fc.MicroView({store:this.store,readOnly:this.readOnly});
    this.tileView = new Fc.TileView({store:this.store,readOnly:this.readOnly});
    this.listGrid = new Fc.ListGrid({store:this.store});

    this.microView.on({
        'dblclick':function(view, index, node) {
            this.openNode(view.getRecord(node).data);
        },
        'selectionchange':function(view, selections) {
            var datas = [];
            for (var i = 0; i < selections.length; i++) {
                datas.push(view.getRecord(selections[i]).data);
            }
            this.fireEvent('selectionchange', datas);
        },
        scope:this
    });

    this.tileView.on({
        'dblclick':function(view, index, node) {
            this.openNode(view.getRecord(node).data);
        },
        'selectionchange':function(view, selections) {
            var datas = [];
            for (var i = 0; i < selections.length; i++) {
                datas.push(view.getRecord(selections[i]).data);
            }
            this.fireEvent('selectionchange', datas);
        },
        scope:this
    });

    this.listGrid.on({
        'rowdblclick':function(grid) {
            this.openNode(grid.getSelectionModel().getSelected().data);
        },
        scope:this
    });

    this.listGrid.getSelectionModel().on({
        'selectionchange':function(sm) {
            var selections = sm.getSelections();
            var datas = [];
            for (var i = 0; i < selections.length; i++) {
                datas.push(selections[i].data);
            }
            this.fireEvent('selectionchange', datas);
        },
        scope:this
    });

    this.store.on({
        'load':function() {
            this.updateToolbar();
        },
        scope:this
    });

    var activeIndex = 0;
    if (this.viewMode) {
        if (this.viewMode == 'micro') {
            activeIndex = 0;
        } else if (this.viewMode == 'tile') {
            activeIndex = 1;
        } else if (this.viewMode == 'list') {
            activeIndex = 2;
        }
    }

    Fc.FcPanel.superclass.constructor.call(this, {
        cls:'fc-panel',
        region: 'center',
        layout:'card',
        activeItem:activeIndex,
        margins: '2 1 2 0',
        autoScroll: true,
        tbar:toolBar,
        items:[this.microView, this.tileView,this.listGrid]
    });
    this.on({
        'selectionchange':function() {
            this.updateToolbar();
        },
        scope:this
    });
};

Ext.extend(Fc.FcPanel, Ext.Panel, {
    afterRender : function() {
        Fc.FcPanel.superclass.afterRender.call(this);
        this.mon(this.body, {
            contextmenu: this.onContextMenu,
            scope: this
        });
    },
    onContextMenu:function(e) {
        e.stopEvent();
        e.stopPropagation();
        if (!this.contextMenu.el) {
            this.contextMenu.render();
        }
        var xy = e.getXY();
        var dw = Ext.lib.Dom.getViewWidth() - 5;
        var dh = Ext.lib.Dom.getViewHeight() - 5;
        var h = this.contextMenu.el.getHeight();
        var w = this.contextMenu.el.getWidth();
        this.contextMenu.showAt([xy[0] + w > dw ? dw - w : xy[0],xy[1] + h > dh ? dh - h : xy[1]]);
        this.updateContextMenu();
    },
    updateContextMenu:function() {
        var count = this.getCount(), countFlag = count != 1, countFlag1 = count == 0;
        this.setCmBtnState('download', countFlag);
        this.setCmBtnState('preview', countFlag);
        this.setCmBtnState('print', true);
        if(!countFlag && this.getSelections()[0].data.isImage){
            this.setCmBtnState('print', false);
        }
        if (this.readOnly) {
            this.setCmBtnState('create', true);
            this.setCmBtnState('upload', true);
            this.setCmBtnState('uploadOriginal', true);
            this.setCmBtnState('uploadExe', true);
            countFlag = true;
            countFlag1 = true;
        }
        this.setCmBtnState('zip', countFlag1);
        this.setCmBtnState('unzip', countFlag || !/\.zip$/i.test(this.getSelections()[0].data.name));
        this.setCmBtnState('cut', countFlag1);
        this.setCmBtnState('copy', countFlag1);
        this.setCmBtnState('paste', this.cutIds.length == 0 && this.copyIds.length == 0);
        this.setCmBtnState('delete', countFlag1);
        //this.setCmBtnState('edit', countFlag || !this.getSelections()[0].data.isDoc);
        this.setCmBtnState('props', countFlag);
        
        if (this.onlyUpload) {
            this.setCmBtnState('create', false);
            this.setCmBtnState('upload', false);
            this.setCmBtnState('uploadOriginal', false);
            this.setCmBtnState('uploadExe', false);
        }
    },
    setCmBtnState:function(btn, flag) {
        btn = Ext.isString(btn) ? this.contextMenu.getComponent(btn) : btn;
        if (btn.disabled != flag)
            btn.setDisabled(flag);
    },
    updateToolbar:function() {
        var count = this.getCount(), countFlag = count != 1, countFlag1 = count == 0,multiCountFlag = (count < 1);

        this.setBtnState('download', multiCountFlag);
        this.setBtnState('preview', countFlag);
        if (this.readOnly) {
            this.setBtnState('create', true);
            this.setBtnState('upload', true);
            this.setBtnState('uploadOriginal', true);
            this.setBtnState('uploadExe', true);
            countFlag = true;
            countFlag1 = true;
        }
        this.setBtnState('back', this.backStack.length == 0);
        this.setBtnState('forward', this.forwardStack.length == 0);
        this.setBtnState('up', this.getNodeId() == this.rootId);
        this.setBtnState('zip', countFlag1);
        this.setBtnState('unzip', countFlag || !/\.zip$/i.test(this.getSelections()[0].data.name));
        this.setBtnState('cut', countFlag1);
        this.setBtnState('copy', countFlag1);
        this.setBtnState('paste', this.cutIds.length == 0 && this.copyIds.length == 0);
        this.setBtnState('delete', countFlag1);
        //this.setBtnState('edit', countFlag || !this.getSelections()[0].data.isDoc);
        this.setBtnState('props', countFlag);
        
        if (this.onlyUpload) {
            this.setBtnState('create', false);
            this.setBtnState('upload', false);
            this.setBtnState('uploadOriginal', false);
            this.setBtnState('uploadExe', false);
        }
    },
    setBtnState:function(btn, flag) {
        btn = Ext.isString(btn) ? this.toolBarBtns[btn] : btn;
        if (btn && btn.disabled != flag)
            btn.setDisabled(flag);
    },
    getNodeId:function() {
        return this.store.getNodeId();
    },
    loadNode:function(nodeId, params) {
        if (nodeId == this.getNodeId())
            return;
        if (nodeId) {
            var lastId = this.store.getNodeId();
            if (lastId)
                this.backStack.push(lastId);
            if (this.forwardStack.length > 0)
                this.forwardStack = [];
        }
        this.store.loadNode(nodeId, params);
    },
    refresh:function() {
        var obj = this;
        obj.loadNode();
        setTimeout(function(){
            obj.loadNode();
            //obj.store.loadNode(null,null);
        },150);
    },
    up:function() {
        var node = this.store.getCurrentNode();
        if (node.id != this.rootId)
            this.loadNode(node.parentId);
    },
    back:function() {
        if (this.backStack.length > 0) {
            this.forwardStack.push(this.getNodeId());
            this.store.loadNode(this.backStack.pop());
        }
    },
    forward:function() {
        if (this.forwardStack.length > 0) {
            this.backStack.push(this.getNodeId());
            this.store.loadNode(this.forwardStack.pop());
        }
    },
    initCreateDlg:function() {
        this.createDlg = new Fc.PropertiesDialog({getUrl:this.getUrl});
        this.createDlg.on('success', function() {
            this.refresh();
            this.fireEvent('childchange', this.getNodeId(), this);
        }, this);
    },
    create:function() {
        if (!this.createDlg) {
            this.initCreateDlg();
        }
        this.createDlg.show({pnid:this.getNodeId()});
    },
    upload:function() {
        //this.uploadExe();
        if (!this.uploadDialog) {
            this.uploadDialog = new Fc.UploadDialog({
                getUrl:this.getUrl,
                maxSize:100000000000,
                typeDescription:this.fileTypeDescription || '所有文件',
                autoClose:this.autoClose || true,
                fileTypes:this.fileTypes || '*.*'
            });
            this.uploadDialog.on('hide', function() {
                this.refresh();
                this.fireEvent('childchange', this.getNodeId(), this);
            }, this);
        }
        this.uploadDialog.show(this.getNodeId());

        /*openFileLayer(this.getNodeId());*/
    },
    uploadOriginal:function(data) {
        //该方法是直接弹出windows默认的上传界面，支持多选，
        // 原理是直接出发文件上传控件的点击时间，并且给input增加change事件来捕获数据的变化，实现自动上传
        //获取当前节点id：
        if (!data && this.getCount() == 1) {
            data = this.getSelections()[0].data;
        }
        if (!data){
            data = {id:this.getNodeId(),type:0};
        }
        /*if (!(data.type == 1)){
         openFileUploadWindow(data.id);
         }*/
        if (!(data.type == 1)){
            if(confirm("重名文件是否覆盖（确定代表覆盖；取消代表重命名）？")){
                $('#fileCenter_cover_fileupload').val("true");
                $('#fileCenter_rename_fileupload').val("false");
            }else{
                $('#fileCenter_rename_fileupload').val("true");
                $('#fileCenter_cover_fileupload').val("false");
            }
            $('#fileCenter_nid_fileupload').val(data.id);
            var ie = !-[1,];
            if(ie){
                $('#fileCenter_mul_fileupload').trigger('click').trigger('change');
            }else{
                $('#fileCenter_mul_fileupload').trigger('click');
            }
        }
    },
    uploadExe:function(data) {
        //控件上传
        if (!data && this.getCount() == 1) {
            data = this.getSelections()[0].data;
        }
        if (!data){
            data = {id:this.getNodeId(),type:0};
        }
        var dirNodeId = data.id;
        if (data.type == 1){
            dirNodeId = data.parentId;
        }
        var url = 'fcm'+this.fileCenterUrl.replace("http","")+';'+dirNodeId+';;{\\"CanEdit\\":1};0';
        top.location.href = url;
    },
    download:function() {
        if (this.getCount() > 0){
            for(var i=0;i<this.getCount();i++){
                var data = this.getSelections()[i].data;
                if (data.type != 1){
                    if(this.getCount()==1)
                        this.store.loadNode(data.id);
                    else
                        continue;
                }else{
                    //下载时，后台需要根据参与判断，将response的header设置为attachment
                    window.open(this.getSelections()[i].data.url+"&enablePreview="+this.showPreview);
                }
            }
        }

    },
    openNode:function(data) {
        if (data.type == 1)
            this.preview(data);
        else
            this.loadNode(data.id);
    },
    preview:function(data) {
        if (!data && this.getCount() == 1) {
            data = this.getSelections()[0].data;
        }
        if (!data)
            return;

        var url = 'fcm'+this.fileCenterUrl.replace("http","")+';'+this.rootId+';;';
        if(this.readOnly){
            url+='{\\"CanPrint\\":1,\\"FocusedNodeID\\":'+data.id+',\\"CanDownload\\":1,\\"CanRefresh\\":1,\\"CanCreateNewFolder\\":0,\\"CanDelete\\":0,\\"CanRename\\":0,\\"CanUpload\\":0,\\"CanLocalFile\\":0,\\"CanScan\\":0,\\"CanTakePhoto\\":0,\\"CanEdit\\":-1};';
        }else{
            url+='{\\"CanEdit\\":1,\\"FocusedNodeID\\":'+data.id+'};';
        }
        url+='0';
        top.location.href = url;
        /*if (this.enableViewClient) {
            /!*if (!Ext.isDefined(window.hasEPreOcx)) {
                try {
                    new ActiveXObject('GtisOcxShowProj1.GtisOcxShow');
                    window.hasEPreOcx = true;
                } catch (e) {
                    window.hasEPreOcx = false;
                }
            }
            if (window.hasEPreOcx) {
                var url = this.fileCenterUrl;
                url = url.substring(url.indexOf('//') + 2) + "/node/preview.do";
                if (this.token) {
                    url += "?token=" + this.token + "&";
                } else {
                    if (!this.jsessionid) {
                        this.jsessionid = Ext.util.Cookies.get('JSESSIONID');
                    }
                    url += ";jsessionid=" + this.jsessionid + "?";
                }
                location.href = 'epre://' + url + "nid=" + data.id;
                return;
            }*!/
            //原文查看工具只针对常见格式，其余格式直接弹出下载即可
            var icon = data.icon;
            var type = icon.substr(0,icon.indexOf('.'));
            var allowType = "jpg;png;jpeg;bmp;gif;swf;txt;xml;json;doc;docx;xls;xlsx;ppt;pptx;pfd;cad;ceb;";
            if(allowType.indexOf(type+";") > -1){
                //文件预览采用档案原文查看工具
                var url = this.fileCenterUrl;
                url = url.substring(url.indexOf('//') + 2) + "/node/preview.do";
                if (this.token) {
                    url += "?token=" + this.token + "&";
                } else {
                    if (!this.jsessionid) {
                        this.jsessionid = Ext.util.Cookies.get('JSESSIONID');
                    }
                    url += ";jsessionid=" + this.jsessionid + "?";
                }
                location.href = 'epre://' + url + "nid=" + data.id;
            }else{
                this.download();
            }
            return;
        }
        if (!this.showPreview && data.isDoc) {
            this.download();
            return;
        }
        if (!this.previewDialog) {
            this.previewDialog = new Fc.PreviewDialog({
                getUrl:this.getUrl,
                store:this.store,
                readOnly:this.readOnly,
                enableViewClient:this.enableViewClient,
                fileCenterUrl:this.fileCenterUrl,
                maxPreviewDialog:this.maxPreviewDialog,
                pictureFillToDialogSize:this.pictureFillToDialogSize
            });
        }
        this.previewDialog.show(data);*/
    },
    imagePrint:function(data) {
        if (!data && this.getCount() == 1) {
            data = this.getSelections()[0].data;
        }
        if (!data)
            return;
        if(data.isImage){
            var imgurl = "/fileCenter/file/print.do?fid="+data.id;
            //alert(imgurl);
            window.open(imgurl,'print');
        }else{
            alert("只有图片才可以直接打印！");
        }
    },
    setViewMode:function(mode) {
        var l = this.getLayout();
        var active = l.activeItem;
        var vm = this.getTopToolbar().getComponent('viewMode');
        switch (mode) {
            case 'micro':
                if (active != this.microView) {
                    vm.setIconClass('fc-micro');
                    active.setStore(false);
                    this.microView.setStore(this.store);
                    l.setActiveItem(0);
                }
                break;
            case 'tile':
                if (active != this.tileView) {
                    vm.setIconClass('fc-tile');
                    active.setStore(false);
                    this.tileView.setStore(this.store);
                    l.setActiveItem(1);
                }
                break;
            case 'list':
                if (active != this.listGrid) {
                    vm.setIconClass('fc-list');
                    active.setStore(false);
                    this.listGrid.setStore(this.store);
                    l.setActiveItem(2);
                }
                break;
        }
    },
    setSortOrder:function(order) {
        this.store.sort(this.store.sortInfo && this.store.sortInfo.field ? this.store.sortInfo.field : 'name', order);
    },
    setSortMode:function(mode) {
        this.store.sort(mode, this.store.sortInfo && this.store.sortInfo.direction ? this.store.sortInfo.direction : 'ASC');
    },
    getSelections:function() {
        return this.getLayout().activeItem.getSelections();
    },
    getCount:function() {
        return this.getLayout().activeItem.getCount();
    },
    getNodeIds:function() {
        var ids = [], selections = this.getSelections();
        for (var i = 0; i < selections.length; i++) {
            var data = selections[i].data;
            ids.push(data.id);
        }
        return ids;
    },
    zip:function() {
        var path = this.store.getCurrentNode().path;
        var matchs = path.match(/\/([^\/]+)\/$/);
        var name = matchs && matchs.length > 1 ? matchs[1] : '压缩文件';
        if (this.getCount() > 0) {
            if (!this.zipDlg) {
                this.zipDlg = new Fc.ZipDialog({getUrl:this.getUrl});
                this.zipDlg.on('success', function() {
                    this.refresh();
                }, this);
            }
            this.zipDlg.show(this.getNodeId(), this.getNodeIds(), name);
        }
    },
    unzip:function() {
        if (this.getCount() == 1) {
            var data = this.getSelections()[0].data;
            var name = data.name;
            if (!/\.zip$/i.test(name))
                return;
            if (!this.unzipDlg) {
                this.unzipDlg = new Fc.UnzipDialog({getUrl:this.getUrl});
                this.unzipDlg.on('success', function() {
                    this.refresh();
                    this.fireEvent('childchange', this.getNodeId(), this);
                }, this);
            }
            this.unzipDlg.show(data.id, name.substr(0, name.lastIndexOf('.')));
        }
    },
    cut:function() {
        this.copyIds = [];
        this.cutIds = this.getNodeIds();
        this.updateToolbar();
    },
    copy:function() {
        this.cutIds = [];
        this.copyIds = this.getNodeIds();
        this.updateToolbar();
    },
    paste:function() {
        if (this.cutIds.length > 0 || this.copyIds.length > 0) {
            var isCopy = this.copyIds.length > 0;
            Fc.Ajax.request({
                url:this.getUrl('node/' + (isCopy ? 'copy' : 'move') + '.do'),
                params:{nid:isCopy ? this.copyIds : this.cutIds,dnid:this.getNodeId()},
                success:function() {
                    this.copyIds = [];
                    this.cutIds = [];
                    this.refresh();
                    this.fireEvent('childchange', this.getNodeId(), this);
                },
                scope:this
            });
        }
    },
    del:function() {
        var count = this.getCount();
        if (count == 0)
            return;
        Ext.MessageBox.confirm('确认', '确定要删除这 ' + count + ' 项吗?', function(btn) {
            if (btn != 'yes')
                return;
            Fc.Ajax.request({
                url:this.getUrl('node/del.do'),
                params:{nid:this.getNodeIds()},
                success:function() {
                    this.refresh();
                    this.fireEvent('childchange', this.getNodeId(), this);
                },
                scope:this
            });
        }, this);
    },
    props:function() {
        if (this.getCount() == 1) {
            if (!this.createDlg) {
                this.initCreateDlg();
            }
            this.createDlg.show(this.getSelections()[0].data);
        }
    },
    getWebDavUrl:function() {
        return this.store.getEditUrl(this.getSelections()[0].data.name);
    },
    edit:function() {
        var webDavUrl = this.getWebDavUrl();
        if (window.ActiveXObject) {// this is IE
            try {
                var ed = new ActiveXObject('SharePoint.OpenDocuments.2');
                if (ed) {
                    ed.EditDocument(location.protocol + "//" + location.host + webDavUrl);
                    return false;
                } else {
                    window.alert('初始化文件编辑对象错误. 请检查您的offce版本.');
                    return false;
                }
            } catch(e) {
                window.alert('创建文件编辑对象错误. 请检查您的安全设置.');
                return false;
            }
        } /*else if (window.URLLauncher) {// this means the OC firefox plugin is installed
         var wdFile = new URLLauncher();
         // check and see if they have the function we want.
         wdFile.open(webDavUrl);
         } else if (window.InstallTrigger) {
         if (window.confirm('需要先安装webdav插件， 确认要安装吗?')) {
         InstallTrigger.install({'WebDAV Launcher': 'js/webdavloader.xpi'});
         }
         }*/ else {
            window.alert('只支持ie');
        }
        return false;
    },
    openWebFolder:function() {
        window.open(this.store.getEditUrl(''));
    },
    openFtpFolder:function() {
        window.open(this.store.getFtpUrl(''));
    },
    openSmbFolder:function() {
        window.open(this.store.getSmbUrl(''));
    },
    enablePreview:function() {
        this.showPreview = true;
    },
    enableCifs:function() {
        this.toolBarBtns['smb'].show();
    },
    enableFtp:function(enable) {
        this.toolBarBtns['ftp'].show();
    },
    enableOtherUpload:function(enable) {
        this.toolBarBtns['uploadOriginal'].show();
        this.toolBarBtns['uploadExe'].show();
    }
});

