/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FcList.js
 *
 * LastModified: 2009-10-27 04:32:00
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */
/**
 * @cfg {String} token
 * 访问令牌，必须
 */
/**
 * @cfg {Number} nodeId
 * 节点Id，必须
 */
/**
 * @cfg {String} path
 * 上传到的路径，可选
 */
/**
 * @cfg {boolean} all
 * 显示所有文件，可选
 */
/**
 * @cfg {String} uploadWidth
 * 上传窗口宽度，可选
 */
/**
 * @cfg {String} uploadHeight
 * 上传窗口高度，可选
 */
/**
 * @cfg {boolean} hidePreview
 * 是否隐藏预览链接，可选
 */
/**
 * @cfg {boolean} needTransferTIF
 * 是否转换tif文件，可选
 */
/**
 * @cfg {boolean} ocxUpload
 * 是否转换tif文件，可选
 */
/**
 * @cfg {boolean} hideBar
 * config
 */
/**
 * @cfg {boolean} downloadAble
 *  能否下载
 */
/**
 * @cfg {String}desc
 * 上传文件的注释
 */
/**
 * @cfg {Function}success
 * 上传成功callback
 */
Fc.FcList = function (config) {
    var basePath = config.basePath;
    if (basePath && basePath.lastIndexOf('/') != basePath.length - 1)
        config.basePath = basePath + '/';
    var title = config['title'] || '附件列表';
    delete config['title'];

    var self = this;
    this.fnName = this.createFnProxy(function (action, id) {
        self[action](id);
        return false;
    });
    this.tpl = new Ext.XTemplate(
        '<tpl for=".">',
        '<dl class="fc-file" id="fc-node-{id}" title="{name}">',
        '<dt style="background: url({smallIcon}) no-repeat 0 0;"><a href="{url}">{name:ellipsis(30)}</a><em>({size:fileSize})</em></dt>',
        '<dd><div class="left"><p>{updateTime:date("Y-m-d H:i")}</p></div><div class="right">',
        config.downloadAble ? '<a href="#" onclick="return ' + this.fnName + '(\'download\',{id});">下载</a>&nbsp;' : '',
        !config.hidePreview ? '<a href="#" onclick="return ' + this.fnName + '(\'preview\',{id});">查看</a>&nbsp;' : '',
        (config.token && !config.onlyPreview) ? '<tpl if="isDoc"><a href="#" onclick="return ' + this.fnName + '(\'edit\',\'{name}\');">编辑</a></tpl>&nbsp;' +
            '<a href="#" onclick="return ' + this.fnName + '(\'del\',{id});">删除</a>' : '',
        '</div></dd></dl>',
        '</tpl>'
    );

    Ext.apply(this, config);

    var token = config.token;
    this.getUrl = function (action) {
        var ss = action.split('?');
        return [config.basePath, ss[0], '?', (ss.length > 1 ? ss[1] : ''), (token ? '&token=' + token : ''), (self.desc ? '&desc=' + self.desc : '')].join('');
    };
    var getWebdavUrl = function (path) {
        return [config.basePath, 'webdav/', token + '/', config['nodeId'], '/', path].join('');
    };

    var toolBar = new Ext.Toolbar({
        items: [
            '&nbsp;' + title, '->',
            {
                itemId: 'refresh',
                iconCls: 'fc-refresh',
                text: '刷新',
                scope: this,
                handler: function () {
                    this.refresh();
                }
            },
            {
                itemId: 'upload',
                hidden: !this.token,
                iconCls: 'fc-upload',
                text: '上传',
                scope: this,
                handler: function () {
                    this.upload();
                }
            }, '&nbsp;'
        ]
    });
    this.store = new Fc.FcStore({
        baseParams: {fid: this.nodeId, path: this.path, all: this.all},
        url: 'file/list.do',
        getUrl: this.getUrl,
        getWebdavUrl: getWebdavUrl
    });

    var dataView = new Ext.DataView({
        cls: 'fc-files',
        store: this.store,
        tpl: this.tpl,
        emptyText: this.emptyText || '无',
        overClass: 'x-view-over',
        itemSelector: 'dl.fc-file'
    });

    this.store.load();

    Fc.Ajax.request({
        url: this.getUrl('node/config.do'),
        success: function (response) {
            var cfg = Ext.decode(response.responseText);
            this.enableViewClient = cfg.enableViewClient;
            this.fileCenterUrl = cfg.fileCenterUrl;
            this.maxPreviewDialog = cfg.maxPreviewDialog;
            this.pictureFillToDialogSize = cfg.pictureFillToDialogSize;
            this.jsessionid = cfg.jsessionid;
        },
        scope: this
    });

    Fc.FcList.superclass.constructor.call(this, {
        cls: 'fc-files-panel',
        tbar: config['hideBar'] || false ? '' : toolBar,
        items: dataView
    });

};

Ext.extend(Fc.FcList, Ext.Panel, {
    downloadAble: true,
    createFnProxy: function (fn) {
        var fnName = 'fcList' + (++Ext.Component.AUTO_ID);
        Fc[fnName] = fn;
        return 'Fc.' + fnName;
    },
    refresh: function () {
        this.store.reload();
    },
    upload: function () {
        if (!(this.ocxUpload || false)) {
            if (!this.uploadDialog) {
                this.uploadDialog = new Fc.UploadDialog({
                    getUrl: this.getUrl,
                    maxSize: this.maxSize || 100000000000,
                    path: this.path,
                    fileTypes: this.fileTypes || '*.*',
                    autoRename: this.autoRename,
                    autoClose: this.autoClose || true,
                    typeDescription: this.fileTypeDescription || '所有文件'
                });
                this.uploadDialog.on('hide', function () {
                    this.store.reload();
                    if (this.success) {
                        this.success();
                    }
                }, this);
            }
            this.uploadDialog.show(this.nodeId);
        } else {
            var left = (window.screen.width - 550) / 2;
            var top = (window.screen.height - 300) / 2;
            var uploadUrl = this.basePath + 'file/upload.do?userId='+curUser.userId+'&nid=' + this.nodeId + '&token=' + this.token;
            if (this.autoRename || false) {
                uploadUrl += "&rename=true";
            } else {
                uploadUrl += "&cover=true";
            }
            if (this.path) {
                uploadUrl += "&path=" + this.path;
            }
            if (!this.uploadWin) {
                this.uploadWin = window.open("", "_blank", "height=300,width=550,left=" + left + ",top=" + top + ",status=no,toolbar=no,menubar=no,location=no,resizable=no");
                var html = ['<html><head><title>上传</title>',
                    '<script language="javascript" event="OnUploadFinish" for="OcxName">',
                    'window.opener.Ext.getCmp("', this.id, '").store.reload();',
                    'window.close();',
                    '</script><script language="javascript">',
                    'function window.onbeforeunload()',
                    '{window.opener.Ext.getCmp("', this.id, '").uploadWin = null;}',
                    '</script></head><body>',
                    '<OBJECT classid="clsid:F5773E25-381B-498A-9491-3F5A6B3C9A94" codebase="', this.basePath, 'ocx/gtisUploadocx.ocx" width="100%" height="100%" align="center" hspace=0 vspace=0 name="OcxName">',
                    '<param name="needTransferTIF" value="', this.needTransferTIF || false, '">',
                    '<param name="serverURL" value="', uploadUrl, '">',
                    '</OBJECT></body></html>'].join('');
                this.uploadWin.document.write(html);
            } else {
                this.uploadWin.focus();
            }
        }
    },
    download: function (id) {
        window.open(this.store.getById(id).data.url);
    },
    preview: function (id) {
        if (!data && this.getCount() == 1) {
            data = this.getSelections()[0].data;
        }
        if (!data)
            return;

        var url = 'fcm'+this.fileCenterUrl.replace("http","")+';'+this.rootId+';;';
        if(this.readOnly){
            url+='{\\"CanPrint\\":1,\\"FocusedNodeID\\":'+id+',\\"CanDownload\\":1,\\"CanRefresh\\":1,\\"CanCreateNewFolder\\":0,\\"CanDelete\\":0,\\"CanRename\\":0,\\"CanUpload\\":0,\\"CanLocalFile\\":0,\\"CanScan\\":0,\\"CanTakePhoto\\":0,\\"CanEdit\\":-1};';
        }else{
            url+='{\\"CanEdit\\":1,\\"FocusedNodeID\\":'+id+'};';
        }
        url+='0';
        top.location.href = url;
        /*if (this.enableViewClient) {
            if (!Ext.isDefined(window.hasEPreOcx)) {
                try {
                    new ActiveXObject('GtisOcxShowProj1.GtisOcxShow');
                    window.hasEPreOcx = true;
                } catch (e) {
                    window.hasEPreOcx = false;
                }
            }
            if (window.hasEPreOcx) {
                var url = this.fileCenterUrl;
                url = url.substring(url.indexOf('//') + 2) + "/node/preview.do";
                if (this.token) {
                    url += "?token=" + this.token + "&";
                } else {
                    if (!this.jsessionid) {
                        this.jsessionid = Ext.util.Cookies.get('JSESSIONID');
                    }
                    url += ";jsessionid=" + this.jsessionid + "?";
                }
                location.href = 'epre://' + url + "nid=" + id;
                return;
            }
        }
        if (!this.previewDialog) {
            this.previewDialog = new Fc.PreviewDialog({
                store: this.store,
                readOnly: !this.token,
                maxPreviewDialog: this.maxPreviewDialog,
                enableViewClient: this.enableViewClient,
                fileCenterUrl: this.fileCenterUrl,
                pictureFillToDialogSize: this.pictureFillToDialogSize
            });
        }
        this.previewDialog.show(this.store.getById(id).data);*/
    },
    edit: function (name) {
        var webDavUrl = [this.basePath, 'webdav', this.token, this.nodeId, this.path, name].join('/');
        if (window.ActiveXObject) {// this is IE
            try {
                var ed = new ActiveXObject('SharePoint.OpenDocuments.2');
                if (ed) {
                    ed.EditDocument(location.protocol + "//" + location.host + webDavUrl);
                    return false;
                } else {
                    window.alert('初始化文件编辑对象错误. 请检查您的offce版本.');
                    return false;
                }
            } catch (e) {
                window.alert('创建文件编辑对象错误. 请检查您的安全设置.');
                return false;
            }
        } /*else if (window.URLLauncher) {// this means the OC firefox plugin is installed
         var wdFile = new URLLauncher();
         // check and see if they have the function we want.
         wdFile.open(webDavUrl);
         } else if (window.InstallTrigger) {
         if (window.confirm('需要先安装webdav插件， 确认要安装吗?')) {
         InstallTrigger.install({'WebDAV Launcher': 'js/webdavloader.xpi'});
         }
         }*/ else {
            window.alert('只支持ie');
        }
        return false;
    },
    del: function (id) {
        var data = this.store.getById(id).data;
        Ext.MessageBox.confirm('确认', '确定要删除 ' + data.name + ' 吗?', function (btn) {
            if (btn != 'yes')
                return;
            Fc.Ajax.request({
                url: this.getUrl('node/del.do'),
                params: {nid: data.id},
                success: function () {
                    this.store.reload();
                },
                scope: this
            });
        }, this);
    }
});

