/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FcBrowser.js
 *
 * LastModified: 2009-09-28 07:10:17
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

var curUser = {userId:"",userName:""};
Fc.FcBrowser = function (config) {
    var basePath = config.basePath;
    var readOnly = !!config.readOnly;
    curUser.userId = config.userId?config.userId:"";
    curUser.userName = config.userName?config.userName:"";
    var onlyUpload = false;
    if(config.onlyUpload && (config.onlyUpload+"") == "true"){
    	onlyUpload = true;
    }

    if (basePath && basePath.lastIndexOf('/') != basePath.length - 1)
        config.basePath = basePath + '/';
    Ext.apply(this, config);

    var token = config['token'];
    if (token && token.substr(1) == '0') {
        readOnly = true;
    }
    var jsessionid = Ext.util.Cookies.get('JSESSIONID');
    if (!jsessionid) {
        jsessionid = config['jsessionid'];
    }
    var getUrl = function (action) {
        var ss = action.split('?');
        return [config.basePath, ss[0], (jsessionid ? ';jsessionid=' + jsessionid : ''), '?', (ss.length > 1 ? ss[1] : ''), (token ? '&token=' + token : '')].join('');
    };
    var getWebdavUrl = function (path) {
        return [config.basePath, 'webdav/', (token ? token : jsessionid) + '/', config['rootId'], locationBox.getLocation(), path].join('');
    };

    var getFtpUrl = function (path) {
        return ['ftp://', location.hostname, (config['ftpPort'] ? ':' + config['ftpPort'] : ''), '/fileCenter/', (token ? token : jsessionid) + '/', config['rootId'], locationBox.getLocation(), path].join('');
    };

    var getSmbUrl = function (path) {
        return [Ext.isWindows ? 'file:////' : 'smb://', location.hostname, '/fileCenter/', (token ? token : jsessionid) + '/', config['rootId'], locationBox.getLocation(), path].join('');
    };

    var fcStore = new Fc.FcStore({
        getUrl: getUrl,
        getWebdavUrl: getWebdavUrl,
        getFtpUrl: getFtpUrl,
        getSmbUrl: getSmbUrl
    });
    var locationBox = new Fc.LocationBox({
        rootId: this.rootId,
        getUrl: getUrl
    });
    var detailPanel = new Fc.DetailPanel();
    var fcPanel = new Fc.FcPanel({
        id:'fileCenterPanel',
        token: token,
        rootId: this.rootId,
        viewMode: this.viewMode,
        readOnly: readOnly,
        onlyUpload: onlyUpload,
        store: fcStore,
        getUrl: getUrl
    });

    Fc.Ajax.request({
        url: getUrl('node/config.do'),
        success: function (response) {
            var cfg = Ext.decode(response.responseText);
            if (cfg.enablePreview) {
                fcPanel.enablePreview();
            }
            if (cfg.enableCifs) {
                fcPanel.enableCifs();
            }
            if (cfg.enableOtherUpload) {
                fcPanel.enableOtherUpload();
            }
            fcPanel.enableViewClient = cfg.enableViewClient;
            fcPanel.fileCenterUrl = cfg.fileCenterUrl;
            fcPanel.fileCenterUrl = cfg.fileCenterUrl;
            fcPanel.jsessionid = cfg.jsessionid;
            fcPanel.maxPreviewDialog = cfg.maxPreviewDialog;
            fcPanel.enableViewClient = cfg.enableViewClient;
            fcPanel.pictureFillToDialogSize = cfg.pictureFillToDialogSize;
            fcPanel.fileTypes = cfg.fileTypes;
            fcPanel.fileTypeDescription = cfg.fileTypeDescription;
        }
    });
    var treePanel = new Fc.TreePanel({
        rootId: this.rootId,
        fcPanel: fcPanel,
        readOnly: readOnly,
        getUrl: getUrl
    });
    var searchField = new Ext.ux.form.SearchField({
        store: fcStore,
        width: 180,
        value: config.query
    });
    var locationBar = new Ext.Toolbar(
        ['&nbsp;地址&nbsp;', locationBox, {
            text: '转到',
            iconCls: 'fc-goto',
            handler: function () {
                locationBox.go();
            }
        }, '->', searchField, '&nbsp;']);

    locationBar.on({
        'resize': function (bar, width) {
            locationBox.setWidth(width - 275);
        },
        scope: this
    });

    locationBox.on({
        'nodeChange': function (id) {
            treePanel.selectNode(id);
            fcPanel.loadNode(id);
        },
        scope: this
    });

    fcStore.on({
        'load': function (store) {
            var node = store.getCurrentNode();
            if (node.id == this.rootId) {
                locationBox.setRootPath(node.path);
                if (this.showRootName)
                    treePanel.getRootNode().setText(node.name);
            }
            node.showRootName = node.id != this.rootId || this.showRootName;
            locationBox.setLocation(node.id, node.path);
            detailPanel.showDetail([node]);
            treePanel.selectNode(node.id);
            Ext.History.add(node.id);
        },
        'update': function (store, record) {
            var data = record.data;
            data.shortName = store.convertName(data.name, record.data);
            Fc.Ajax.request({
                url: getUrl('node/edit.do'),
                params: {nid: data.id, name: data.name, viewName: data.viewName, description: data.description},
                success: function () {
                    this.fireEvent('datachanged', this.getNodeId(), this);
                },
                scope: store
            });
        },
        'datachanged': function (id) {
            treePanel.reloadNodes([id]);
        },
        'nodechanged': function () {
            searchField.onTrigger1Click();
        },
        scope: this
    });

    treePanel.on({
        'nodeChange': function (id, node) {
            fcPanel.loadNode(id);
            node.expand();
        },
        scope: this
    });

    var timer;

    fcPanel.on({
        'selectionchange': function (datas) {
            if (datas.length == 0)
                datas = [fcStore.getCurrentNode()];
            if (timer)
                clearTimeout(timer);
            timer = setTimeout(function () {
                detailPanel.showDetail(datas);
            }, 200);
        },
        'childchange': function (id) {
            treePanel.reloadNodes([id]);
        },
        scope: this
    });
    var body = Ext.getBody();
    if (Ext.isIE) {
        Ext.DomHelper.append(body, {tag: 'iframe', type: 'hidden', id: "x-history-frame"});
    }
    Ext.DomHelper.append(body, {tag: 'input', type: 'hidden', id: "x-history-field"});
    Ext.History.init();
    Ext.History.on('change', function (token) {
        if (token) {
            fcStore.loadNode(token);
        }
    });

    Fc.FcBrowser.superclass.constructor.call(this, {
        cls: 'fc-main',
        layout: 'border',
        region: 'center',
        border: false,
        tbar: locationBar,
        items: [
            {
                title: '文件夹',
                collapsible: true,
                layout: 'border',
                region: 'west',
                split: true,
                margins: '2 0 2 1',
                collapsed: config.hideTree,
                width: 200,
                minSize: 100,
                maxSize: 500,
                items: [treePanel, detailPanel]
            },
            fcPanel
        ]
    });
    this.on('render', function () {
        treePanel.getRootNode().expand();
        fcPanel.loadNode(this.rootId, config.query ? {query: config.query} : {});
    });
};

Ext.extend(Fc.FcBrowser, Ext.Panel);

