<%@ page language="java" pageEncoding="utf-8" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>文件管理器</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="format-detection" content="telephone=no">

    <script src="${applicationScope.platformurl}/global/jquery/jquery-1.10.2.min.js" type="text/javascript"></script>
    <link rel="stylesheet" href="${applicationScope.platformurl}/global/layui/css/layui.css"  media="all">
    <script src="${applicationScope.platformurl}/global/layui/layui.js" type="text/javascript"></script>
    <style>
        html, body {
            height: 100%;
            padding: 0;
            margin: 0;
            border: none;
            font-family: SimSun,Arial;
            color: #333333;
        }
        .file-container{
            display:none;z-index: 19891038; width: 708px;
        }
        .layui-btn {
            border-radius: 0px;
        }
        .layui-table td, .layui-table th {
            padding: 4px;
        }
        .layui-upload-img{width: 92px; height: 92px; margin: 0 10px 10px 0;}
    </style>

    <script type="text/javascript">
        /*调用jQueryUI实现拖动*/
        $(function() {
            //alert(window.location.search);
            //$('.draggable').draggable();
        });

        var uploadListIns;
        var url = "${applicationScope.filecenterurl}/file/upload.do?rr="+Math.random()*100;
        layui.use('upload', function(){
            var $ = layui.jquery;
            var upload = layui.upload;
            //多文件列表示例
            var demoListView = $('#test-upload-demoList')
            uploadListIns = upload.render({
                elem: '#test-upload-testList'
                ,url: url
                ,accept: 'file'
                ,multiple: true
                ,auto: false
                ,data: {nid:'${rootId}',token:'${token}',multi:true,cover:true,rename:true}
                ,bindAction: '#test-upload-testListAction'
                ,choose: function(obj){
                    var files = this.files = obj.pushFile(); //将每次选择的文件追加到文件队列
                    //读取本地文件
                    obj.preview(function(index, file, result){
                        var tr = $(['<tr id="upload-'+ index +'">'
                            ,'<td>'+ file.name +'</td>'
                            ,'<td>'+ (file.size/1014).toFixed(1) +'kb</td>'
                            ,'<td>等待上传</td>'
                            ,'<td>'
                            ,'<button class="layui-btn layui-btn-xs test-upload-demo-reload layui-hide">重传</button>'
                            ,'<button class="layui-btn layui-btn-xs layui-btn-danger test-upload-demo-delete">删除</button>'
                            ,'</td>'
                            ,'</tr>'].join(''));

                        //单个重传
                        tr.find('.test-upload-demo-reload').on('click', function(){
                            obj.upload(index, file);
                        });

                        //删除
                        tr.find('.test-upload-demo-delete').on('click', function(){
                            delete files[index]; //删除对应的文件
                            tr.remove();
                            uploadListIns.config.elem.next()[0].value = ''; //清空 input file 值，以免删除后出现同名文件不可选
                        });

                        demoListView.append(tr);
                    });
                }
                ,done: function(res, index, upload){
                    if(res.type == 0){ //上传成功
                        var tr = demoListView.find('tr#upload-'+ index)
                                ,tds = tr.children();
                        tds.eq(2).html('<span style="color: #5FB878;">上传成功</span>');
                        tds.eq(3).html(''); //清空操作
                        //alert(1);
                        return delete this.files[index]; //删除文件队列已经上传成功的文件

                        //reloadNode();
                    }
                    this.error(index, upload);
                }
                ,error: function(index, upload){
                    var tr = demoListView.find('tr#upload-'+ index)
                            ,tds = tr.children();
                    tds.eq(2).html('<span style="color: #FF5722;">上传失败</span>');
                    tds.eq(3).find('.test-upload-demo-reload').removeClass('layui-hide'); //显示重传
                }
                ,allDone: function(obj){ //当文件全部被提交后，才触发
                    /*console.log(obj.total); //得到总文件数
                     console.log(obj.successful); //请求成功的文件数
                     console.log(obj.aborted); //请求失败的文件数*/
                    //reloadNode();
                    layer.close(fileLayerIndex);
                    $('#test-upload-demoList').html("");
                    //opener.reloadNode();
                }

            });
        });

        var fileLayerIndex;
        function openFileLayer(curNid){
            if(curNid){
                uploadListIns.config.data.nid=curNid;
            }

            fileLayerIndex=layer.open({
                title:'页面层'
                ,id:'file-layer'
                ,type: 1
                ,shadeClose: true
                ,area: ['700px', '500px']
                ,content: $('#file-layer-modal')
            });
        }

        function showCustonLayer(modalId){
            $('#layui-layer-shade1').show();
            var divTop = ($(window).height()-$('#'+modalId).height()-$('#'+modalId).height())/2;
            if(divTop<50){
                divTop = 50;
            }
            var divLeft = ($(window).width()-$('#'+modalId).width())/2;
            $('#'+modalId).css("top", divTop+"px");
            $('#'+modalId).css("left", divLeft+"px");
            $('#'+modalId).show();
        }
    </script>
</head>

<body>
<div id="file-layer-modal" style="display:none;">
    <div class="layui-col-md12" style="padding:0px 10px 10px 10px;">
        <div class="layui-upload">
            <div class="layui-upload-list">
                <table class="layui-table">
                    <thead>
                    <tr><th>文件名</th>
                        <th>大小</th>
                        <th>状态</th>
                        <th>操作</th>
                    </tr></thead>
                    <tbody id="test-upload-demoList"></tbody>
                </table>
            </div>
            <div class="layui-row">
                <div class="layui-col-xs6" style="text-align: center;">
                    <button type="button" class="layui-btn layui-btn-sm layui-btn-normal" id="test-upload-testList">选择多文件</button>
                </div>
                <div class="layui-col-xs6" style="text-align: center;">
                    <button type="button" class="layui-btn layui-btn-sm" id="test-upload-testListAction">开始上传</button>
                </div>
            </div>
        </div>
    </div>
</div>

<button type="button" class="layui-btn" id="test-upload-page" onclick="openFileLayer()">打开上传窗口</button>
</body>
</html>