/*
 * Compressed by JSA(www.xidea.org)
 */
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: LabelEditor.js
 *
 * LastModified: 2009-09-28 07:19:47
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Ext.DataView.LabelEditor = Ext.extend(Ext.Editor, {
    alignment: "tl-tl",
    hideEl : false,
    cls: "x-small-editor",
    shim: false,
    completeOnEnter: true,
    cancelOnEsc: true,
    labelSelector: 'span.x-editable',

    constructor: function(cfg, field) {
        Ext.DataView.LabelEditor.superclass.constructor.call(this,
                field || new Ext.form.TextField({
                    allowBlank: false,
                    growMin:90,
                    growMax:240,
                    grow:true,
                    selectOnFocus:true
                }), cfg
        );
    },

    init : function(view) {
        this.view = view;
        view.on('render', this.initEditor, this);
        this.on('complete', this.onSave, this);
    },

    initEditor : function() {
        this.view.on({
            scope: this,
            containerclick: this.doBlur,
            click: this.doBlur
        });
        this.view.getEl().on('mousedown', this.onMouseDown, this, {delegate: this.labelSelector});
    },

    doBlur: function() {
        if (this.editing) {
            this.field.blur();
        }
    },

    onMouseDown : function(e, target) {
        if (!e.ctrlKey && !e.shiftKey) {
            var item = this.view.findItemFromChild(target);
            e.stopEvent();
            var record = this.view.store.getAt(this.view.indexOf(item));
            var viewName = record.data[this.viewIndex];
            this.startEdit(target, viewName ? viewName : record.data[this.dataIndex]);
            this.activeRecord = record;
        } else {
            e.preventDefault();
        }
    },

    onSave : function(ed, value) {
        var viewName = this.activeRecord.data[this.viewIndex];
        this.activeRecord.set(viewName ? this.viewIndex : this.dataIndex, value);
    }
});


