/*
 * Compressed by JSA(www.xidea.org)
 */
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: DragSelector.js
 *
 * LastModified: 2009-09-28 07:20:40
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Ext.DataView.DragSelector = function(cfg) {
    cfg = cfg || {};
    var view, proxy, tracker;
    var rs, bodyRegion, dragRegion = new Ext.lib.Region(0, 0, 0, 0);
    var dragSafe = cfg.dragSafe === true;

    this.init = function(dataView) {
        view = dataView;
        view.on('render', onRender);
        view.store.on({
            'load':function() {
                proxy = null;
            }
        });
    };

    function fillRegions() {
        rs = [];
        view.all.each(function(el) {
            rs[rs.length] = el.getRegion();
        });
        bodyRegion = view.el.getRegion();
    }

    function cancelClick() {
        return false;
    }

    function onBeforeStart(e) {
        return !dragSafe || e.target == view.el.dom;
    }

    function onStart() {
        view.on('containerclick', cancelClick, view, {single:true});
        if (!proxy) {
            proxy = view.el.createChild({cls:'x-view-selector'});
        } else {
            proxy.setDisplayed('block');
        }
        fillRegions();
        view.clearSelections();
    }

    function onDrag() {
        var startXY = tracker.startXY;
        var xy = tracker.getXY();

        var x = Math.min(startXY[0], xy[0]);
        var y = Math.min(startXY[1], xy[1]);
        var w = Math.abs(startXY[0] - xy[0]);
        var h = Math.abs(startXY[1] - xy[1]);

        dragRegion.left = x;
        dragRegion.top = y;
        dragRegion.right = x + w;
        dragRegion.bottom = y + h;

        dragRegion.constrainTo(bodyRegion);
        proxy.setRegion(dragRegion);

        for (var i = 0, len = rs.length; i < len; i++) {
            var r = rs[i], sel = dragRegion.intersect(r);
            if (sel && !r.selected) {
                r.selected = true;
                view.select(i, true);
            } else if (!sel && r.selected) {
                r.selected = false;
                view.deselect(i);
            }
        }
    }

    function onEnd() {
        if (!Ext.isIE) {
            view.un('containerclick', cancelClick, view);
        }
        if (proxy) {
            proxy.setDisplayed(false);
        }
    }

    function onRender(view) {
        tracker = new Ext.dd.DragTracker({
            onBeforeStart: onBeforeStart,
            onStart: onStart,
            onDrag: onDrag,
            onEnd: onEnd
        });
        tracker.initEl(view.el);
    }
};

