/*
 * @author oznyang@163.com
 */
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FcUpload.js
 *
 * LastModified: 2009-10-27 03:45:22
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */


/**
 * @cfg {String} token
 * 访问令牌，必须
 */
/**
 * @cfg {Number} nodeId
 * 节点Id，必须
 */
/**
 * @cfg {String} path
 * 上传到的路径，可选
 */
/**
 * @cfg {String}basePath
 * fileCenter web路径
 */
/**
 * @cfg {String}desc
 * 上传文件的注释
 */
/**
 * @cfg {Function}success
 * 上传成功callback
 */
/**
 * @cfg {Function}failure
 * 上传失败callback
 */
var FcUpload = function(config) {
    this.token = '';
    this.nodeId = '';
    this.path = '';
    this.basePath = '';
    this.autoRename = '';
    this.success = this.failure = function() {
    };
    for (var p in config) {
        this[p] = config[p];
    }
};
FcUpload.prototype = {
    upload:function() {
        var doc = document;
        var isStrict = doc.compatMode == "CSS1Compat";
        var left = ((isStrict ? doc.documentElement.clientWidth : doc.body.clientWidth) - 400) / 2;
        var top = ((isStrict ? doc.documentElement.clientHeight : doc.body.clientHeight) - 150) / 2;
        this.uploadFnName = this.createFnProxy(this.success, this.failure, this.uploadFnName);
        this.uploadWin = window.open("", "_blank", "height=130,width=400,left=" + left + ",top=" + top + ",status=no,toolbar=no,menubar=no,location=no,resizable=no");
        var html = ['<html><head><title>上传文件</title>',
            '<style type="text/css">body{font-size:12px;background:menu;}form{margin:0;padding:28px 10px;}input{font-size:12px;}fieldset{padding: 0 10px;}</style>',
            '</head><body><fieldset><legend>文件上传</legend>',
            '<form action="',this.basePath,'file/upload.do" method="post" enctype="multipart/form-data">',
            '<input type="file" name="file" value="浏览" style="width:73%;"/>&nbsp;&nbsp;&nbsp;',
            '<input type="hidden" name="client" value="js"/>',
            '<input type="hidden" name="token" value="',this.token,'"/>',
            '<input type="hidden" name="nid" value="',this.nodeId,'"/>',
            '<input type="hidden" name="path" value="',this.path,'"/>',
            '<input type="hidden" name="callBack" value="',this.uploadFnName,'"/>',
            '<input type="hidden" name="rename" value="',this.autoRename,'"/>',
            '<input type="submit" value=" 上 传 "/></form>',
            '</fieldset></body></html>'].join('');
        this.uploadWin.document.write(html);
    },
    createFnProxy : function(successFn, failureFn, old) {
        if (old) {
            delete window[old];
        }
        var fnName = "fcFnProxy" + (new Date().getTime());
        var self = this;
        window[fnName] = function(res) {
            self.uploadWin.close();
            var basePath = self.basePath;
            if (res.type == 0) {
                var file = res['file'];
                file.url = basePath + 'file/get.do?fid=' + file.id;
                file.smallIcon = basePath + 'images/icon/small/' + file.icon;
                file.bigIcon = file.isImage ? basePath + 'file/get.do?type=micro&fid=' + file.id : basePath + 'images/icon/big/' + file.icon;
                successFn(res.file);
            } else
                failureFn(res.type, res.msg);
        };
        return fnName;
    }
};

