/*
 * @author oznyang@163.com
 */
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: namespaces.js
 *
 * LastModified: 2009-09-28 11:38:50
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */
Ext.ns('Fc', 'Fc.data');
;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: HtmlComponent.js
 *
 * LastModified: 2009-10-14 03:26:10
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.HtmlComponent = Ext.extend(Ext.BoxComponent, {
    onRender : function(ct, position) {
        this.el = ct.createChild({tag: 'div', html: this.html, cls: this.cls, style:this.style});
    }
});

Ext.reg('htmlcomponent', Fc.HtmlComponent);


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: PlainField.js
 *
 * LastModified: 2009-10-14 03:26:55
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.PlainField = Ext.extend(Ext.form.Field, {


    // private
    defaultAutoCreate: {
        tag: 'div',
        cls: 'x-form-plainfield'
    },

    // private
    initComponent: function() {
        Fc.PlainField.superclass.initComponent.call(this);

        if (this.boxLabel && this.fieldLabel)
        {
            this.fieldLabel = this.boxLabel;
            this.hideLabel = false;
        }
        this.addEvents('load');
    },

    getName: function() {
        return this.name;
    },

    // private
    initValue : function() {
        if (this.value !== undefined) {
            this.setValue(this.value);
        } else if (this.el.dom.innerHTML.length > 0) {
            this.setValue(this.el.dom.value);
        }
    },

    getValue : function() {
        return this.value;
    },

    setValue : function(v) {

        if (this.boxLabel)
        {
            if (v == '1')
            {
                v = GO.lang.cmdYes;
            } else
            {
                v = GO.lang.cmdNo;
            }
        }

        this.value = v;
        if (this.rendered) {
            this.el.update(v);
        }
    }

});
Ext.reg('plainfield', Fc.PlainField);


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: Connection.js
 *
 * LastModified: 2009-09-28 11:44:14
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

/**
 * 增加loading-indicator和自动弹出错误的connection
 */
Fc.data.Connection = Ext.extend(Ext.data.Connection, {
    request:function(o) {
        if (!Fc.data.loadingIndicator)
            Fc.data.loadingIndicator = Ext.get("loading-indicator");
        if (Fc.data.loadingIndicator)
            Fc.data.loadingIndicator.setDisplayed(true);
        if (o.callback)
            o.originalCallback = o.callback;
        o.callback = this.errorHandler;
        Fc.data.Connection.superclass.request.call(this, o);
    },
    errorHandler:function(options, success, response) {
        if (Fc.data.loadingIndicator)
            Fc.data.loadingIndicator.setDisplayed(false);
        if (!success) {
            var res = response.responseText;
            if (res.substr(0, 1) == '{') {
                var data=Ext.decode(response.responseText);
                Fc.errorDialog.show(data['msg'],data['detail'],data['type']);
            }
        }
        Ext.callback(options.originalCallback, options.scope, [options, success, response]);
    }
});

Fc.Ajax = new Fc.data.Connection({
    autoAbort:false,
    serializeForm:function(form) {
        return Ext.lib.Ajax.serializeForm(form);
    }
});


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: ErrorResolver.js
 *
 * LastModified: 2009-09-28 05:11:44
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.data.ErrorMsg = {
    '0':'未知错误',
    '1':'未找到该文件或目录',
    '2':'文件或目录已存在',
    '3':'文件访问错误',
    '4':'空间已满，请联系管理员',
    '5':'数据库访问异常，请联系管理员',
    '6':'没有权限'
};

Fc.ErrorDialog = function(config) {
    config = config || {};

    Ext.apply(config, {
        width:400,
        height:250,
        autoHeight:true,
        closeAction:'hide',
        plain:true,
        border:false,
        closable:true,
        title:'错误',
        modal:false,
        items:[
            this.messagePanel = new Ext.FormPanel({
                region:'center',
                cls:'fc-error-dialog',
                border: false
            }),
            this.detailPanel = new Ext.Panel({
                region:'south',
                cls:'fc-error-dialog-detail',
                collapsible:true,
                collapsed:true,
                height:180,
                title:'错误详情',
                titleCollapse:true,
                bodyStyle: 'padding-bottom:15px;background:#eee;'
            })],
        buttons:[
            {
                text:'关闭',
                handler:function() {
                    this.detailPanel.hide();
                    this.hide();
                },
                scope:this
            }
        ]
    });

    Fc.ErrorDialog.superclass.constructor.call(this, config);
};

Ext.extend(Fc.ErrorDialog, Ext.Window, {
    show:function(msg, detail, type) {
        if (!this.rendered)
            this.render(Ext.getBody());
        this.detailPanel.collapse();
        this.messagePanel.body.update(type && Fc.data.ErrorMsg[type] ? Fc.data.ErrorMsg[type] : msg);
        if (!detail) {
            this.detailPanel.hide();
        } else {
            this.detailPanel.show();
            this.detailPanel.body.update('<pre style="height:150px;width:100%;overflow:auto;">' + detail + '</pre>');
        }
        Fc.ErrorDialog.superclass.show.call(this);
    }
});
Fc.errorDialog = new Fc.ErrorDialog();



;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: JsonStore.js
 *
 * LastModified: 2009-09-28 05:05:15
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.data.JsonStore = function(config) {
    Fc.data.JsonStore.superclass.constructor.call(this, config);
    this.on('load', function() {
        this.loaded = true;
    }, this);
    this.on('loadexception', function(proxy, store, response) {
        var res = response.responseText;
        if (res.substr(0, 1) == '{') {
            var data = Ext.decode(response.responseText);
            Fc.errorDialog.show(data['msg'], data['detail'], data['type']);
        }
    }, this);
};

Ext.extend(Fc.data.JsonStore, Ext.data.JsonStore, {
    loaded:false
});


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: DragSelector.js
 *
 * LastModified: 2009-09-28 07:20:40
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Ext.DataView.DragSelector = function(cfg) {
    cfg = cfg || {};
    var view, proxy, tracker;
    var rs, bodyRegion, dragRegion = new Ext.lib.Region(0, 0, 0, 0);
    var dragSafe = cfg.dragSafe === true;

    this.init = function(dataView) {
        view = dataView;
        view.on('render', onRender);
        view.store.on({
            'load':function() {
                proxy = null;
            }
        });
    };

    function fillRegions() {
        rs = [];
        view.all.each(function(el) {
            rs[rs.length] = el.getRegion();
        });
        bodyRegion = view.el.getRegion();
    }

    function cancelClick() {
        return false;
    }

    function onBeforeStart(e) {
        return !dragSafe || e.target == view.el.dom;
    }

    function onStart() {
        view.on('containerclick', cancelClick, view, {single:true});
        if (!proxy) {
            proxy = view.el.createChild({cls:'x-view-selector'});
        } else {
            proxy.setDisplayed('block');
        }
        fillRegions();
        view.clearSelections();
    }

    function onDrag() {
        var startXY = tracker.startXY;
        var xy = tracker.getXY();

        var x = Math.min(startXY[0], xy[0]);
        var y = Math.min(startXY[1], xy[1]);
        var w = Math.abs(startXY[0] - xy[0]);
        var h = Math.abs(startXY[1] - xy[1]);

        dragRegion.left = x;
        dragRegion.top = y;
        dragRegion.right = x + w;
        dragRegion.bottom = y + h;

        dragRegion.constrainTo(bodyRegion);
        proxy.setRegion(dragRegion);

        for (var i = 0, len = rs.length; i < len; i++) {
            var r = rs[i], sel = dragRegion.intersect(r);
            if (sel && !r.selected) {
                r.selected = true;
                view.select(i, true);
            } else if (!sel && r.selected) {
                r.selected = false;
                view.deselect(i);
            }
        }
    }

    function onEnd() {
        if (!Ext.isIE) {
            view.un('containerclick', cancelClick, view);
        }
        if (proxy) {
            proxy.setDisplayed(false);
        }
    }

    function onRender(view) {
        tracker = new Ext.dd.DragTracker({
            onBeforeStart: onBeforeStart,
            onStart: onStart,
            onDrag: onDrag,
            onEnd: onEnd
        });
        tracker.initEl(view.el);
    }
};


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: ImageDragZone.js
 *
 * LastModified: 2009-10-22 04:27:16
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Ext.ux.ImageDragZone = function(view, config) {
    this.view = view;
    ImageDragZone.superclass.constructor.call(this, view.getEl(), config);
};

Ext.extend(Ext.ux.ImageDragZone, Ext.dd.DragZone, {
    // We don't want to register our image elements, so let's
    // override the default registry lookup to fetch the image
    // from the event instead
    getDragData : function(e) {
        var target = e.getTarget('.thumb-wrap');
        if (target) {
            var view = this.view;
            if (!view.isSelected(target)) {
                view.onClick(e);
            }
            var selNodes = view.getSelectedNodes();
            var dragData = {
                nodes: selNodes
            };
            if (selNodes.length == 1) {
                dragData.ddel = target;
                dragData.single = true;
            } else {
                var div = document.createElement('div'); // create the multi element drag "ghost"
                div.className = 'multi-proxy';
                for (var i = 0, len = selNodes.length; i < len; i++) {
                    div.appendChild(selNodes[i].firstChild.firstChild.cloneNode(true)); // image nodes only
                    if ((i + 1) % 3 == 0) {
                        div.appendChild(document.createElement('br'));
                    }
                }
                var count = document.createElement('div'); // selected image count
                count.innerHTML = i + ' images selected';
                div.appendChild(count);

                dragData.ddel = div;
                dragData.multi = true;
            }
            return dragData;
        }
        return false;
    },

    // this method is called by the TreeDropZone after a node drop
    // to get the new tree node (there are also other way, but this is easiest)
    getTreeNode : function() {
        var treeNodes = [];
        var nodeData = this.view.getRecords(this.dragData.nodes);
        for (var i = 0, len = nodeData.length; i < len; i++) {
            var data = nodeData[i].data;
            treeNodes.push(new Ext.tree.TreeNode({
                text: data.name,
                icon: '../view/' + data.url,
                data: data,
                leaf:true,
                cls: 'image-node'
            }));
        }
        return treeNodes;
    },

    // the default action is to "highlight" after a bad drop
    // but since an image can't be highlighted, let's frame it
    afterRepair:function() {
        for (var i = 0, len = this.dragData.nodes.length; i < len; i++) {
            Ext.fly(this.dragData.nodes[i]).frame('#8db2e3', 1);
        }
        this.dragging = false;
    },

    // override the default repairXY with one offset for the margins and padding
    getRepairXY : function(e) {
        if (!this.dragData.multi) {
            var xy = Ext.Element.fly(this.dragData.ddel).getXY();
            xy[0] += 3;
            xy[1] += 3;
            return xy;
        }
        return false;
    }
});



;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: LabelEditor.js
 *
 * LastModified: 2009-09-28 07:19:47
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Ext.DataView.LabelEditor = Ext.extend(Ext.Editor, {
    alignment: "tl-tl",
    hideEl : false,
    cls: "x-small-editor",
    shim: false,
    completeOnEnter: true,
    cancelOnEsc: true,
    labelSelector: 'span.x-editable',

    constructor: function(cfg, field) {
        Ext.DataView.LabelEditor.superclass.constructor.call(this,
                field || new Ext.form.TextField({
                    allowBlank: false,
                    growMin:90,
                    growMax:240,
                    grow:true,
                    selectOnFocus:true
                }), cfg
        );
    },

    init : function(view) {
        this.view = view;
        view.on('render', this.initEditor, this);
        this.on('complete', this.onSave, this);
    },

    initEditor : function() {
        this.view.on({
            scope: this,
            containerclick: this.doBlur,
            click: this.doBlur
        });
        this.view.getEl().on('mousedown', this.onMouseDown, this, {delegate: this.labelSelector});
    },

    doBlur: function() {
        if (this.editing) {
            this.field.blur();
        }
    },

    onMouseDown : function(e, target) {
        if (!e.ctrlKey && !e.shiftKey) {
            var item = this.view.findItemFromChild(target);
            e.stopEvent();
            var record = this.view.store.getAt(this.view.indexOf(item));
            var viewName = record.data[this.viewIndex];
            this.startEdit(target, viewName ? viewName : record.data[this.dataIndex]);
            this.activeRecord = record;
        } else {
            e.preventDefault();
        }
    },

    onSave : function(ed, value) {
        var viewName = this.activeRecord.data[this.viewIndex];
        this.activeRecord.set(viewName ? this.viewIndex : this.dataIndex, value);
    }
});



;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: SearchField.js
 *
 * LastModified: 2009-09-28 07:17:53
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */
Ext.ns('Ext.ux.form');

Ext.ux.form.SearchField = Ext.extend(Ext.form.TwinTriggerField, {
    initComponent : function(){
        Ext.ux.form.SearchField.superclass.initComponent.call(this);
        this.on('specialkey', function(f, e){
            if(e.getKey() == e.ENTER){
                this.onTrigger2Click();
            }
        }, this);
    },

    validationEvent:false,
    validateOnBlur:false,
    trigger1Class:'x-form-clear-trigger',
    trigger2Class:'x-form-search-trigger',
    hideTrigger1:true,
    width:180,
    hasSearch : false,
    paramName : 'query',

    onTrigger1Click : function(){
        if(this.hasSearch){
            this.el.dom.value = '';
            var o = {start: 0};
            this.store.baseParams = this.store.baseParams || {};
            this.store.baseParams[this.paramName] = '';
            this.store.reload({params:o});
            this.triggers[0].hide();
            this.hasSearch = false;
        }
    },

    onTrigger2Click : function(){
        var v = this.getRawValue();
        if(v.length < 1){
            this.onTrigger1Click();
            return;
        }
        var o = {start: 0};
        this.store.baseParams = this.store.baseParams || {};
        this.store.baseParams[this.paramName] = v;
        this.store.reload({params:o});
        this.hasSearch = true;
        this.triggers[0].show();
    }
});

Ext.reg('searchfield', Ext.ux.form.SearchField);


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: DetailPanel.js
 *
 * LastModified: 2009-10-16 09:53:07
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.DetailPanel = function() {

    this.singleTpl = new Ext.XTemplate('<ul class="info">',
            '<tpl if="showRootName"><li style="font-weight:bold;">{name}</li></tpl>',
            '<tpl if="viewName"><li>别名：{viewName}</li></tpl>' +
            '<li style="color:#666">{description:nl2br}</li>',
            '<li>上传者：{owner:nl2br}</li>',
            '<li>时间：{updateTime:date("Y-m-d H:i")}</li>',
            '<tpl if="type==1"><li>大小：{size:fileSize}</li></tpl>',
            '<tpl if="type==2 || type==3">' +
            '<tpl if="size!=-1"><li>总大小：{size:fileSize}</li></tpl>' +
            '<li>已用空间：{usedSize:fileSize}</li>' +
            '<tpl if="size!=-1"><li><div class="fc-use"><div style="width:{[parseInt(values.usedSize/values.size*100)]}%"></div></div></li></tpl></tpl>',
            '<tpl if="type==1"><li style="text-align:center;padding-top:3px;"><img src="{bigIcon}" alt="{name}"/></li></tpl>',
            '<ul>');

    this.multiTpl = new Ext.Template('<ul class="info">',
            '<li>选择了 {count} 个项目</li>',
            '<li>总的文件大小是：{size:fileSize}</li>',
            '<ul>');

    Fc.DetailPanel.superclass.constructor.call(this, {
        height: 200,
        cls:'fc-detail',
        collapsible: true,
        title: '详细信息',
        region: 'south',
        bodyStyle: 'padding-bottom:15px;background:#f3f3f3;',
        autoScroll: true
    });
};

Ext.extend(Fc.DetailPanel, Ext.Panel, {
    showDetail:function(datas) {
        if (datas.length > 1) {
            var size = 0;
            for (var i = 0; i < datas.length; i++) {
                if (datas[i]['type'] == 1)
                    size += datas[i]['size'];
            }
            this.body.update(this.multiTpl.apply({count:datas.length,size:size}));
        } else {
            var data = datas[0];
            data.showRootName = !!data.showRootName;
            this.body.update(this.singleTpl.apply(data));
        }
    }
});




;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FcBrowser.js
 *
 * LastModified: 2009-09-28 07:10:17
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

var curUser = {userId:"",userName:""};
Fc.FcBrowser = function (config) {
    var basePath = config.basePath;
    var readOnly = !!config.readOnly;
    curUser.userId = config.userId?config.userId:"";
    curUser.userName = config.userName?config.userName:"";
    var onlyUpload = false;
    if(config.onlyUpload && (config.onlyUpload+"") == "true"){
    	onlyUpload = true;
    }

    if (basePath && basePath.lastIndexOf('/') != basePath.length - 1)
        config.basePath = basePath + '/';
    Ext.apply(this, config);

    var token = config['token'];
    if (token && token.substr(1) == '0') {
        readOnly = true;
    }
    var jsessionid = Ext.util.Cookies.get('JSESSIONID');
    if (!jsessionid) {
        jsessionid = config['jsessionid'];
    }
    var getUrl = function (action) {
        var ss = action.split('?');
        return [config.basePath, ss[0], (jsessionid ? ';jsessionid=' + jsessionid : ''), '?', (ss.length > 1 ? ss[1] : ''), (token ? '&token=' + token : '')].join('');
    };
    var getWebdavUrl = function (path) {
        return [config.basePath, 'webdav/', (token ? token : jsessionid) + '/', config['rootId'], locationBox.getLocation(), path].join('');
    };

    var getFtpUrl = function (path) {
        return ['ftp://', location.hostname, (config['ftpPort'] ? ':' + config['ftpPort'] : ''), '/fileCenter/', (token ? token : jsessionid) + '/', config['rootId'], locationBox.getLocation(), path].join('');
    };

    var getSmbUrl = function (path) {
        return [Ext.isWindows ? 'file:////' : 'smb://', location.hostname, '/fileCenter/', (token ? token : jsessionid) + '/', config['rootId'], locationBox.getLocation(), path].join('');
    };

    var fcStore = new Fc.FcStore({
        getUrl: getUrl,
        getWebdavUrl: getWebdavUrl,
        getFtpUrl: getFtpUrl,
        getSmbUrl: getSmbUrl
    });
    var locationBox = new Fc.LocationBox({
        rootId: this.rootId,
        getUrl: getUrl
    });
    var detailPanel = new Fc.DetailPanel();
    var fcPanel = new Fc.FcPanel({
        id:'fileCenterPanel',
        token: token,
        rootId: this.rootId,
        viewMode: this.viewMode,
        readOnly: readOnly,
        onlyUpload: onlyUpload,
        store: fcStore,
        getUrl: getUrl
    });

    Fc.Ajax.request({
        url: getUrl('node/config.do'),
        success: function (response) {
            var cfg = Ext.decode(response.responseText);
            if (cfg.enablePreview) {
                fcPanel.enablePreview();
            }
            if (cfg.enableCifs) {
                fcPanel.enableCifs();
            }
            if (cfg.enableOtherUpload) {
                fcPanel.enableOtherUpload();
            }
            fcPanel.enableViewClient = cfg.enableViewClient;
            fcPanel.fileCenterUrl = cfg.fileCenterUrl;
            fcPanel.fileCenterUrl = cfg.fileCenterUrl;
            fcPanel.jsessionid = cfg.jsessionid;
            fcPanel.maxPreviewDialog = cfg.maxPreviewDialog;
            fcPanel.enableViewClient = cfg.enableViewClient;
            fcPanel.pictureFillToDialogSize = cfg.pictureFillToDialogSize;
            fcPanel.fileTypes = cfg.fileTypes;
            fcPanel.fileTypeDescription = cfg.fileTypeDescription;
        }
    });
    var treePanel = new Fc.TreePanel({
        rootId: this.rootId,
        fcPanel: fcPanel,
        readOnly: readOnly,
        getUrl: getUrl
    });
    var searchField = new Ext.ux.form.SearchField({
        store: fcStore,
        width: 180,
        value: config.query
    });
    var locationBar = new Ext.Toolbar(
        ['&nbsp;地址&nbsp;', locationBox, {
            text: '转到',
            iconCls: 'fc-goto',
            handler: function () {
                locationBox.go();
            }
        }, '->', searchField, '&nbsp;']);

    locationBar.on({
        'resize': function (bar, width) {
            locationBox.setWidth(width - 275);
        },
        scope: this
    });

    locationBox.on({
        'nodeChange': function (id) {
            treePanel.selectNode(id);
            fcPanel.loadNode(id);
        },
        scope: this
    });

    fcStore.on({
        'load': function (store) {
            var node = store.getCurrentNode();
            if (node.id == this.rootId) {
                locationBox.setRootPath(node.path);
                if (this.showRootName)
                    treePanel.getRootNode().setText(node.name);
            }
            node.showRootName = node.id != this.rootId || this.showRootName;
            locationBox.setLocation(node.id, node.path);
            detailPanel.showDetail([node]);
            treePanel.selectNode(node.id);
            Ext.History.add(node.id);
        },
        'update': function (store, record) {
            var data = record.data;
            data.shortName = store.convertName(data.name, record.data);
            Fc.Ajax.request({
                url: getUrl('node/edit.do'),
                params: {nid: data.id, name: data.name, viewName: data.viewName, description: data.description},
                success: function () {
                    this.fireEvent('datachanged', this.getNodeId(), this);
                },
                scope: store
            });
        },
        'datachanged': function (id) {
            treePanel.reloadNodes([id]);
        },
        'nodechanged': function () {
            searchField.onTrigger1Click();
        },
        scope: this
    });

    treePanel.on({
        'nodeChange': function (id, node) {
            fcPanel.loadNode(id);
            node.expand();
        },
        scope: this
    });

    var timer;

    fcPanel.on({
        'selectionchange': function (datas) {
            if (datas.length == 0)
                datas = [fcStore.getCurrentNode()];
            if (timer)
                clearTimeout(timer);
            timer = setTimeout(function () {
                detailPanel.showDetail(datas);
            }, 200);
        },
        'childchange': function (id) {
            treePanel.reloadNodes([id]);
        },
        scope: this
    });
    var body = Ext.getBody();
    if (Ext.isIE) {
        Ext.DomHelper.append(body, {tag: 'iframe', type: 'hidden', id: "x-history-frame"});
    }
    Ext.DomHelper.append(body, {tag: 'input', type: 'hidden', id: "x-history-field"});
    Ext.History.init();
    Ext.History.on('change', function (token) {
        if (token) {
            fcStore.loadNode(token);
        }
    });

    Fc.FcBrowser.superclass.constructor.call(this, {
        cls: 'fc-main',
        layout: 'border',
        region: 'center',
        border: false,
        tbar: locationBar,
        items: [
            {
                title: '文件夹',
                collapsible: true,
                layout: 'border',
                region: 'west',
                split: true,
                margins: '2 0 2 1',
                collapsed: config.hideTree,
                width: 200,
                minSize: 100,
                maxSize: 500,
                items: [treePanel, detailPanel]
            },
            fcPanel
        ]
    });
    this.on('render', function () {
        treePanel.getRootNode().expand();
        fcPanel.loadNode(this.rootId, config.query ? {query: config.query} : {});
    });
};

Ext.extend(Fc.FcBrowser, Ext.Panel);


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FcList.js
 *
 * LastModified: 2009-10-27 04:32:00
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */
/**
 * @cfg {String} token
 * 访问令牌，必须
 */
/**
 * @cfg {Number} nodeId
 * 节点Id，必须
 */
/**
 * @cfg {String} path
 * 上传到的路径，可选
 */
/**
 * @cfg {boolean} all
 * 显示所有文件，可选
 */
/**
 * @cfg {String} uploadWidth
 * 上传窗口宽度，可选
 */
/**
 * @cfg {String} uploadHeight
 * 上传窗口高度，可选
 */
/**
 * @cfg {boolean} hidePreview
 * 是否隐藏预览链接，可选
 */
/**
 * @cfg {boolean} needTransferTIF
 * 是否转换tif文件，可选
 */
/**
 * @cfg {boolean} ocxUpload
 * 是否转换tif文件，可选
 */
/**
 * @cfg {boolean} hideBar
 * config
 */
/**
 * @cfg {boolean} downloadAble
 *  能否下载
 */
/**
 * @cfg {String}desc
 * 上传文件的注释
 */
/**
 * @cfg {Function}success
 * 上传成功callback
 */
Fc.FcList = function (config) {
    var basePath = config.basePath;
    if (basePath && basePath.lastIndexOf('/') != basePath.length - 1)
        config.basePath = basePath + '/';
    var title = config['title'] || '附件列表';
    delete config['title'];

    var self = this;
    this.fnName = this.createFnProxy(function (action, id) {
        self[action](id);
        return false;
    });
    this.tpl = new Ext.XTemplate(
        '<tpl for=".">',
        '<dl class="fc-file" id="fc-node-{id}" title="{name}">',
        '<dt style="background: url({smallIcon}) no-repeat 0 0;"><a href="{url}">{name:ellipsis(30)}</a><em>({size:fileSize})</em></dt>',
        '<dd><div class="left"><p>{updateTime:date("Y-m-d H:i")}</p></div><div class="right">',
        config.downloadAble ? '<a href="#" onclick="return ' + this.fnName + '(\'download\',{id});">下载</a>&nbsp;' : '',
        !config.hidePreview ? '<a href="#" onclick="return ' + this.fnName + '(\'preview\',{id});">查看</a>&nbsp;' : '',
        (config.token && !config.onlyPreview) ? '<tpl if="isDoc"><a href="#" onclick="return ' + this.fnName + '(\'edit\',\'{name}\');">编辑</a></tpl>&nbsp;' +
            '<a href="#" onclick="return ' + this.fnName + '(\'del\',{id});">删除</a>' : '',
        '</div></dd></dl>',
        '</tpl>'
    );

    Ext.apply(this, config);

    var token = config.token;
    this.getUrl = function (action) {
        var ss = action.split('?');
        return [config.basePath, ss[0], '?', (ss.length > 1 ? ss[1] : ''), (token ? '&token=' + token : ''), (self.desc ? '&desc=' + self.desc : '')].join('');
    };
    var getWebdavUrl = function (path) {
        return [config.basePath, 'webdav/', token + '/', config['nodeId'], '/', path].join('');
    };

    var toolBar = new Ext.Toolbar({
        items: [
            '&nbsp;' + title, '->',
            {
                itemId: 'refresh',
                iconCls: 'fc-refresh',
                text: '刷新',
                scope: this,
                handler: function () {
                    this.refresh();
                }
            },
            {
                itemId: 'upload',
                hidden: !this.token,
                iconCls: 'fc-upload',
                text: '上传',
                scope: this,
                handler: function () {
                    this.upload();
                }
            }, '&nbsp;'
        ]
    });
    this.store = new Fc.FcStore({
        baseParams: {fid: this.nodeId, path: this.path, all: this.all},
        url: 'file/list.do',
        getUrl: this.getUrl,
        getWebdavUrl: getWebdavUrl
    });

    var dataView = new Ext.DataView({
        cls: 'fc-files',
        store: this.store,
        tpl: this.tpl,
        emptyText: this.emptyText || '无',
        overClass: 'x-view-over',
        itemSelector: 'dl.fc-file'
    });

    this.store.load();

    Fc.Ajax.request({
        url: this.getUrl('node/config.do'),
        success: function (response) {
            var cfg = Ext.decode(response.responseText);
            this.enableViewClient = cfg.enableViewClient;
            this.fileCenterUrl = cfg.fileCenterUrl;
            this.maxPreviewDialog = cfg.maxPreviewDialog;
            this.pictureFillToDialogSize = cfg.pictureFillToDialogSize;
            this.jsessionid = cfg.jsessionid;
        },
        scope: this
    });

    Fc.FcList.superclass.constructor.call(this, {
        cls: 'fc-files-panel',
        tbar: config['hideBar'] || false ? '' : toolBar,
        items: dataView
    });

};

Ext.extend(Fc.FcList, Ext.Panel, {
    downloadAble: true,
    createFnProxy: function (fn) {
        var fnName = 'fcList' + (++Ext.Component.AUTO_ID);
        Fc[fnName] = fn;
        return 'Fc.' + fnName;
    },
    refresh: function () {
        this.store.reload();
    },
    upload: function () {
        if (!(this.ocxUpload || false)) {
            if (!this.uploadDialog) {
                this.uploadDialog = new Fc.UploadDialog({
                    getUrl: this.getUrl,
                    maxSize: this.maxSize || 100000000000,
                    path: this.path,
                    fileTypes: this.fileTypes || '*.*',
                    autoRename: this.autoRename,
                    autoClose: this.autoClose || true,
                    typeDescription: this.fileTypeDescription || '所有文件'
                });
                this.uploadDialog.on('hide', function () {
                    this.store.reload();
                    if (this.success) {
                        this.success();
                    }
                }, this);
            }
            this.uploadDialog.show(this.nodeId);
        } else {
            var left = (window.screen.width - 550) / 2;
            var top = (window.screen.height - 300) / 2;
            var uploadUrl = this.basePath + 'file/upload.do?userId='+curUser.userId+'&nid=' + this.nodeId + '&token=' + this.token;
            if (this.autoRename || false) {
                uploadUrl += "&rename=true";
            } else {
                uploadUrl += "&cover=true";
            }
            if (this.path) {
                uploadUrl += "&path=" + this.path;
            }
            if (!this.uploadWin) {
                this.uploadWin = window.open("", "_blank", "height=300,width=550,left=" + left + ",top=" + top + ",status=no,toolbar=no,menubar=no,location=no,resizable=no");
                var html = ['<html><head><title>上传</title>',
                    '<script language="javascript" event="OnUploadFinish" for="OcxName">',
                    'window.opener.Ext.getCmp("', this.id, '").store.reload();',
                    'window.close();',
                    '</script><script language="javascript">',
                    'function window.onbeforeunload()',
                    '{window.opener.Ext.getCmp("', this.id, '").uploadWin = null;}',
                    '</script></head><body>',
                    '<OBJECT classid="clsid:F5773E25-381B-498A-9491-3F5A6B3C9A94" codebase="', this.basePath, 'ocx/gtisUploadocx.ocx" width="100%" height="100%" align="center" hspace=0 vspace=0 name="OcxName">',
                    '<param name="needTransferTIF" value="', this.needTransferTIF || false, '">',
                    '<param name="serverURL" value="', uploadUrl, '">',
                    '</OBJECT></body></html>'].join('');
                this.uploadWin.document.write(html);
            } else {
                this.uploadWin.focus();
            }
        }
    },
    download: function (id) {
        window.open(this.store.getById(id).data.url);
    },
    preview: function (id) {
        if (!data && this.getCount() == 1) {
            data = this.getSelections()[0].data;
        }
        if (!data)
            return;

        var url = 'fcm'+this.fileCenterUrl.replace("http","")+';'+this.rootId+';;';
        if(this.readOnly){
            url+='{\\"CanPrint\\":1,\\"FocusedNodeID\\":'+id+',\\"CanDownload\\":1,\\"CanRefresh\\":1,\\"CanCreateNewFolder\\":0,\\"CanDelete\\":0,\\"CanRename\\":0,\\"CanUpload\\":0,\\"CanLocalFile\\":0,\\"CanScan\\":0,\\"CanTakePhoto\\":0,\\"CanEdit\\":-1};';
        }else{
            url+='{\\"CanEdit\\":1,\\"FocusedNodeID\\":'+id+'};';
        }
        url+='0';
        top.location.href = url;
        /*if (this.enableViewClient) {
            if (!Ext.isDefined(window.hasEPreOcx)) {
                try {
                    new ActiveXObject('GtisOcxShowProj1.GtisOcxShow');
                    window.hasEPreOcx = true;
                } catch (e) {
                    window.hasEPreOcx = false;
                }
            }
            if (window.hasEPreOcx) {
                var url = this.fileCenterUrl;
                url = url.substring(url.indexOf('//') + 2) + "/node/preview.do";
                if (this.token) {
                    url += "?token=" + this.token + "&";
                } else {
                    if (!this.jsessionid) {
                        this.jsessionid = Ext.util.Cookies.get('JSESSIONID');
                    }
                    url += ";jsessionid=" + this.jsessionid + "?";
                }
                location.href = 'epre://' + url + "nid=" + id;
                return;
            }
        }
        if (!this.previewDialog) {
            this.previewDialog = new Fc.PreviewDialog({
                store: this.store,
                readOnly: !this.token,
                maxPreviewDialog: this.maxPreviewDialog,
                enableViewClient: this.enableViewClient,
                fileCenterUrl: this.fileCenterUrl,
                pictureFillToDialogSize: this.pictureFillToDialogSize
            });
        }
        this.previewDialog.show(this.store.getById(id).data);*/
    },
    edit: function (name) {
        var webDavUrl = [this.basePath, 'webdav', this.token, this.nodeId, this.path, name].join('/');
        if (window.ActiveXObject) {// this is IE
            try {
                var ed = new ActiveXObject('SharePoint.OpenDocuments.2');
                if (ed) {
                    ed.EditDocument(location.protocol + "//" + location.host + webDavUrl);
                    return false;
                } else {
                    window.alert('初始化文件编辑对象错误. 请检查您的offce版本.');
                    return false;
                }
            } catch (e) {
                window.alert('创建文件编辑对象错误. 请检查您的安全设置.');
                return false;
            }
        } /*else if (window.URLLauncher) {// this means the OC firefox plugin is installed
         var wdFile = new URLLauncher();
         // check and see if they have the function we want.
         wdFile.open(webDavUrl);
         } else if (window.InstallTrigger) {
         if (window.confirm('需要先安装webdav插件， 确认要安装吗?')) {
         InstallTrigger.install({'WebDAV Launcher': 'js/webdavloader.xpi'});
         }
         }*/ else {
            window.alert('只支持ie');
        }
        return false;
    },
    del: function (id) {
        var data = this.store.getById(id).data;
        Ext.MessageBox.confirm('确认', '确定要删除 ' + data.name + ' 吗?', function (btn) {
            if (btn != 'yes')
                return;
            Fc.Ajax.request({
                url: this.getUrl('node/del.do'),
                params: {nid: data.id},
                success: function () {
                    this.store.reload();
                },
                scope: this
            });
        }, this);
    }
});


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FcPanel.js
 *
 * LastModified: 2009-09-28 07:14:20
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.FcPanel = function(config) {
    Ext.apply(this, config);
    this.addEvents('selectionchange', 'childchange');
    this.backStack = [];
    this.forwardStack = [];
    this.cutIds = [];
    this.copyIds = [];

    var toolBar = new Ext.Toolbar({
        enableOverflow: true,
        items: [
            {
                itemId:'back',
                iconCls:'fc-back',
                text: '后退',
                scope:this,
                handler:function() {
                    this.back();
                }
            },
            {
                itemId:'forward',
                iconCls:'fc-forward',
                text: '前进',
                scope:this,
                handler:function() {
                    this.forward();
                }
            },
            {
                itemId:'refresh',
                iconCls:'fc-refresh',
                text: '刷新',
                scope:this,
                handler:function() {
                    this.refresh();
                }
            },
            {
                itemId:'up',
                iconCls:'fc-up',
                text: '向上',
                scope:this,
                handler:function() {
                    this.up();
                }
            },
            '-',
            {
                itemId:'create',
                iconCls:'fc-create',
                text: '创建',
                scope:this,
                handler:function() {
                    this.create();
                }
            },
            {
                itemId:'upload',
                iconCls:'fc-upload',
                text: '普通上传',
                scope:this,
                handler:function() {
                    this.upload();
                }
            },
            {
                itemId:'uploadOriginal',
                iconCls:'fc-upload',
                text: '直接上传',
                hidden:true,
                scope:this,
                handler:function() {
                    this.uploadOriginal();
                }
            },
            {
                itemId:'uploadExe',
                iconCls:'fc-upload',
                text: '控件上传',
                hidden:true,
                scope:this,
                handler:function() {
                    this.uploadExe();
                }
            },
            {
                itemId:'download',
                iconCls:'fc-download',
                text: '下载',
                scope:this,
                handler:function() {
                    this.showPreview = true;
                    this.download();
                }
            },
            {
                itemId:'preview',
                iconCls:'fc-preview',
                text: '查看',
                scope:this,
                handler:function() {
                    this.showPreview = false;
                    this.preview();
                }
            },

            '-',
            {
                itemId:'zip',
                iconCls:'fc-zip',
                text: '压缩',
                scope:this,
                handler:function() {
                    this.zip();
                }
            },
            {
                itemId:'unzip',
                iconCls:'fc-unzip',
                text: '解压',
                scope:this,
                handler:function() {
                    this.unzip();
                }
            },
            '-',
            {
                itemId:'cut',
                iconCls:'fc-cut',
                text: '剪切',
                scope:this,
                handler:function() {
                    this.cut();
                }
            },
            {
                itemId:'copy',
                iconCls:'fc-copy',
                text: '复制',
                scope:this,
                handler:function() {
                    this.copy();
                }
            },
            {
                itemId:'paste',
                iconCls:'fc-paste',
                text: '粘贴',
                scope:this,
                handler:function() {
                    this.paste();
                }
            },
            {
                itemId:'delete',
                iconCls:'fc-delete',
                text: '删除',
                scope:this,
                handler:function() {
                    this.del();
                }
            },
            '-',
            /*{
                itemId:'edit',
                iconCls:'fc-edit',
                text: '编辑',
                scope:this,
                handler:function() {
                    this.edit();
                }
            },*/
            {
                itemId:'props',
                iconCls:'fc-props',
                text: '属性',
                scope:this,
                handler:function() {
                    this.props();
                }
            },
            '-',
            {
                itemId:'ftp',
                iconCls:'fc-ftp',
                hidden:true,
                text: 'Ftp访问',
                scope:this,
                handler:function() {
                    this.openFtpFolder();
                }
            },
            {
                itemId:'smb',
                iconCls:'fc-smb',
                hidden:true,
                text: '共享访问',
                scope:this,
                handler:function() {
                    this.openSmbFolder();
                }
            },
            '->',
            {
                itemId:'viewMode',
                iconCls:'fc-micro',
                text: '视图',
                menu: {
                    items: [
                        {
                            itemId:'micro',
                            iconCls:'fc-micro',
                            text: '缩略图',
                            scope:this,
                            handler:function() {
                                this.setViewMode('micro');
                            }
                        },
                        {
                            itemId:'tile',
                            iconCls:'fc-tile',
                            text: '平铺',
                            scope:this,
                            handler:function() {
                                this.setViewMode('tile');
                            }
                        },
                        {
                            itemId:'list',
                            iconCls:'fc-list',
                            text: '列表',
                            scope:this,
                            handler:function() {
                                this.setViewMode('list');
                            }
                        }
                        ,
                        {
                            itemId:'webdav',
                            iconCls:'fc-webdav',
                            text: 'web文件夹',
                            scope:this,
                            handler:function() {
                                this.openWebFolder();
                            }
                        }
                    ]
                }
            },
            {
                itemId:'sortMode',
                iconCls:'fc-desc',
                text: '排列',
                menu: {
                    items: [
                        {
                            itemId:'desc',
                            iconCls:'fc-desc',
                            text: '降序',
                            scope:this,
                            handler:function() {
                                this.setSortOrder('DESC');
                                this.getTopToolbar().getComponent('sortMode').setIconClass('fc-desc');
                            }
                        },
                        {
                            itemId:'asc',
                            iconCls:'fc-asc',
                            text: '升序',
                            scope:this,
                            handler:function() {
                                this.setSortOrder('ASC');
                                this.getTopToolbar().getComponent('sortMode').setIconClass('fc-asc');
                            }
                        },
                        '-',
                        {
                            itemId:'byName',
                            iconCls:'fc-byName',
                            text: '名称',
                            scope:this,
                            handler:function() {
                                this.setSortMode('name');
                            }
                        },
                        {
                            itemId:'byTime',
                            iconCls:'fc-byTime',
                            text: '更新时间',
                            scope:this,
                            handler:function() {
                                this.setSortMode('updateTime');
                            }
                        },
                        {
                            itemId:'bySize',
                            iconCls:'fc-bySize',
                            text: '大小',
                            scope:this,
                            handler:function() {
                                this.setSortMode('size');
                            }
                        }
                    ]
                }
            }

        ]});
    this.toolBarBtns = {};
    for (var i = 0; i < toolBar.items.length; i++) {
        var btn = toolBar.items.get(i);
        if (btn.itemId) {
            this.toolBarBtns[btn.itemId] = btn;
        }
    }

    this.contextMenu = new Ext.menu.Menu({
        width:150,
        enableScrolling:false,
        shadow:'frame',
        cls:'fc-context-menu',
        items: [
            {
                itemId:'create',
                iconCls:'fc-create',
                text: '创建',
                scope:this,
                handler:function() {
                    this.create();
                }
            },
            {
                itemId:'upload',
                iconCls:'fc-upload',
                text: '普通上传',
                scope:this,
                handler:function() {
                    this.upload();
                }
            },
            {
                itemId:'uploadOriginal',
                iconCls:'fc-upload',
                text: '直接上传',
                hidden:true,
                scope:this,
                handler:function() {
                    this.uploadOriginal();
                }
            },{
                itemId:'uploadExe',
                iconCls:'fc-upload',
                text: '控件上传',
                hidden:true,
                scope:this,
                handler:function() {
                    this.uploadExe();
                }
            },
            {
                itemId:'download',
                iconCls:'fc-download',
                text: '下载',
                scope:this,
                handler:function() {
                    this.showPreview = true;
                    this.download();
                }
            },
            {
                itemId:'preview',
                iconCls:'fc-preview',
                text: '查看',
                scope:this,
                handler:function() {
                    this.showPreview = false;
                    this.preview();
                }
            },
            {
                itemId:'print',
                iconCls:'fc-print',
                text: '打印',
                scope:this,
                handler:function() {
                    this.imagePrint();
                }
            },
            {
                itemId:'refresh',
                iconCls:'fc-refresh',
                text: '刷新',
                scope:this,
                handler:function() {
                    this.refresh();
                }
            },

            '-',
            {
                itemId:'zip',
                iconCls:'fc-zip',
                text: '压缩',
                scope:this,
                handler:function() {
                    this.zip();
                }
            },
            {
                itemId:'unzip',
                iconCls:'fc-unzip',
                text: '解压',
                scope:this,
                handler:function() {
                    this.unzip();
                }
            },
            '-',
            {
                itemId:'cut',
                iconCls:'fc-cut',
                text: '剪切',
                scope:this,
                handler:function() {
                    this.cut();
                }
            },
            {
                itemId:'copy',
                iconCls:'fc-copy',
                text: '复制',
                scope:this,
                handler:function() {
                    this.copy();
                }
            },
            {
                itemId:'paste',
                iconCls:'fc-paste',
                text: '粘贴',
                scope:this,
                handler:function() {
                    this.paste();
                }
            },
            {
                itemId:'delete',
                iconCls:'fc-delete',
                text: '删除',
                scope:this,
                handler:function() {
                    this.del();
                }
            },
            '-',
            /*{
                itemId:'edit',
                iconCls:'fc-edit',
                text: '编辑',
                scope:this,
                handler:function() {
                    this.edit();
                }
            },*/
            {
                itemId:'props',
                iconCls:'fc-props',
                text: '属性',
                scope:this,
                handler:function() {
                    this.props();
                }
            }
        ]
    });

    this.microView = new Fc.MicroView({store:this.store,readOnly:this.readOnly});
    this.tileView = new Fc.TileView({store:this.store,readOnly:this.readOnly});
    this.listGrid = new Fc.ListGrid({store:this.store});

    this.microView.on({
        'dblclick':function(view, index, node) {
            this.openNode(view.getRecord(node).data);
        },
        'selectionchange':function(view, selections) {
            var datas = [];
            for (var i = 0; i < selections.length; i++) {
                datas.push(view.getRecord(selections[i]).data);
            }
            this.fireEvent('selectionchange', datas);
        },
        scope:this
    });

    this.tileView.on({
        'dblclick':function(view, index, node) {
            this.openNode(view.getRecord(node).data);
        },
        'selectionchange':function(view, selections) {
            var datas = [];
            for (var i = 0; i < selections.length; i++) {
                datas.push(view.getRecord(selections[i]).data);
            }
            this.fireEvent('selectionchange', datas);
        },
        scope:this
    });

    this.listGrid.on({
        'rowdblclick':function(grid) {
            this.openNode(grid.getSelectionModel().getSelected().data);
        },
        scope:this
    });

    this.listGrid.getSelectionModel().on({
        'selectionchange':function(sm) {
            var selections = sm.getSelections();
            var datas = [];
            for (var i = 0; i < selections.length; i++) {
                datas.push(selections[i].data);
            }
            this.fireEvent('selectionchange', datas);
        },
        scope:this
    });

    this.store.on({
        'load':function() {
            this.updateToolbar();
        },
        scope:this
    });

    var activeIndex = 0;
    if (this.viewMode) {
        if (this.viewMode == 'micro') {
            activeIndex = 0;
        } else if (this.viewMode == 'tile') {
            activeIndex = 1;
        } else if (this.viewMode == 'list') {
            activeIndex = 2;
        }
    }

    Fc.FcPanel.superclass.constructor.call(this, {
        cls:'fc-panel',
        region: 'center',
        layout:'card',
        activeItem:activeIndex,
        margins: '2 1 2 0',
        autoScroll: true,
        tbar:toolBar,
        items:[this.microView, this.tileView,this.listGrid]
    });
    this.on({
        'selectionchange':function() {
            this.updateToolbar();
        },
        scope:this
    });
};

Ext.extend(Fc.FcPanel, Ext.Panel, {
    afterRender : function() {
        Fc.FcPanel.superclass.afterRender.call(this);
        this.mon(this.body, {
            contextmenu: this.onContextMenu,
            scope: this
        });
    },
    onContextMenu:function(e) {
        e.stopEvent();
        e.stopPropagation();
        if (!this.contextMenu.el) {
            this.contextMenu.render();
        }
        var xy = e.getXY();
        var dw = Ext.lib.Dom.getViewWidth() - 5;
        var dh = Ext.lib.Dom.getViewHeight() - 5;
        var h = this.contextMenu.el.getHeight();
        var w = this.contextMenu.el.getWidth();
        this.contextMenu.showAt([xy[0] + w > dw ? dw - w : xy[0],xy[1] + h > dh ? dh - h : xy[1]]);
        this.updateContextMenu();
    },
    updateContextMenu:function() {
        var count = this.getCount(), countFlag = count != 1, countFlag1 = count == 0;
        this.setCmBtnState('download', countFlag);
        this.setCmBtnState('preview', countFlag);
        this.setCmBtnState('print', true);
        if(!countFlag && this.getSelections()[0].data.isImage){
            this.setCmBtnState('print', false);
        }
        if (this.readOnly) {
            this.setCmBtnState('create', true);
            this.setCmBtnState('upload', true);
            this.setCmBtnState('uploadOriginal', true);
            this.setCmBtnState('uploadExe', true);
            countFlag = true;
            countFlag1 = true;
        }
        this.setCmBtnState('zip', countFlag1);
        this.setCmBtnState('unzip', countFlag || !/\.zip$/i.test(this.getSelections()[0].data.name));
        this.setCmBtnState('cut', countFlag1);
        this.setCmBtnState('copy', countFlag1);
        this.setCmBtnState('paste', this.cutIds.length == 0 && this.copyIds.length == 0);
        this.setCmBtnState('delete', countFlag1);
        //this.setCmBtnState('edit', countFlag || !this.getSelections()[0].data.isDoc);
        this.setCmBtnState('props', countFlag);
        
        if (this.onlyUpload) {
            this.setCmBtnState('create', false);
            this.setCmBtnState('upload', false);
            this.setCmBtnState('uploadOriginal', false);
            this.setCmBtnState('uploadExe', false);
        }
    },
    setCmBtnState:function(btn, flag) {
        btn = Ext.isString(btn) ? this.contextMenu.getComponent(btn) : btn;
        if (btn.disabled != flag)
            btn.setDisabled(flag);
    },
    updateToolbar:function() {
        var count = this.getCount(), countFlag = count != 1, countFlag1 = count == 0,multiCountFlag = (count < 1);

        this.setBtnState('download', multiCountFlag);
        this.setBtnState('preview', countFlag);
        if (this.readOnly) {
            this.setBtnState('create', true);
            this.setBtnState('upload', true);
            this.setBtnState('uploadOriginal', true);
            this.setBtnState('uploadExe', true);
            countFlag = true;
            countFlag1 = true;
        }
        this.setBtnState('back', this.backStack.length == 0);
        this.setBtnState('forward', this.forwardStack.length == 0);
        this.setBtnState('up', this.getNodeId() == this.rootId);
        this.setBtnState('zip', countFlag1);
        this.setBtnState('unzip', countFlag || !/\.zip$/i.test(this.getSelections()[0].data.name));
        this.setBtnState('cut', countFlag1);
        this.setBtnState('copy', countFlag1);
        this.setBtnState('paste', this.cutIds.length == 0 && this.copyIds.length == 0);
        this.setBtnState('delete', countFlag1);
        //this.setBtnState('edit', countFlag || !this.getSelections()[0].data.isDoc);
        this.setBtnState('props', countFlag);
        
        if (this.onlyUpload) {
            this.setBtnState('create', false);
            this.setBtnState('upload', false);
            this.setBtnState('uploadOriginal', false);
            this.setBtnState('uploadExe', false);
        }
    },
    setBtnState:function(btn, flag) {
        btn = Ext.isString(btn) ? this.toolBarBtns[btn] : btn;
        if (btn && btn.disabled != flag)
            btn.setDisabled(flag);
    },
    getNodeId:function() {
        return this.store.getNodeId();
    },
    loadNode:function(nodeId, params) {
        if (nodeId == this.getNodeId())
            return;
        if (nodeId) {
            var lastId = this.store.getNodeId();
            if (lastId)
                this.backStack.push(lastId);
            if (this.forwardStack.length > 0)
                this.forwardStack = [];
        }
        this.store.loadNode(nodeId, params);
    },
    refresh:function() {
        var obj = this;
        obj.loadNode();
        setTimeout(function(){
            obj.loadNode();
            //obj.store.loadNode(null,null);
        },150);
    },
    up:function() {
        var node = this.store.getCurrentNode();
        if (node.id != this.rootId)
            this.loadNode(node.parentId);
    },
    back:function() {
        if (this.backStack.length > 0) {
            this.forwardStack.push(this.getNodeId());
            this.store.loadNode(this.backStack.pop());
        }
    },
    forward:function() {
        if (this.forwardStack.length > 0) {
            this.backStack.push(this.getNodeId());
            this.store.loadNode(this.forwardStack.pop());
        }
    },
    initCreateDlg:function() {
        this.createDlg = new Fc.PropertiesDialog({getUrl:this.getUrl});
        this.createDlg.on('success', function() {
            this.refresh();
            this.fireEvent('childchange', this.getNodeId(), this);
        }, this);
    },
    create:function() {
        if (!this.createDlg) {
            this.initCreateDlg();
        }
        this.createDlg.show({pnid:this.getNodeId()});
    },
    upload:function() {
        //this.uploadExe();
        if (!this.uploadDialog) {
            this.uploadDialog = new Fc.UploadDialog({
                getUrl:this.getUrl,
                maxSize:100000000000,
                typeDescription:this.fileTypeDescription || '所有文件',
                autoClose:this.autoClose || true,
                fileTypes:this.fileTypes || '*.*'
            });
            this.uploadDialog.on('hide', function() {
                this.refresh();
                this.fireEvent('childchange', this.getNodeId(), this);
            }, this);
        }
        this.uploadDialog.show(this.getNodeId());

        /*openFileLayer(this.getNodeId());*/
    },
    uploadOriginal:function(data) {
        //该方法是直接弹出windows默认的上传界面，支持多选，
        // 原理是直接出发文件上传控件的点击时间，并且给input增加change事件来捕获数据的变化，实现自动上传
        //获取当前节点id：
        if (!data && this.getCount() == 1) {
            data = this.getSelections()[0].data;
        }
        if (!data){
            data = {id:this.getNodeId(),type:0};
        }
        /*if (!(data.type == 1)){
         openFileUploadWindow(data.id);
         }*/
        if (!(data.type == 1)){
            if(confirm("重名文件是否覆盖（确定代表覆盖；取消代表重命名）？")){
                $('#fileCenter_cover_fileupload').val("true");
                $('#fileCenter_rename_fileupload').val("false");
            }else{
                $('#fileCenter_rename_fileupload').val("true");
                $('#fileCenter_cover_fileupload').val("false");
            }
            $('#fileCenter_nid_fileupload').val(data.id);
            var ie = !-[1,];
            if(ie){
                $('#fileCenter_mul_fileupload').trigger('click').trigger('change');
            }else{
                $('#fileCenter_mul_fileupload').trigger('click');
            }
        }
    },
    uploadExe:function(data) {
        //控件上传
        if (!data && this.getCount() == 1) {
            data = this.getSelections()[0].data;
        }
        if (!data){
            data = {id:this.getNodeId(),type:0};
        }
        var dirNodeId = data.id;
        if (data.type == 1){
            dirNodeId = data.parentId;
        }
        var url = 'fcm'+this.fileCenterUrl.replace("http","")+';'+dirNodeId+';;{\\"CanEdit\\":1};0';
        top.location.href = url;
    },
    download:function() {
        if (this.getCount() > 0){
            for(var i=0;i<this.getCount();i++){
                var data = this.getSelections()[i].data;
                if (data.type != 1){
                    if(this.getCount()==1)
                        this.store.loadNode(data.id);
                    else
                        continue;
                }else{
                    //下载时，后台需要根据参与判断，将response的header设置为attachment
                    window.open(this.getSelections()[i].data.url+"&enablePreview="+this.showPreview);
                }
            }
        }

    },
    openNode:function(data) {
        if (data.type == 1)
            this.preview(data);
        else
            this.loadNode(data.id);
    },
    preview:function(data) {
        if (!data && this.getCount() == 1) {
            data = this.getSelections()[0].data;
        }
        if (!data)
            return;

        var url = 'fcm'+this.fileCenterUrl.replace("http","")+';'+this.rootId+';;';
        if(this.readOnly){
            url+='{\\"CanPrint\\":1,\\"FocusedNodeID\\":'+data.id+',\\"CanDownload\\":1,\\"CanRefresh\\":1,\\"CanCreateNewFolder\\":0,\\"CanDelete\\":0,\\"CanRename\\":0,\\"CanUpload\\":0,\\"CanLocalFile\\":0,\\"CanScan\\":0,\\"CanTakePhoto\\":0,\\"CanEdit\\":-1};';
        }else{
            url+='{\\"CanEdit\\":1,\\"FocusedNodeID\\":'+data.id+'};';
        }
        url+='0';
        top.location.href = url;
        /*if (this.enableViewClient) {
            /!*if (!Ext.isDefined(window.hasEPreOcx)) {
                try {
                    new ActiveXObject('GtisOcxShowProj1.GtisOcxShow');
                    window.hasEPreOcx = true;
                } catch (e) {
                    window.hasEPreOcx = false;
                }
            }
            if (window.hasEPreOcx) {
                var url = this.fileCenterUrl;
                url = url.substring(url.indexOf('//') + 2) + "/node/preview.do";
                if (this.token) {
                    url += "?token=" + this.token + "&";
                } else {
                    if (!this.jsessionid) {
                        this.jsessionid = Ext.util.Cookies.get('JSESSIONID');
                    }
                    url += ";jsessionid=" + this.jsessionid + "?";
                }
                location.href = 'epre://' + url + "nid=" + data.id;
                return;
            }*!/
            //原文查看工具只针对常见格式，其余格式直接弹出下载即可
            var icon = data.icon;
            var type = icon.substr(0,icon.indexOf('.'));
            var allowType = "jpg;png;jpeg;bmp;gif;swf;txt;xml;json;doc;docx;xls;xlsx;ppt;pptx;pfd;cad;ceb;";
            if(allowType.indexOf(type+";") > -1){
                //文件预览采用档案原文查看工具
                var url = this.fileCenterUrl;
                url = url.substring(url.indexOf('//') + 2) + "/node/preview.do";
                if (this.token) {
                    url += "?token=" + this.token + "&";
                } else {
                    if (!this.jsessionid) {
                        this.jsessionid = Ext.util.Cookies.get('JSESSIONID');
                    }
                    url += ";jsessionid=" + this.jsessionid + "?";
                }
                location.href = 'epre://' + url + "nid=" + data.id;
            }else{
                this.download();
            }
            return;
        }
        if (!this.showPreview && data.isDoc) {
            this.download();
            return;
        }
        if (!this.previewDialog) {
            this.previewDialog = new Fc.PreviewDialog({
                getUrl:this.getUrl,
                store:this.store,
                readOnly:this.readOnly,
                enableViewClient:this.enableViewClient,
                fileCenterUrl:this.fileCenterUrl,
                maxPreviewDialog:this.maxPreviewDialog,
                pictureFillToDialogSize:this.pictureFillToDialogSize
            });
        }
        this.previewDialog.show(data);*/
    },
    imagePrint:function(data) {
        if (!data && this.getCount() == 1) {
            data = this.getSelections()[0].data;
        }
        if (!data)
            return;
        if(data.isImage){
            var imgurl = "/fileCenter/file/print.do?fid="+data.id;
            //alert(imgurl);
            window.open(imgurl,'print');
        }else{
            alert("只有图片才可以直接打印！");
        }
    },
    setViewMode:function(mode) {
        var l = this.getLayout();
        var active = l.activeItem;
        var vm = this.getTopToolbar().getComponent('viewMode');
        switch (mode) {
            case 'micro':
                if (active != this.microView) {
                    vm.setIconClass('fc-micro');
                    active.setStore(false);
                    this.microView.setStore(this.store);
                    l.setActiveItem(0);
                }
                break;
            case 'tile':
                if (active != this.tileView) {
                    vm.setIconClass('fc-tile');
                    active.setStore(false);
                    this.tileView.setStore(this.store);
                    l.setActiveItem(1);
                }
                break;
            case 'list':
                if (active != this.listGrid) {
                    vm.setIconClass('fc-list');
                    active.setStore(false);
                    this.listGrid.setStore(this.store);
                    l.setActiveItem(2);
                }
                break;
        }
    },
    setSortOrder:function(order) {
        this.store.sort(this.store.sortInfo && this.store.sortInfo.field ? this.store.sortInfo.field : 'name', order);
    },
    setSortMode:function(mode) {
        this.store.sort(mode, this.store.sortInfo && this.store.sortInfo.direction ? this.store.sortInfo.direction : 'ASC');
    },
    getSelections:function() {
        return this.getLayout().activeItem.getSelections();
    },
    getCount:function() {
        return this.getLayout().activeItem.getCount();
    },
    getNodeIds:function() {
        var ids = [], selections = this.getSelections();
        for (var i = 0; i < selections.length; i++) {
            var data = selections[i].data;
            ids.push(data.id);
        }
        return ids;
    },
    zip:function() {
        var path = this.store.getCurrentNode().path;
        var matchs = path.match(/\/([^\/]+)\/$/);
        var name = matchs && matchs.length > 1 ? matchs[1] : '压缩文件';
        if (this.getCount() > 0) {
            if (!this.zipDlg) {
                this.zipDlg = new Fc.ZipDialog({getUrl:this.getUrl});
                this.zipDlg.on('success', function() {
                    this.refresh();
                }, this);
            }
            this.zipDlg.show(this.getNodeId(), this.getNodeIds(), name);
        }
    },
    unzip:function() {
        if (this.getCount() == 1) {
            var data = this.getSelections()[0].data;
            var name = data.name;
            if (!/\.zip$/i.test(name))
                return;
            if (!this.unzipDlg) {
                this.unzipDlg = new Fc.UnzipDialog({getUrl:this.getUrl});
                this.unzipDlg.on('success', function() {
                    this.refresh();
                    this.fireEvent('childchange', this.getNodeId(), this);
                }, this);
            }
            this.unzipDlg.show(data.id, name.substr(0, name.lastIndexOf('.')));
        }
    },
    cut:function() {
        this.copyIds = [];
        this.cutIds = this.getNodeIds();
        this.updateToolbar();
    },
    copy:function() {
        this.cutIds = [];
        this.copyIds = this.getNodeIds();
        this.updateToolbar();
    },
    paste:function() {
        if (this.cutIds.length > 0 || this.copyIds.length > 0) {
            var isCopy = this.copyIds.length > 0;
            Fc.Ajax.request({
                url:this.getUrl('node/' + (isCopy ? 'copy' : 'move') + '.do'),
                params:{nid:isCopy ? this.copyIds : this.cutIds,dnid:this.getNodeId()},
                success:function() {
                    this.copyIds = [];
                    this.cutIds = [];
                    this.refresh();
                    this.fireEvent('childchange', this.getNodeId(), this);
                },
                scope:this
            });
        }
    },
    del:function() {
        var count = this.getCount();
        if (count == 0)
            return;
        Ext.MessageBox.confirm('确认', '确定要删除这 ' + count + ' 项吗?', function(btn) {
            if (btn != 'yes')
                return;
            Fc.Ajax.request({
                url:this.getUrl('node/del.do'),
                params:{nid:this.getNodeIds()},
                success:function() {
                    this.refresh();
                    this.fireEvent('childchange', this.getNodeId(), this);
                },
                scope:this
            });
        }, this);
    },
    props:function() {
        if (this.getCount() == 1) {
            if (!this.createDlg) {
                this.initCreateDlg();
            }
            this.createDlg.show(this.getSelections()[0].data);
        }
    },
    getWebDavUrl:function() {
        return this.store.getEditUrl(this.getSelections()[0].data.name);
    },
    edit:function() {
        var webDavUrl = this.getWebDavUrl();
        if (window.ActiveXObject) {// this is IE
            try {
                var ed = new ActiveXObject('SharePoint.OpenDocuments.2');
                if (ed) {
                    ed.EditDocument(location.protocol + "//" + location.host + webDavUrl);
                    return false;
                } else {
                    window.alert('初始化文件编辑对象错误. 请检查您的offce版本.');
                    return false;
                }
            } catch(e) {
                window.alert('创建文件编辑对象错误. 请检查您的安全设置.');
                return false;
            }
        } /*else if (window.URLLauncher) {// this means the OC firefox plugin is installed
         var wdFile = new URLLauncher();
         // check and see if they have the function we want.
         wdFile.open(webDavUrl);
         } else if (window.InstallTrigger) {
         if (window.confirm('需要先安装webdav插件， 确认要安装吗?')) {
         InstallTrigger.install({'WebDAV Launcher': 'js/webdavloader.xpi'});
         }
         }*/ else {
            window.alert('只支持ie');
        }
        return false;
    },
    openWebFolder:function() {
        window.open(this.store.getEditUrl(''));
    },
    openFtpFolder:function() {
        window.open(this.store.getFtpUrl(''));
    },
    openSmbFolder:function() {
        window.open(this.store.getSmbUrl(''));
    },
    enablePreview:function() {
        this.showPreview = true;
    },
    enableCifs:function() {
        this.toolBarBtns['smb'].show();
    },
    enableFtp:function(enable) {
        this.toolBarBtns['ftp'].show();
    },
    enableOtherUpload:function(enable) {
        this.toolBarBtns['uploadOriginal'].show();
        this.toolBarBtns['uploadExe'].show();
    }
});


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FcStore.js
 *
 * LastModified: 2009-10-13 05:39:02
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.FcStore = function(config) {
    Ext.apply(this, config);
    this.addEvents('datachanged', 'nodechanged');

    var fields = ['id','parentId','path', 'name','viewName','description','type','size','usedSize','icon','owner','isDoc','isImage','childCount','attrs',
        {
            name:'updateTime',
            type:'date',
            dateFormat:'time'
        },
        {
            name: 'shortName',
            mapping: 'name',
            convert: this.convertName
        },
        {
            name: 'bigIcon',
            mapping: 'icon',
            convert: this.convertBigIcon,
            getUrl:this.getUrl
        },
        {
            name: 'smallIcon',
            mapping: 'icon',
            convert: this.convertSmallIcon,
            getUrl:this.getUrl
        },
        {
            name: 'url',
            mapping: 'id',
            convert: this.convertUrl,
            getUrl:this.getUrl
        }];

    Fc.FcStore.superclass.constructor.call(this, {
        url: this.getUrl(this.url ? this.url : 'node/list.do'),
        baseParams:this.baseParams || {},
        fields:fields,
        root: 'items',
        totalProperty: 'total'
    });
};

Ext.extend(Fc.FcStore, Fc.data.JsonStore, {
    getCurrentNode:function() {
        if (!this.cNode || this.cNode.id != this.getNodeId()) {
            var reader = this.reader;
            var data = reader.jsonData.node;
            var items = reader.recordType.prototype.fields.items;
            this.cNode = reader.extractValues(data, items, items.length);
        }
        return this.cNode;
    },
    getNodeId:function() {
        return this.baseParams['nid'];
    },
    getEditUrl:function(name) {
        return this.getWebdavUrl(name);
    },
    loadNode:function(nodeId, params) {
        if (nodeId == this.getNodeId())
            return;
        if (nodeId) {
            this.setBaseParam('nid', nodeId);
            this.fireEvent('nodechanged', nodeId);
        }
        this.load({params:params || {}});
    },
    convertName:function(name, record) {
        name = record.viewName || name;
        return name.length > 10 ? name.substr(0, 7) + '...' : name;
    },
    convertBigIcon:function(icon, record) {
        return record.isImage ? this.getUrl('file/get.do?type=micro&fid=' + record.id) : this.getUrl('images/icon/big/' + icon);
    },
    convertSmallIcon:function(icon) {
        return this.getUrl('images/icon/small/' + icon);
    },
    convertUrl:function(id) {
        return this.getUrl('file/get.do?fid=' + id);
    }
});


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FcUpload.js
 *
 * LastModified: 2009-10-27 03:45:22
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */


/**
 * @cfg {String} token
 * 访问令牌，必须
 */
/**
 * @cfg {Number} nodeId
 * 节点Id，必须
 */
/**
 * @cfg {String} path
 * 上传到的路径，可选
 */
/**
 * @cfg {String}basePath
 * fileCenter web路径
 */
/**
 * @cfg {String}desc
 * 上传文件的注释
 */
/**
 * @cfg {Function}success
 * 上传成功callback
 */
/**
 * @cfg {Function}failure
 * 上传失败callback
 */
var FcUpload = function(config) {
    this.token = '';
    this.nodeId = '';
    this.path = '';
    this.basePath = '';
    this.autoRename = '';
    this.success = this.failure = function() {
    };
    for (var p in config) {
        this[p] = config[p];
    }
};
FcUpload.prototype = {
    upload:function() {
        var doc = document;
        var isStrict = doc.compatMode == "CSS1Compat";
        var left = ((isStrict ? doc.documentElement.clientWidth : doc.body.clientWidth) - 400) / 2;
        var top = ((isStrict ? doc.documentElement.clientHeight : doc.body.clientHeight) - 150) / 2;
        this.uploadFnName = this.createFnProxy(this.success, this.failure, this.uploadFnName);
        this.uploadWin = window.open("", "_blank", "height=130,width=400,left=" + left + ",top=" + top + ",status=no,toolbar=no,menubar=no,location=no,resizable=no");
        var html = ['<html><head><title>上传文件</title>',
            '<style type="text/css">body{font-size:12px;background:menu;}form{margin:0;padding:28px 10px;}input{font-size:12px;}fieldset{padding: 0 10px;}</style>',
            '</head><body><fieldset><legend>文件上传</legend>',
            '<form action="',this.basePath,'file/upload.do" method="post" enctype="multipart/form-data">',
            '<input type="file" name="file" value="浏览" style="width:73%;"/>&nbsp;&nbsp;&nbsp;',
            '<input type="hidden" name="client" value="js"/>',
            '<input type="hidden" name="token" value="',this.token,'"/>',
            '<input type="hidden" name="nid" value="',this.nodeId,'"/>',
            '<input type="hidden" name="path" value="',this.path,'"/>',
            '<input type="hidden" name="callBack" value="',this.uploadFnName,'"/>',
            '<input type="hidden" name="rename" value="',this.autoRename,'"/>',
            '<input type="submit" value=" 上 传 "/></form>',
            '</fieldset></body></html>'].join('');
        this.uploadWin.document.write(html);
    },
    createFnProxy : function(successFn, failureFn, old) {
        if (old) {
            delete window[old];
        }
        var fnName = "fcFnProxy" + (new Date().getTime());
        var self = this;
        window[fnName] = function(res) {
            self.uploadWin.close();
            var basePath = self.basePath;
            if (res.type == 0) {
                var file = res['file'];
                file.url = basePath + 'file/get.do?fid=' + file.id;
                file.smallIcon = basePath + 'images/icon/small/' + file.icon;
                file.bigIcon = file.isImage ? basePath + 'file/get.do?type=micro&fid=' + file.id : basePath + 'images/icon/big/' + file.icon;
                successFn(res.file);
            } else
                failureFn(res.type, res.msg);
        };
        return fnName;
    }
};


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FcViewer.js
 *
 * LastModified: 2009-09-28 07:07:56
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */
Fc.FcViewer = function(config) {
    Ext.QuickTips.init();
    Ext.state.Manager.setProvider(new Ext.state.CookieProvider());

    new Ext.Viewport({
        layout: 'border',
        items: [
            {
                region: 'north',
                border:false,
                hidden:config['hideBanner'],
                html: '<div class="fc-ocx"><a href="' + config.basePath + '/ocx/fileUpload.zip">上传控件下载</a></div><div class="fc-header"><h1>文件中心&nbsp;&nbsp;&nbsp;&nbsp;<span id="loading-indicator" style="display:none;">正在加载...</span></h1></div>'
            },
            {
                region: 'center',
                layout: 'border',
                border:false,
                items:new Fc.FcBrowser(config)
            }
        ]
    });
};


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: ListGrid.js
 *
 * LastModified: 2009-09-28 07:16:09
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.ListGrid = function(config) {
    Ext.apply(this, config);

    var cm = new Ext.grid.ColumnModel([
        {
            header: "名称",
            dataIndex: 'name',
            width: 200,
            renderer: this.formatName,
            sortable:true
        },
        {
            header: "大小",
            dataIndex: 'size',
            align:'right',
            width: 100,
            renderer: this.formatSize,
            sortable:true
        },
        {
            header: "更新时间",
            dataIndex: 'updateTime',
            width: 130,
            renderer: this.formatDate,
            sortable:true
        },
        {
            header: "所有者",
            dataIndex: 'owner',
            width: 70,
            sortable:true
        },
        {
            header: "下级个数",
            dataIndex: 'childCount',
            width: 50,
            sortable:true
        },
        {
            header: "说明",
            dataIndex: 'description',
            width: 200,
            sortable:true
        }
    ]);

    Fc.ListGrid.superclass.constructor.call(this, {
        cls:'fc-view',
        viewConfig: {
            forceFit:true
        },
        cm:cm,
        border: false,
        sm:new Ext.grid.RowSelectionModel(),
        loadMask: false
    });
};
Ext.extend(Fc.ListGrid, Ext.grid.GridPanel, {
    getSelections:function() {
        return this.getSelectionModel().getSelections();
    },
    getCount:function() {
        return this.getSelectionModel().getCount();
    },
    setStore:function(store) {
        this.getView().bind(store, this.getColumnModel());
    },
    formatName:function(name, p, record) {
        var viewName = record.data.viewName;
        return String.format('<div class="thumb-list' + (record.data.childCount ? ' child' : '') + '" style="background: url({0}) no-repeat left center;" title="{1}">{2}</div>', record.data.smallIcon, name, viewName || name);
    },
    formatSize:function(size, p, record) {
        if (record.data.type == 1)
            return Ext.util.Format.fileSize(size);
        return '';

    },formatDate:function(date) {
        return date.format('Y-m-d H:i');
    }
});


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: LocationBox.js
 *
 * LastModified: 2009-09-28 07:17:14
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */


Fc.LocationBox = function(config) {
    Ext.apply(this, config);

    this.store = new Ext.data.ArrayStore({
        fields: ['id', 'path']
    });
    this.addEvents('nodeChange');
    this.on({
        'specialkey':function(combo, e) {
            if (e.getKey() == e.ENTER)
                this.go();
        },
        'select':function(combo, record) {
            this.fireEvent('nodeChange', record.data.id);
        },
        scope:this
    });
    Fc.LocationBox.superclass.constructor.call(this, {
        displayField:'path',
        typeAhead: true,
        width:100,
        mode: 'local',
        triggerAction: 'all',
        store:this.store
    });
};

Ext.extend(Fc.LocationBox, Ext.form.ComboBox, {
    go:function() {
        var v = this.getValue();
        if (v.lastIndexOf('/') != v.length - 1)
            this.setValue(v + '/');
        var record = this.findRecord(this.displayField, this.getValue());
        if (record) {
            this.fireEvent('nodeChange', record.data.id);
        } else {
            Fc.Ajax.request({
                url:this.getUrl('node/path.do'),
                params:{nid:this.rootId,path:this.getValue()},
                success:function(response) {
                    var node = Ext.decode(response.responseText);
                    if (node.nid) {
                        this.fireEvent('nodeChange', node.nid);
                        this.store.add(new Ext.data.Record({id:node.nid,path:this.getValue()}));
                    }
                },
                scope:this
            });
        }
    },
    setLocation:function(id, path) {
        var record = this.findRecord(this.displayField, path);
        var absPath = path.substr(this.rootPath.length - 1);
        if (!record) {
            this.store.add(new Ext.data.Record({id:id,path:absPath}));
        }
        this.setValue(absPath);
    },
    getLocation:function() {
        return this.getValue();
    },
    setRootPath:function(path) {
        this.rootPath = path;
    }
});
;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: MicroView.js
 *
 * LastModified: 2009-09-28 07:16:22
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */
Fc.MicroView = function(config) {
    Ext.apply(this, config);
    var tpl = new Ext.XTemplate(
            '<tpl for=".">',
            '<div class="thumb-wrap thumb-wrap-micro" id="fc-node-{id}">',
            '<div class="thumb" style="background: url({bigIcon}) no-repeat center center;" title="{name}">{childCount}</div>',
            '<span class="x-editable<tpl if="childCount"> child</tpl>">{shortName}</span></div>',
            '</tpl>',
            '<div class="x-clear"></div>'
            );
    var plgs=[new Ext.DataView.DragSelector()];
    if(!this.readOnly){
        plgs.push(new Ext.DataView.LabelEditor({dataIndex: 'name',viewIndex:'viewName'}));
    }
    Fc.MicroView.superclass.constructor.call(this, {
        cls:'fc-view',
        tpl: tpl,
        multiSelect: true,
        overClass:'x-view-over',
        itemSelector:'div.thumb-wrap-micro',
        plugins: plgs
    });
};
Ext.extend(Fc.MicroView, Ext.DataView, {
    getSelections:function() {
        return Fc.MicroView.superclass.getSelectedRecords.call(this);
    },
    getCount:function() {
        return Fc.MicroView.superclass.getSelectionCount.call(this);
    }
});

;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: PreviewDialog.js
 *
 * LastModified: 2009-10-22 04:55:02
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */
Fc.PreviewDialog = function (config) {
    Ext.apply(this, config);

    this.previewPanel = new Ext.Panel({
        bodyStyle: 'background:#f3f3f3;text-align:center;padding:4px;',
        autoScroll: true,
        tbar: [
            {
                itemId: 'new',
                iconCls: 'fc-create',
                text: '新窗口',
                scope: this,
                handler: function () {
                    this.open();
                }
            }/*,
            {
                itemId: 'edit',
                iconCls: 'fc-edit',
                text: '编辑',
                scope: this,
                handler: function () {
                    this.edit();
                }
            }*/,
            {
                itemId: 'enlarge',
                iconCls: 'fc-enlarge',
                text: '放大',
                scope: this,
                handler: function () {
                    this.zoom(false);
                }
            },
            {
                itemId: 'narrow',
                iconCls: 'fc-narrow',
                text: '缩小',
                scope: this,
                handler: function () {
                    this.zoom(true);
                }
            },
            {
                itemId: 'rotate-left',
                iconCls: 'fc-rotate-left',
                text: '左旋转',
                scope: this,
                handler: function () {
                    this.rotate(270);
                }
            },
            {
                itemId: 'rotate-right',
                iconCls: 'fc-rotate-right',
                text: '右旋转',
                scope: this,
                handler: function () {
                    this.rotate(90);
                }
            },
            {
                itemId: 'download',
                iconCls: 'fc-download',
                text: '下载',
                scope: this,
                handler: function () {
                    this.download();
                }
            },
            {
                itemId: 'close',
                iconCls: 'fc-delete',
                text: '关闭',
                scope: this,
                handler: function () {
                    this.hide();
                }
            },
            '->',
            {
                itemId: 'left',
                iconCls: 'fc-back',
                text: '前一个',
                scope: this,
                handler: function () {
                    this.left();
                }
            },
            {
                itemId: 'right',
                iconCls: 'fc-forward',
                text: '后一个',
                scope: this,
                handler: function () {
                    this.right();
                }
            }
        ]
    });

    Fc.PreviewDialog.superclass.constructor.call(this, {
        title: '文件查看',
        iconCls: 'fc-preview',
        layout: 'fit',
        width: Ext.lib.Dom.getViewWidth() * 0.7,
        height: Ext.lib.Dom.getViewHeight() * 0.9,
        border: false,
        maximizable: true,
        minimizable: true,
        closeAction: 'hide',
        plain: true,
        items: this.previewPanel
    });
    this.on('hide', function () {
        this.setHtml('');
    }, this);
};

Ext.extend(Fc.PreviewDialog, Ext.Window, {
    getDataUrl: function () {
        return this.data.url + (this.data.isDoc ? '&type=preview&' : '') + '&inline=true&_t=' + new Date().getTime();
    },
    show: function (data) {
        this.data = data;
        Fc.PreviewDialog.superclass.show.call(this);
        var index = this.store.indexOfId(this.data.id);
        this.setBtnState('left', index == 0);
        this.setBtnState('right', index > this.store.getCount() - 2);
        //this.setBtnState('edit', !data.isDoc || this.readOnly, true);
        this.setBtnState('enlarge', !data.isImage, true);
        this.setBtnState('narrow', !data.isImage, true);
        this.refresh();
        if (this.maxPreviewDialog) {
            this.maximize();
        }
    },
    getExt: function (name) {
        var index = name.lastIndexOf('.');
        if (index > -1)
            return name.substr(index + 1).toLowerCase();
        return null;
    },
    refresh: function () {
        var data = this.data;
        var ext = this.getExt(data.name);
        var url = this.getDataUrl();
        this.setTitle('查看 ' + data.name);
        if (data.isImage) {
        	var size = data.size;
        	if(size>(1024*1024*5)){
        		var str = "该附件过大，直接在线浏览可能会因为计算机性能问题导致浏览器无法响应，建议下载到本地再查看。\r\n如果需要下载到本地，请点“确定”，\r\n如果需继续在线浏览，请点“取消”。";
        		if(confirm(str)){
        			Ext.Msg.wait('下载进行中...','下载操作');
        			window.location.href = data.url;
        			Ext.Msg.hide();
        			this.hide();
        		}else{
            		this.setHtml('<img src="' + url + '" onmousewheel="return onMouseWheelZoom(this)"' + (this.pictureFillToDialogSize ? ' onload="Fc.PreviewDialog.resizeImg(this,\'' + this.pictureFillToDialogSize + '\');"' : '') + '/>');
            	}
        	}else{
        		this.setHtml('<img src="' + url + '" onmousewheel="return onMouseWheelZoom(this)"' + (this.pictureFillToDialogSize ? ' onload="Fc.PreviewDialog.resizeImg(this,\'' + this.pictureFillToDialogSize + '\');"' : '') + '/>');
        	}
        } else if (data.isDoc) {
            this.setHtml('<iframe src="' + url + '" frameborder="none" style="width:100%;height:100%;border:none;"></iframe>');
        } else if (ext == 'swf') {
            this.setHtml('<object width="100%" height="100%" type="application/x-shockwave-flash" data="' + url + '"><param name="movie" value="' + url + '" /></object>');
        } else if (ext == 'mp3' || ext == 'avi' || ext == 'wma' || ext == 'wmv' || ext == 'asx' || ext == 'asf') {
            this.setHtml('<object width="100%" height="100%" classid="CLSID:6BF52A52-394A-11d3-B153-00C04F79FAA6"><param name="url" value="' + url + '" /><embed width="100%" height="100%" type="application/x-mplayer2" src="' + url + '>"></embed></object>');
        } else if (data.icon == 'txt.gif' || data.icon == 'xml.gif' || data.icon == 'htm.gif') {
            this.setHtml('<iframe src="' + url + '&type=text" frameborder="none" style="width:100%;height:100%;border:none;"></iframe>');
        } else {
            this.setHtml('<div style="padding-top:10px;color:#666;font-size:14px;">不支持文件 ' + data.name + ' 的查看</div>');
        }
    },
    open: function () {
        window.open(this.getDataUrl());
    },
    download: function () {
        window.open(this.data.url);
    },
    setBtnState: function (btn, flag, isHide) {
        btn = Ext.isString(btn) ? this.previewPanel.getTopToolbar().getComponent(btn) : btn;
        if (isHide) {
            if (btn && btn.hidden != flag)
                btn.setVisible(!flag);
        } else {
            if (btn && btn.disabled != flag)
                btn.setDisabled(flag);
        }
    },
    left: function () {
        var index = this.store.indexOfId(this.data.id);
        this.data = this.store.getAt(--index).data;
        this.setBtnState('left', index == 0);
        this.setBtnState('right', index > this.store.getCount() - 2);
        this.refresh();
    },
    right: function () {
        var index = this.store.indexOfId(this.data.id);
        this.data = this.store.getAt(++index).data;
        this.setBtnState('left', index == 0);
        this.setBtnState('right', index > this.store.getCount() - 2);
        this.refresh();
    },
    setHtml: function (html) {
        this.previewPanel.body.update(html);
    },
    edit: function () {
        var webDavUrl = this.store.getEditUrl(this.data.name);
        if (window.ActiveXObject) {// this is IE
            var ed;
            try {
                ed = new ActiveXObject('SharePoint.OpenDocuments.2');
            } catch (e) {
                window.alert('创建文件编辑对象错误. 请检查您的安全设置.');
                return false;
            }
            if (ed) {
                ed.EditDocument(location.protocol + "//" + location.host + webDavUrl);
                return false;
            } else {
                window.alert('初始化文件编辑对象错误. 请检查您的offce版本.');
                return false;
            }
        } /*else if (window.URLLauncher) {// this means the OC firefox plugin is installed
         var wdFile = new URLLauncher();
         // check and see if they have the function we want.
         wdFile.open(webDavUrl);
         } else if (window.InstallTrigger) {
         if (window.confirm('需要先安装webdav插件， 确认要安装吗?')) {
         InstallTrigger.install({'WebDAV Launcher': 'js/webdavloader.xpi'});
         }
         }*/ else {
            window.alert('只支持ie');
        }
        return false;
    },
    zoom: function (isIn) {
        var data = this.data;
        if (data.isImage) {
            var img = this.previewPanel.body.child('img');
            img.setWidth(img.getWidth() * (isIn ? 0.8 : 1.2))
            img.setHeight(img.getHeight() * (isIn ? 0.8 : 1.2))
        }
    },
    rotate: function (degree) {
        Fc.Ajax.request({
            url: this.getUrl('node/rotate.do'),
            params: {degree: degree, nid: this.data.id},
            success: function () {
                this.setHtml('<img src="' + this.getDataUrl() + (this.pictureFillToDialogSize ? ' onload="Fc.PreviewDialog.resizeImg(this,\'' + this.pictureFillToDialogSize + '\');"' : '') + ' onmousewheel="return onMouseWheelZoom(this)"/>');
            },
            scope: this
        });
    }
});

Fc.PreviewDialog.resizeImg = function (img, fillType) {
    img = Ext.get(img);
    var parent = img.parent();
    var iw = img.getWidth(), ih = img.getHeight(), cw = parent.getWidth(), ch = parent.getHeight(), w, h;
    if (fillType == 'width') {
        if (cw < iw) {
            w = cw;
            h = cw / iw * ih;
        }
    } else if (fillType == 'height') {
        if (ch < ih) {
            h = ch;
            w = ch / ih * iw;
        }
    } else if (cw < iw || ch < ih) {
        if (cw < iw) {
            w = cw;
            h = cw / iw * ih;
        }
        if (ch < ih) {
            h = ch;
            w = ch / ih * iw;
        }
    }
    img.setWidth(w - 40);
    img.setHeight(h - 40);
};
function onMouseWheelZoom(img){ 
    var zoom=parseInt(img.style.zoom, 10)||100;
    zoom+=event.wheelDelta/12;
    if (zoom>0) {
    	img.style.zoom=zoom+'%';
    } 
    return false; 
}
;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: PropertiesDialog.js
 *
 * LastModified: 2009-10-14 02:29:05
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.PropertiesDialog = function(config) {
    Ext.apply(this, config);

    this.formPanel = new Ext.FormPanel({
        labelWidth: 35,
        url:this.getUrl('node/edit.do'),
        frame:true,
        border:false,
        bodyStyle:'padding:5px',
        defaultType: 'textfield',
        items: [
            {
                fieldLabel: '名称',
                name: 'name',
                allowBlank:false,
                anchor:'100%'
            },
            {
                fieldLabel: '别名',
                name: 'viewName',
                anchor:'100%'
            },
            {
                fieldLabel: '说明',
                name: 'description',
                anchor:'100%,100%',
                xtype:'textarea'
            },
            {
                xtype: 'htmlcomponent',
                html: '<div class="fc-line"></div>'
            },
            {
                xtype: 'plainfield',
                fieldLabel: '大小',
                name: 'size'
            },
            {
                xtype: 'plainfield',
                fieldLabel: '时间',
                name: 'updateTime'
            }
        ],
        buttons: [
            {
                text:'保存',
                handler: function() {
                    this.save();
                },
                scope:this
            },
            {
                text: '关闭',
                handler: function() {
                    this.hide();
                },
                scope:this
            }
        ]
    });

    this.addEvents('success');

    Fc.PropertiesDialog.superclass.constructor.call(this, {
        title:'创建目录',
        iconCls:'fc-create',
        layout:'fit',
        width:400,
        height:250,
        border:false,
        closeAction:'hide',
        modal: true,
        plain: true,
        items:this.formPanel
    });
};

Ext.extend(Fc.PropertiesDialog, Ext.Window, {
    show:function(data) {
        this.setSize(400, data.pnid ? 220 : 280);
        Fc.PropertiesDialog.superclass.show.call(this);
        var form = this.formPanel.form;
        var nameField = form.findField('name');
        var viewNameField = form.findField('viewName');
        var descField = form.findField('description');
        if (data.pnid) {
            this.pnid = data.pnid;
            delete this.nid;
            nameField.setValue('新建文件夹');
            descField.setValue('');
            this.setTitle('创建目录');
        } else if (data.id) {
            this.nid = data.id;
            delete this.pnid;
            nameField.setValue(data.name);
            descField.setValue(data.description);
            viewNameField.setValue(data.viewName);
            form.findField('size').setValue(data.type == 1 ? Ext.util.Format.fileSize(data.size) : '');
            form.findField('updateTime').setValue(data.updateTime.format('Y-m-d H:i'));
            this.setTitle(data.name + ' 属性');
        }
    },
    save:function() {
        var form = this.formPanel.form;
        if (form.isValid()) {
            var params = {};
            if (this.pnid)
                params.pnid = this.pnid;
            else if (this.nid)
                params.nid = this.nid;
            form.submit({
                waitMsg: '正在更新...',
                params: params,
                success: function() {
                    this.hide();
                    this.fireEvent('success', this, this.id);
                },
                failure:function(fp, action) {
                    var data = Ext.decode(action.response.responseText);
                    if (data.type == 2)
                        form.findField('name').markInvalid('该名称已被使用！');
                    else
                        Fc.errorDialog.show(data['msg'], data['detail'], data['type']);
                },
                scope:this
            });
        }
    }
});


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: TileView.js
 *
 * LastModified: 2009-09-28 07:16:30
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.TileView = function(config) {
    Ext.apply(this, config);
    var tpl = new Ext.XTemplate(
            '<tpl for=".">',
            '<div class="thumb-wrap thumb-wrap-tile" id="fc-node-{id}" title="{name}">',
            '<div class="thumb" style="background: url({bigIcon}) no-repeat center center;">{childCount}</div>',
            '<span class="x-editable<tpl if="childCount"> child</tpl>">{shortName}</span></div>',
            '</tpl>',
            '<div class="x-clear"></div>'
    );
    var plgs = [new Ext.DataView.DragSelector()];
    if (!this.readOnly) {
        plgs.push(new Ext.DataView.LabelEditor({dataIndex: 'name',viewIndex:'viewName'}));
    }
    Fc.TileView.superclass.constructor.call(this, {
        cls:'fc-view',
        tpl: tpl,
        multiSelect: true,
        overClass:'x-view-over',
        itemSelector:'div.thumb-wrap-tile',
        plugins: plgs
    });
};
Ext.extend(Fc.TileView, Ext.DataView, {
    getSelections:function() {
        return Fc.MicroView.superclass.getSelectedRecords.call(this);
    },
    getCount:function() {
        return Fc.MicroView.superclass.getSelectionCount.call(this);
    }
});


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: TreePanel.js
 *
 * LastModified: 2009-09-28 07:14:33
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.TreePanel = function(config) {
    Ext.apply(this, config);
    this.addEvents('nodeChange');

    var rootNode = new Ext.tree.AsyncTreeNode({
        id:this.rootId,
        text:'/',
        iconCls:'fc-space'
    });
    this.loader = new Ext.tree.TreeLoader({
        dataUrl:this.getUrl('node/tree.do'),
        listeners:{

            "beforeload":function(treeLoader, node) {
                treeLoader.baseParams.nid = node.id;
            }
        }
    });

    var treeMenu = new Ext.menu.Menu({
        enableScrolling:false,
        cls:'fc-context-menu',
        items: [
            {
                itemId:'create',
                iconCls:'fc-create',
                text: '创建子目录',
                scope: this,
                handler: function() {
                    this.addChildNode();
                }
            },
            {
                itemId:'rename',
                iconCls:'fc-props',
                text: '重命名',
                scope: this,
                handler: function() {
                    this.rename();
                }
            },
            '-',
            {
                itemId:'refresh',
                iconCls:'fc-refresh',
                text: '刷新',
                scope:this,
                handler:function() {
                    this.refresh();
                }
            },
            '-',
            {
                itemId:'cut',
                iconCls:'fc-cut',
                text: '剪切',
                scope: this,
                handler: function() {
                    this.cut();
                }
            },
            {
                itemId:'copy',
                iconCls:'fc-copy',
                text: '复制',
                scope: this,
                handler: function() {
                    this.copy();
                }
            },
            {
                itemId:'paste',
                iconCls:'fc-paste',
                text: '粘贴',
                scope: this,
                handler: function() {
                    this.paste();
                }
            },
            {
                itemId:'delete',
                iconCls:'fc-delete',
                text: '删除',
                scope: this,
                handler: function() {
                    Ext.MessageBox.confirm('确认', '确定要删除这 ' + this.currentNode.text + ' 吗?', function(btn) {
                        if (btn != 'yes')
                            return;
                        Fc.Ajax.request({
                            url:this.getUrl('node/del.do'),
                            params:{nid:this.currentNode.id},
                            success:function() {
                                this.currentNode.remove();
                            },
                            scope:this
                        });
                    }, this);
                }
            }
        ]});

    this.treeEditor = new Ext.tree.TreeEditor(this, {
        allowBlank:false,
        selectOnFocus:true
    });

    this.treeEditor.on({
        'beforestartedit':function(e) {
            var n = e.editNode;
            return n != rootNode;
        },
        'complete':function(e, value, s) {
            if (value == s && Ext.isNumber(e.editNode.id))
                return;
            var node = e.editNode;
            var name = node.attributes['name'];
            var params = s == name ? {name:value} : {viewName:value};
            var pNodeId = node.attributes['pNodeId'];
            if (pNodeId)
                params['pnid'] = pNodeId;
            else
                params['nid'] = node.id;
            Fc.Ajax.request({
                url:this.getUrl('node/edit.do'),
                params:params,
                success:function(response) {
                    var data = Ext.decode(response.responseText);
                    node.setId(data.id);
                    node.select();
                    this.fireEvent('nodeChange', node.id, node);
                },
                failure:function() {
                    if (pNodeId) {
                        this.treeEditor.editNode = node;
                        this.treeEditor.startEdit(node.ui.textNode);
                    }
                    else
                        node.setText(s);
                },
                scope:this
            });
        },
        scope:this
    });
    this.getSelectionModel().on({
        'selectionchange':function(sm, node) {
            if (node) {
                if (node && Ext.isNumber(node.id))
                    this.fireEvent('nodeChange', node.id, node);
            } else
                this.currentNode.parentNode.select();
        },
        scope:this
    });

    Fc.TreePanel.superclass.constructor.call(this, {
        region:'center',
        animate:false,
        autoScroll: true,
        border: false,
        rootVisible: true,
        useArrows: true,
        root:rootNode
    });
    this.on({
        'contextmenu':function(node, e) {
            e.stopEvent();
            this.currentNode = node;
            treeMenu.showAt(e.getXY());
            treeMenu.getComponent('delete').setDisabled(node.id == this.rootId);
            treeMenu.getComponent('paste').setDisabled(this.fcPanel.cutIds.length == 0 && this.fcPanel.copyIds.length == 0);
            if (this.readOnly) {
                treeMenu.getComponent('create').setDisabled(true);
                treeMenu.getComponent('rename').setDisabled(true);
                treeMenu.getComponent('cut').setDisabled(true);
                treeMenu.getComponent('copy').setDisabled(true);
                treeMenu.getComponent('paste').setDisabled(true);
                treeMenu.getComponent('delete').setDisabled(true);
            }
        },
        scope:this
    });
};

Ext.extend(Fc.TreePanel, Ext.tree.TreePanel, {
    addChildNode:function() {
        this.currentNode.expand(false, false);
        var node = this.currentNode.appendChild(new Ext.tree.TreeNode({
            pNodeId:this.currentNode.id,
            iconCls:'fc-folder',
            text:'新建文件夹',
            allowDrag:false
        }));
        this.getSelectionModel().select(node);
        var ge = this.treeEditor;
        setTimeout(function() {
            ge.editNode = node;
            ge.startEdit(node.ui.textNode);
        }, 200);
    },
    reloadNodes:function(ids) {
        for (var i = 0; i < ids.length; i++) {
            var node = this.getNodeById(ids[i]);
            if (node)
                node.reload();
        }
    },
    selectNode:function(id) {
        var node = this.getNodeById(id);
        if (node)
            node.select();
    },
    removeNodes:function(ids) {
        for (var i = 0; i < ids.length; i++) {
            var node = this.getNodeById(ids[i]);
            if (node)
                node.remove();
        }
    },
    rename:function() {
        this.treeEditor.editNode = this.currentNode;
        this.treeEditor.startEdit(this.currentNode.ui.textNode);
    },
    refresh:function() {
        this.currentNode.reload();
    },
    cut:function() {
        this.fcPanel.cutIds = [this.currentNode.id];
        this.fcPanel.copyIds = [];
        this.fcPanel.updateToolbar();
    },
    copy:function() {
        this.fcPanel.copyIds = [this.currentNode.id];
        this.fcPanel.cutIds = [];
        this.fcPanel.updateToolbar();
    },
    paste:function() {
        if (this.fcPanel.cutIds && this.fcPanel.cutIds.length > 0 || this.fcPanel.copyIds && this.fcPanel.copyIds.length > 0) {
            var isCopy = this.fcPanel.copyIds.length > 0;
            Fc.Ajax.request({
                url:this.getUrl('node/' + (isCopy ? 'copy' : 'move') + '.do'),
                params:{nid:isCopy ? this.fcPanel.copyIds : this.fcPanel.cutIds,dnid:this.currentNode.id},
                success:function() {
                    if (this.fcPanel.cutIds) {
                        this.removeNodes(this.fcPanel.cutIds);
                    }
                    this.fcPanel.copyIds = [];
                    this.fcPanel.cutIds = [];
                    this.currentNode.reload();
                    this.selectNode(this.currentNode.id);
                },
                scope:this
            });
        }
    },
    del:function() {
        Ext.MessageBox.confirm('确认', '确定要删除这 ' + this.currentNode.text + ' 吗?', function(btn) {
            if (btn != 'yes')
                return;
            Fc.Ajax.request({
                url:this.getUrl('node/del.do'),
                params:{nid:this.currentNode.id},
                success:function() {
                    this.currentNode.remove();
                },
                scope:this
            });
        }, this);
    }
});


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: UnzipDialog.js
 *
 * LastModified: 2009-10-14 04:22:57
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.UnzipDialog = function(config) {
    Ext.apply(this, config);

    this.formPanel = new Ext.FormPanel({
        labelWidth: 45,
        url:this.getUrl('node/unzip.do'),
        frame:true,
        border:false,
        bodyStyle:'padding:5px',
        defaultType: 'textfield',
        items: [
            {
                fieldLabel: '解压到',
                name: 'name',
                anchor:'100%'
            },
            {
                xtype:'checkboxgroup',
                fieldLabel: '选项',
                style:{paddingTop:'2px'},
                items:[
                    {
                        boxLabel: '解压到当前文件夹',
                        name: 'current',
                        listeners:{'check': function(box, c) {
                            this.formPanel.form.findField('name').setDisabled(c);
                        }, scope: this}
                    },
                    {
                        boxLabel: '覆盖同名文件',
                        name: 'cover'
                    }
                ]
            }
        ],
        buttons: [
            {
                text:'解压',
                handler: function() {
                    this.save();
                },
                scope:this
            },
            {
                text: '关闭',
                handler: function() {
                    this.hide();
                },
                scope:this
            }
        ]
    });

    this.addEvents('success');

    Fc.UnzipDialog.superclass.constructor.call(this, {
        title:'解压文件',
        iconCls:'fc-zip',
        layout:'fit',
        width:400,
        height:140,
        border:false,
        closeAction:'hide',
        modal: true,
        plain: true,
        items:this.formPanel
    });
};

Ext.extend(Fc.UnzipDialog, Ext.Window, {
    show:function(nid, name) {
        this.nid = nid;
        Fc.UnzipDialog.superclass.show.call(this);
        var form = this.formPanel.form;
        form.findField('name').setValue(name);
    },
    save:function() {
        var fp = this.items.item(0);
        if (fp.getForm().isValid()) {
            fp.getForm().submit({
                waitMsg: '正在解压...',
                params: {nid:this.nid},
                success: function() {
                    this.hide();
                    this.fireEvent('success', this, this.id);
                },
                failure:function(fp, action) {
                    var data = Ext.decode(action.response.responseText);
                    if (data.type == 2)
                        fp.findField('name').markInvalid('该名称已被使用！');
                    else
                        Fc.errorDialog.show(data['msg'], data['detail'], data['type']);
                },
                scope:this
            });
        }
    }
});


;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: UploadDialog.js
 *
 * LastModified: 2009-10-16 03:35:51
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.UploadFlash = Ext.extend(Ext.FlashComponent, {
    initComponent:function () {
        Fc.UploadFlash.superclass.initComponent.call(this);
        this.addEvents('close');
        this.flashVars = {
            elementID:this.getId(),
            eventHandler:'Ext.FlashEventProxy.onEvent'
        };
    },
    onSwfReady:function () {
        var swf = this.swf;
        swf.setUploadPage(this.getUrl('file/upload.do?userId='+curUser.userId));
        swf.setCheckNameUrl(this.getUrl('file/check.do'));
        if (this.maxSize)
            swf.setUploadFileSize(this.maxSize);
        if (this.typeDescription)
            swf.setFileTypeDescription(this.typeDescription);
        if (this.fileTypes)
            swf.setFileTypes(this.fileTypes);
        if (this.nodeId)
            swf.setNoId(this.nodeId);
        if (this.path)
            swf.setPath(this.path);
        if (this.autoRename)
            swf.setAutoRename(this.autoRename);
        if (this.autoClose)
            swf.setAutoClose(this.autoClose);
    },
    setNodeId:function (nodeId) {
        if (this.isInitialized)
            this.swf.setNoId(nodeId);
        else
            this.nodeId = nodeId;
    },
    clearFiles:function () {
        this.swf.clearFiles();
    },
    hideUploadTip:function () {
    }
});

Fc.OcxUploadPanel = function (config) {
    Ext.apply(this, config);
    this.addEvents('close');
    Fc.UploadDialog.superclass.constructor.call(this, {
        border:false,
        frame:true,
        buttons:[
            {
                text:'添加文件',
                handler:function () {
                    this.ocx.addfile();
                },
                scope:this
            },
            {
                text:'添加目录',
                handler:function () {
                    this.ocx.addfolder();
                },
                scope:this
            },
            {
                text:'上传文件',
                handler:function () {
                    this.ocx.upload();
                },
                scope:this
            },
            {
                text:'清除文件',
                handler:function () {
                    this.ocx.clear();
                },
                scope:this
            },
            {
                text:'关闭',
                handler:function () {
                    this.fireEvent('close');
                },
                scope:this
            }
        ]
    });
};

Ext.extend(Fc.OcxUploadPanel, Ext.Panel, {
    afterRender:function () {
        Fc.OcxUploadPanel.superclass.afterRender.call(this);
        this.body.appendChild(this.ocx);
        var self = this;
        window._uploaded = function () {
            self.fireEvent('close');
        };
    },
    setNodeId:function (nodeId) {
        var url = location.href;
        url = url.substring(0, url.indexOf('/', 9));
        var checkUrl = this.getUrl('file/check.do');
        var uploadUrl = this.getUrl('file/upload.do?userId='+curUser.userId);
        if (checkUrl.indexOf('http') == -1) {
            checkUrl = url + checkUrl;
            uploadUrl = url + uploadUrl;
        }
        this.ocx.checkURL = checkUrl + '&nid=' + nodeId;
        this.ocx.uploadURL = uploadUrl + '&nid=' + nodeId;
        this.ocx.showwindow();
    },
    clearFiles:function () {
        this.ocx.clear();
    },
    hideUploadTip:function () {
        this.ocx.hidewindow();
    },
    showUploadTip:function () {
        this.ocx.showwindow();
    }
});

Fc.UploadDialog = function (config) {
    Ext.apply(this, config);
    try {
        this.ocxDiv = Ext.DomHelper.append(Ext.getBody(), {html:'<object width="100%" height="100%" id="_uploadOcx" classid="clsid:60DCD82D-E555-4892-BAE3-00828BC0E4C5"><param name="uploadURL" value="#"><param name="callBackFunctionOnUploaded" value="_uploaded()"></object>'}, true);
        var ocx = Ext.getDom('_uploadOcx');
        if (ocx.uploadURL) {
            this.uploadPanel = new Fc.OcxUploadPanel({getUrl:this.getUrl, ocx:ocx});
        } else {
            this.ocxDiv.remove();
            this.uploadPanel = new Fc.UploadFlash(Ext.apply(config, {
                backgroundColor:'#dfe8f6',
                url:this.getUrl('flash/flashUpload.swf'),
                uploadPage:this.getUrl('file/upload.do?userId='+curUser.userId),
                checkNameUrl:this.getUrl('file/check.do')
            }));
        }
    } catch (e) {
    }

    this.uploadPanel.on('close', function () {
        this.hide();
    }, this);

    Fc.UploadDialog.superclass.constructor.call(this, {
        title:'上传文件',
        iconCls:'fc-upload',
        border:false,
        layout:'fit',
        width:this.width || 600,
        height:this.width || 450,
        closeAction:'hide',
        modal:true,
        plain:true,
        items:this.uploadPanel
    });

    this.on('hide', function () {
        this.uploadPanel.clearFiles();
        this.uploadPanel.hideUploadTip();
    }, this);
};

Ext.extend(Fc.UploadDialog, Ext.Window, {
    show:function (nid) {
        Fc.UploadDialog.superclass.show.call(this);
        this.uploadPanel.setNodeId(nid);
    }
});




;
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: ZipDialog.js
 *
 * LastModified: 2009-10-14 04:22:57
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.ZipDialog = function(config) {
    Ext.apply(this, config);

    this.formPanel = new Ext.FormPanel({
        labelWidth: 45,
        url:this.getUrl('node/zip.do'),
        frame:true,
        border:false,
        bodyStyle:'padding:5px',
        defaultType: 'textfield',
        items: [
            {
                fieldLabel: '文件名',
                name: 'name',
                allowBlank:false,
                anchor:'100%'
            },
            {
                xtype: 'plainfield',
                fieldLabel: '格式',
                value:'zip压缩文件',
                name: 'updateTime'
            }
        ],
        buttons: [
            {
                text:'压缩',
                handler: function() {
                    this.save();
                },
                scope:this
            },
            {
                text: '关闭',
                handler: function() {
                    this.hide();
                },
                scope:this
            }
        ]
    });

    this.addEvents('success');

    Fc.ZipDialog.superclass.constructor.call(this, {
        title:'压缩文件',
        iconCls:'fc-zip',
        layout:'fit',
        width:400,
        height:140,
        border:false,
        closeAction:'hide',
        plain: true,
        modal: true,
        items:this.formPanel
    });
};

Ext.extend(Fc.ZipDialog, Ext.Window, {
    show:function(nid, ids, name) {
        this.ids = ids;
        this.dnid = nid;
        Fc.ZipDialog.superclass.show.call(this);
        var form = this.formPanel.form;
        form.findField('name').setValue(name + '.zip');
    },
    save:function() {
        var fp = this.items.item(0);
        if (fp.getForm().isValid()) {
            fp.getForm().submit({
                waitMsg: '正在压缩...',
                params: {nid:this.ids,dnid:this.dnid},
                success: function() {
                    this.hide();
                    this.fireEvent('success', this, this.id);
                },
                failure:function(fp,action) {
                    var data = Ext.decode(action.response.responseText);
                    if (data.type == 2)
                        fp.findField('name').markInvalid('该名称已被使用！');
                    else
                        Fc.errorDialog.show(data['msg'], data['detail'], data['type']);
                },
                scope:this
            });
        }
    }
});

