/*
 * Compressed by JSA(www.xidea.org)
 */
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: ErrorResolver.js
 *
 * LastModified: 2009-09-28 05:11:44
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.data.ErrorMsg = {
    '0':'未知错误',
    '1':'未找到该文件或目录',
    '2':'文件或目录已存在',
    '3':'文件访问错误',
    '4':'空间已满，请联系管理员',
    '5':'数据库访问异常，请联系管理员',
    '6':'没有权限'
};

Fc.ErrorDialog = function(config) {
    config = config || {};

    Ext.apply(config, {
        width:400,
        height:250,
        autoHeight:true,
        closeAction:'hide',
        plain:true,
        border:false,
        closable:true,
        title:'错误',
        modal:false,
        items:[
            this.messagePanel = new Ext.FormPanel({
                region:'center',
                cls:'fc-error-dialog',
                border: false
            }),
            this.detailPanel = new Ext.Panel({
                region:'south',
                cls:'fc-error-dialog-detail',
                collapsible:true,
                collapsed:true,
                height:180,
                title:'错误详情',
                titleCollapse:true,
                bodyStyle: 'padding-bottom:15px;background:#eee;'
            })],
        buttons:[
            {
                text:'关闭',
                handler:function() {
                    this.detailPanel.hide();
                    this.hide();
                },
                scope:this
            }
        ]
    });

    Fc.ErrorDialog.superclass.constructor.call(this, config);
};

Ext.extend(Fc.ErrorDialog, Ext.Window, {
    show:function(msg, detail, type) {
        if (!this.rendered)
            this.render(Ext.getBody());
        this.detailPanel.collapse();
        this.messagePanel.body.update(type && Fc.data.ErrorMsg[type] ? Fc.data.ErrorMsg[type] : msg);
        if (!detail) {
            this.detailPanel.hide();
        } else {
            this.detailPanel.show();
            this.detailPanel.body.update('<pre style="height:150px;width:100%;overflow:auto;">' + detail + '</pre>');
        }
        Fc.ErrorDialog.superclass.show.call(this);
    }
});
Fc.errorDialog = new Fc.ErrorDialog();


