/*
 * Compressed by JSA(www.xidea.org)
 */
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: ZipDialog.js
 *
 * LastModified: 2009-10-14 04:22:57
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.ZipDialog = function(config) {
    Ext.apply(this, config);

    this.formPanel = new Ext.FormPanel({
        labelWidth: 45,
        url:this.getUrl('node/zip.do'),
        frame:true,
        border:false,
        bodyStyle:'padding:5px',
        defaultType: 'textfield',
        items: [
            {
                fieldLabel: '文件名',
                name: 'name',
                allowBlank:false,
                anchor:'100%'
            },
            {
                xtype: 'plainfield',
                fieldLabel: '格式',
                value:'zip压缩文件',
                name: 'updateTime'
            }
        ],
        buttons: [
            {
                text:'压缩',
                handler: function() {
                    this.save();
                },
                scope:this
            },
            {
                text: '关闭',
                handler: function() {
                    this.hide();
                },
                scope:this
            }
        ]
    });

    this.addEvents('success');

    Fc.ZipDialog.superclass.constructor.call(this, {
        title:'压缩文件',
        iconCls:'fc-zip',
        layout:'fit',
        width:400,
        height:140,
        border:false,
        closeAction:'hide',
        plain: true,
        modal: true,
        items:this.formPanel
    });
};

Ext.extend(Fc.ZipDialog, Ext.Window, {
    show:function(nid, ids, name) {
        this.ids = ids;
        this.dnid = nid;
        Fc.ZipDialog.superclass.show.call(this);
        var form = this.formPanel.form;
        form.findField('name').setValue(name + '.zip');
    },
    save:function() {
        var fp = this.items.item(0);
        if (fp.getForm().isValid()) {
            fp.getForm().submit({
                waitMsg: '正在压缩...',
                params: {nid:this.ids,dnid:this.dnid},
                success: function() {
                    this.hide();
                    this.fireEvent('success', this, this.id);
                },
                failure:function(fp,action) {
                    var data = Ext.decode(action.response.responseText);
                    if (data.type == 2)
                        fp.findField('name').markInvalid('该名称已被使用！');
                    else
                        Fc.errorDialog.show(data['msg'], data['detail'], data['type']);
                },
                scope:this
            });
        }
    }
});

