/*
 * Compressed by JSA(www.xidea.org)
 */
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: UploadDialog.js
 *
 * LastModified: 2009-10-16 03:35:51
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.UploadFlash = Ext.extend(Ext.FlashComponent, {
    initComponent:function () {
        Fc.UploadFlash.superclass.initComponent.call(this);
        this.addEvents('close');
        this.flashVars = {
            elementID:this.getId(),
            eventHandler:'Ext.FlashEventProxy.onEvent'
        };
    },
    onSwfReady:function () {
        var swf = this.swf;
        swf.setUploadPage(this.getUrl('file/upload.do?userId='+curUser.userId));
        swf.setCheckNameUrl(this.getUrl('file/check.do'));
        if (this.maxSize)
            swf.setUploadFileSize(this.maxSize);
        if (this.typeDescription)
            swf.setFileTypeDescription(this.typeDescription);
        if (this.fileTypes)
            swf.setFileTypes(this.fileTypes);
        if (this.nodeId)
            swf.setNoId(this.nodeId);
        if (this.path)
            swf.setPath(this.path);
        if (this.autoRename)
            swf.setAutoRename(this.autoRename);
        if (this.autoClose)
            swf.setAutoClose(this.autoClose);
    },
    setNodeId:function (nodeId) {
        if (this.isInitialized)
            this.swf.setNoId(nodeId);
        else
            this.nodeId = nodeId;
    },
    clearFiles:function () {
        this.swf.clearFiles();
    },
    hideUploadTip:function () {
    }
});

Fc.OcxUploadPanel = function (config) {
    Ext.apply(this, config);
    this.addEvents('close');
    Fc.UploadDialog.superclass.constructor.call(this, {
        border:false,
        frame:true,
        buttons:[
            {
                text:'添加文件',
                handler:function () {
                    this.ocx.addfile();
                },
                scope:this
            },
            {
                text:'添加目录',
                handler:function () {
                    this.ocx.addfolder();
                },
                scope:this
            },
            {
                text:'上传文件',
                handler:function () {
                    this.ocx.upload();
                },
                scope:this
            },
            {
                text:'清除文件',
                handler:function () {
                    this.ocx.clear();
                },
                scope:this
            },
            {
                text:'关闭',
                handler:function () {
                    this.fireEvent('close');
                },
                scope:this
            }
        ]
    });
};

Ext.extend(Fc.OcxUploadPanel, Ext.Panel, {
    afterRender:function () {
        Fc.OcxUploadPanel.superclass.afterRender.call(this);
        this.body.appendChild(this.ocx);
        var self = this;
        window._uploaded = function () {
            self.fireEvent('close');
        };
    },
    setNodeId:function (nodeId) {
        var url = location.href;
        url = url.substring(0, url.indexOf('/', 9));
        var checkUrl = this.getUrl('file/check.do');
        var uploadUrl = this.getUrl('file/upload.do?userId='+curUser.userId);
        if (checkUrl.indexOf('http') == -1) {
            checkUrl = url + checkUrl;
            uploadUrl = url + uploadUrl;
        }
        this.ocx.checkURL = checkUrl + '&nid=' + nodeId;
        this.ocx.uploadURL = uploadUrl + '&nid=' + nodeId;
        this.ocx.showwindow();
    },
    clearFiles:function () {
        this.ocx.clear();
    },
    hideUploadTip:function () {
        this.ocx.hidewindow();
    },
    showUploadTip:function () {
        this.ocx.showwindow();
    }
});

Fc.UploadDialog = function (config) {
    Ext.apply(this, config);
    try {
        this.ocxDiv = Ext.DomHelper.append(Ext.getBody(), {html:'<object width="100%" height="100%" id="_uploadOcx" classid="clsid:60DCD82D-E555-4892-BAE3-00828BC0E4C5"><param name="uploadURL" value="#"><param name="callBackFunctionOnUploaded" value="_uploaded()"></object>'}, true);
        var ocx = Ext.getDom('_uploadOcx');
        if (ocx.uploadURL) {
            this.uploadPanel = new Fc.OcxUploadPanel({getUrl:this.getUrl, ocx:ocx});
        } else {
            this.ocxDiv.remove();
            this.uploadPanel = new Fc.UploadFlash(Ext.apply(config, {
                backgroundColor:'#dfe8f6',
                url:this.getUrl('flash/flashUpload.swf'),
                uploadPage:this.getUrl('file/upload.do?userId='+curUser.userId),
                checkNameUrl:this.getUrl('file/check.do')
            }));
        }
    } catch (e) {
    }

    this.uploadPanel.on('close', function () {
        this.hide();
    }, this);

    Fc.UploadDialog.superclass.constructor.call(this, {
        title:'上传文件',
        iconCls:'fc-upload',
        border:false,
        layout:'fit',
        width:this.width || 600,
        height:this.width || 450,
        closeAction:'hide',
        modal:true,
        plain:true,
        items:this.uploadPanel
    });

    this.on('hide', function () {
        this.uploadPanel.clearFiles();
        this.uploadPanel.hideUploadTip();
    }, this);
};

Ext.extend(Fc.UploadDialog, Ext.Window, {
    show:function (nid) {
        Fc.UploadDialog.superclass.show.call(this);
        this.uploadPanel.setNodeId(nid);
    }
});



