/*
 * Compressed by JSA(www.xidea.org)
 */
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: PropertiesDialog.js
 *
 * LastModified: 2009-10-14 02:29:05
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.PropertiesDialog = function(config) {
    Ext.apply(this, config);

    this.formPanel = new Ext.FormPanel({
        labelWidth: 35,
        url:this.getUrl('node/edit.do'),
        frame:true,
        border:false,
        bodyStyle:'padding:5px',
        defaultType: 'textfield',
        items: [
            {
                fieldLabel: '名称',
                name: 'name',
                allowBlank:false,
                anchor:'100%'
            },
            {
                fieldLabel: '别名',
                name: 'viewName',
                anchor:'100%'
            },
            {
                fieldLabel: '说明',
                name: 'description',
                anchor:'100%,100%',
                xtype:'textarea'
            },
            {
                xtype: 'htmlcomponent',
                html: '<div class="fc-line"></div>'
            },
            {
                xtype: 'plainfield',
                fieldLabel: '大小',
                name: 'size'
            },
            {
                xtype: 'plainfield',
                fieldLabel: '时间',
                name: 'updateTime'
            }
        ],
        buttons: [
            {
                text:'保存',
                handler: function() {
                    this.save();
                },
                scope:this
            },
            {
                text: '关闭',
                handler: function() {
                    this.hide();
                },
                scope:this
            }
        ]
    });

    this.addEvents('success');

    Fc.PropertiesDialog.superclass.constructor.call(this, {
        title:'创建目录',
        iconCls:'fc-create',
        layout:'fit',
        width:400,
        height:250,
        border:false,
        closeAction:'hide',
        modal: true,
        plain: true,
        items:this.formPanel
    });
};

Ext.extend(Fc.PropertiesDialog, Ext.Window, {
    show:function(data) {
        this.setSize(400, data.pnid ? 220 : 280);
        Fc.PropertiesDialog.superclass.show.call(this);
        var form = this.formPanel.form;
        var nameField = form.findField('name');
        var viewNameField = form.findField('viewName');
        var descField = form.findField('description');
        if (data.pnid) {
            this.pnid = data.pnid;
            delete this.nid;
            nameField.setValue('新建文件夹');
            descField.setValue('');
            this.setTitle('创建目录');
        } else if (data.id) {
            this.nid = data.id;
            delete this.pnid;
            nameField.setValue(data.name);
            descField.setValue(data.description);
            viewNameField.setValue(data.viewName);
            form.findField('size').setValue(data.type == 1 ? Ext.util.Format.fileSize(data.size) : '');
            form.findField('updateTime').setValue(data.updateTime.format('Y-m-d H:i'));
            this.setTitle(data.name + ' 属性');
        }
    },
    save:function() {
        var form = this.formPanel.form;
        if (form.isValid()) {
            var params = {};
            if (this.pnid)
                params.pnid = this.pnid;
            else if (this.nid)
                params.nid = this.nid;
            form.submit({
                waitMsg: '正在更新...',
                params: params,
                success: function() {
                    this.hide();
                    this.fireEvent('success', this, this.id);
                },
                failure:function(fp, action) {
                    var data = Ext.decode(action.response.responseText);
                    if (data.type == 2)
                        form.findField('name').markInvalid('该名称已被使用！');
                    else
                        Fc.errorDialog.show(data['msg'], data['detail'], data['type']);
                },
                scope:this
            });
        }
    }
});

