/*
 * Compressed by JSA(www.xidea.org)
 */
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: PreviewDialog.js
 *
 * LastModified: 2009-10-22 04:55:02
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */
Fc.PreviewDialog = function (config) {
    Ext.apply(this, config);

    this.previewPanel = new Ext.Panel({
        bodyStyle: 'background:#f3f3f3;text-align:center;padding:4px;',
        autoScroll: true,
        tbar: [
            {
                itemId: 'new',
                iconCls: 'fc-create',
                text: '新窗口',
                scope: this,
                handler: function () {
                    this.open();
                }
            }/*,
            {
                itemId: 'edit',
                iconCls: 'fc-edit',
                text: '编辑',
                scope: this,
                handler: function () {
                    this.edit();
                }
            }*/,
            {
                itemId: 'enlarge',
                iconCls: 'fc-enlarge',
                text: '放大',
                scope: this,
                handler: function () {
                    this.zoom(false);
                }
            },
            {
                itemId: 'narrow',
                iconCls: 'fc-narrow',
                text: '缩小',
                scope: this,
                handler: function () {
                    this.zoom(true);
                }
            },
            {
                itemId: 'rotate-left',
                iconCls: 'fc-rotate-left',
                text: '左旋转',
                scope: this,
                handler: function () {
                    this.rotate(270);
                }
            },
            {
                itemId: 'rotate-right',
                iconCls: 'fc-rotate-right',
                text: '右旋转',
                scope: this,
                handler: function () {
                    this.rotate(90);
                }
            },
            {
                itemId: 'download',
                iconCls: 'fc-download',
                text: '下载',
                scope: this,
                handler: function () {
                    this.download();
                }
            },
            {
                itemId: 'close',
                iconCls: 'fc-delete',
                text: '关闭',
                scope: this,
                handler: function () {
                    this.hide();
                }
            },
            '->',
            {
                itemId: 'left',
                iconCls: 'fc-back',
                text: '前一个',
                scope: this,
                handler: function () {
                    this.left();
                }
            },
            {
                itemId: 'right',
                iconCls: 'fc-forward',
                text: '后一个',
                scope: this,
                handler: function () {
                    this.right();
                }
            }
        ]
    });

    Fc.PreviewDialog.superclass.constructor.call(this, {
        title: '文件查看',
        iconCls: 'fc-preview',
        layout: 'fit',
        width: Ext.lib.Dom.getViewWidth() * 0.7,
        height: Ext.lib.Dom.getViewHeight() * 0.9,
        border: false,
        maximizable: true,
        minimizable: true,
        closeAction: 'hide',
        plain: true,
        items: this.previewPanel
    });
    this.on('hide', function () {
        this.setHtml('');
    }, this);
};

Ext.extend(Fc.PreviewDialog, Ext.Window, {
    getDataUrl: function () {
        return this.data.url + (this.data.isDoc ? '&type=preview&' : '') + '&inline=true&_t=' + new Date().getTime();
    },
    show: function (data) {
        this.data = data;
        Fc.PreviewDialog.superclass.show.call(this);
        var index = this.store.indexOfId(this.data.id);
        this.setBtnState('left', index == 0);
        this.setBtnState('right', index > this.store.getCount() - 2);
        //this.setBtnState('edit', !data.isDoc || this.readOnly, true);
        this.setBtnState('enlarge', !data.isImage, true);
        this.setBtnState('narrow', !data.isImage, true);
        this.refresh();
        if (this.maxPreviewDialog) {
            this.maximize();
        }
    },
    getExt: function (name) {
        var index = name.lastIndexOf('.');
        if (index > -1)
            return name.substr(index + 1).toLowerCase();
        return null;
    },
    refresh: function () {
        var data = this.data;
        var ext = this.getExt(data.name);
        var url = this.getDataUrl();
        this.setTitle('查看 ' + data.name);
        if (data.isImage) {
        	var size = data.size;
        	if(size>(1024*1024*5)){
        		var str = "该附件过大，直接在线浏览可能会因为计算机性能问题导致浏览器无法响应，建议下载到本地再查看。\r\n如果需要下载到本地，请点“确定”，\r\n如果需继续在线浏览，请点“取消”。";
        		if(confirm(str)){
        			Ext.Msg.wait('下载进行中...','下载操作');
        			window.location.href = data.url;
        			Ext.Msg.hide();
        			this.hide();
        		}else{
            		this.setHtml('<img src="' + url + '" onmousewheel="return onMouseWheelZoom(this)"' + (this.pictureFillToDialogSize ? ' onload="Fc.PreviewDialog.resizeImg(this,\'' + this.pictureFillToDialogSize + '\');"' : '') + '/>');
            	}
        	}else{
        		this.setHtml('<img src="' + url + '" onmousewheel="return onMouseWheelZoom(this)"' + (this.pictureFillToDialogSize ? ' onload="Fc.PreviewDialog.resizeImg(this,\'' + this.pictureFillToDialogSize + '\');"' : '') + '/>');
        	}
        } else if (data.isDoc) {
            this.setHtml('<iframe src="' + url + '" frameborder="none" style="width:100%;height:100%;border:none;"></iframe>');
        } else if (ext == 'swf') {
            this.setHtml('<object width="100%" height="100%" type="application/x-shockwave-flash" data="' + url + '"><param name="movie" value="' + url + '" /></object>');
        } else if (ext == 'mp3' || ext == 'avi' || ext == 'wma' || ext == 'wmv' || ext == 'asx' || ext == 'asf') {
            this.setHtml('<object width="100%" height="100%" classid="CLSID:6BF52A52-394A-11d3-B153-00C04F79FAA6"><param name="url" value="' + url + '" /><embed width="100%" height="100%" type="application/x-mplayer2" src="' + url + '>"></embed></object>');
        } else if (data.icon == 'txt.gif' || data.icon == 'xml.gif' || data.icon == 'htm.gif') {
            this.setHtml('<iframe src="' + url + '&type=text" frameborder="none" style="width:100%;height:100%;border:none;"></iframe>');
        } else {
            this.setHtml('<div style="padding-top:10px;color:#666;font-size:14px;">不支持文件 ' + data.name + ' 的查看</div>');
        }
    },
    open: function () {
        window.open(this.getDataUrl());
    },
    download: function () {
        window.open(this.data.url);
    },
    setBtnState: function (btn, flag, isHide) {
        btn = Ext.isString(btn) ? this.previewPanel.getTopToolbar().getComponent(btn) : btn;
        if (isHide) {
            if (btn && btn.hidden != flag)
                btn.setVisible(!flag);
        } else {
            if (btn && btn.disabled != flag)
                btn.setDisabled(flag);
        }
    },
    left: function () {
        var index = this.store.indexOfId(this.data.id);
        this.data = this.store.getAt(--index).data;
        this.setBtnState('left', index == 0);
        this.setBtnState('right', index > this.store.getCount() - 2);
        this.refresh();
    },
    right: function () {
        var index = this.store.indexOfId(this.data.id);
        this.data = this.store.getAt(++index).data;
        this.setBtnState('left', index == 0);
        this.setBtnState('right', index > this.store.getCount() - 2);
        this.refresh();
    },
    setHtml: function (html) {
        this.previewPanel.body.update(html);
    },
    edit: function () {
        var webDavUrl = this.store.getEditUrl(this.data.name);
        if (window.ActiveXObject) {// this is IE
            var ed;
            try {
                ed = new ActiveXObject('SharePoint.OpenDocuments.2');
            } catch (e) {
                window.alert('创建文件编辑对象错误. 请检查您的安全设置.');
                return false;
            }
            if (ed) {
                ed.EditDocument(location.protocol + "//" + location.host + webDavUrl);
                return false;
            } else {
                window.alert('初始化文件编辑对象错误. 请检查您的offce版本.');
                return false;
            }
        } /*else if (window.URLLauncher) {// this means the OC firefox plugin is installed
         var wdFile = new URLLauncher();
         // check and see if they have the function we want.
         wdFile.open(webDavUrl);
         } else if (window.InstallTrigger) {
         if (window.confirm('需要先安装webdav插件， 确认要安装吗?')) {
         InstallTrigger.install({'WebDAV Launcher': 'js/webdavloader.xpi'});
         }
         }*/ else {
            window.alert('只支持ie');
        }
        return false;
    },
    zoom: function (isIn) {
        var data = this.data;
        if (data.isImage) {
            var img = this.previewPanel.body.child('img');
            img.setWidth(img.getWidth() * (isIn ? 0.8 : 1.2))
            img.setHeight(img.getHeight() * (isIn ? 0.8 : 1.2))
        }
    },
    rotate: function (degree) {
        Fc.Ajax.request({
            url: this.getUrl('node/rotate.do'),
            params: {degree: degree, nid: this.data.id},
            success: function () {
                this.setHtml('<img src="' + this.getDataUrl() + (this.pictureFillToDialogSize ? ' onload="Fc.PreviewDialog.resizeImg(this,\'' + this.pictureFillToDialogSize + '\');"' : '') + ' onmousewheel="return onMouseWheelZoom(this)"/>');
            },
            scope: this
        });
    }
});

Fc.PreviewDialog.resizeImg = function (img, fillType) {
    img = Ext.get(img);
    var parent = img.parent();
    var iw = img.getWidth(), ih = img.getHeight(), cw = parent.getWidth(), ch = parent.getHeight(), w, h;
    if (fillType == 'width') {
        if (cw < iw) {
            w = cw;
            h = cw / iw * ih;
        }
    } else if (fillType == 'height') {
        if (ch < ih) {
            h = ch;
            w = ch / ih * iw;
        }
    } else if (cw < iw || ch < ih) {
        if (cw < iw) {
            w = cw;
            h = cw / iw * ih;
        }
        if (ch < ih) {
            h = ch;
            w = ch / ih * iw;
        }
    }
    img.setWidth(w - 40);
    img.setHeight(h - 40);
};
function onMouseWheelZoom(img){ 
    var zoom=parseInt(img.style.zoom, 10)||100;
    zoom+=event.wheelDelta/12;
    if (zoom>0) {
    	img.style.zoom=zoom+'%';
    } 
    return false; 
}