/*
 * Compressed by JSA(www.xidea.org)
 */
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: PlainField.js
 *
 * LastModified: 2009-10-14 03:26:55
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.PlainField = Ext.extend(Ext.form.Field, {


    // private
    defaultAutoCreate: {
        tag: 'div',
        cls: 'x-form-plainfield'
    },

    // private
    initComponent: function() {
        Fc.PlainField.superclass.initComponent.call(this);

        if (this.boxLabel && this.fieldLabel)
        {
            this.fieldLabel = this.boxLabel;
            this.hideLabel = false;
        }
        this.addEvents('load');
    },

    getName: function() {
        return this.name;
    },

    // private
    initValue : function() {
        if (this.value !== undefined) {
            this.setValue(this.value);
        } else if (this.el.dom.innerHTML.length > 0) {
            this.setValue(this.el.dom.value);
        }
    },

    getValue : function() {
        return this.value;
    },

    setValue : function(v) {

        if (this.boxLabel)
        {
            if (v == '1')
            {
                v = GO.lang.cmdYes;
            } else
            {
                v = GO.lang.cmdNo;
            }
        }

        this.value = v;
        if (this.rendered) {
            this.el.update(v);
        }
    }

});
Ext.reg('plainfield', Fc.PlainField);

