/*
 * Compressed by JSA(www.xidea.org)
 */
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: LocationBox.js
 *
 * LastModified: 2009-09-28 07:17:14
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */


Fc.LocationBox = function(config) {
    Ext.apply(this, config);

    this.store = new Ext.data.ArrayStore({
        fields: ['id', 'path']
    });
    this.addEvents('nodeChange');
    this.on({
        'specialkey':function(combo, e) {
            if (e.getKey() == e.ENTER)
                this.go();
        },
        'select':function(combo, record) {
            this.fireEvent('nodeChange', record.data.id);
        },
        scope:this
    });
    Fc.LocationBox.superclass.constructor.call(this, {
        displayField:'path',
        typeAhead: true,
        width:100,
        mode: 'local',
        triggerAction: 'all',
        store:this.store
    });
};

Ext.extend(Fc.LocationBox, Ext.form.ComboBox, {
    go:function() {
        var v = this.getValue();
        if (v.lastIndexOf('/') != v.length - 1)
            this.setValue(v + '/');
        var record = this.findRecord(this.displayField, this.getValue());
        if (record) {
            this.fireEvent('nodeChange', record.data.id);
        } else {
            Fc.Ajax.request({
                url:this.getUrl('node/path.do'),
                params:{nid:this.rootId,path:this.getValue()},
                success:function(response) {
                    var node = Ext.decode(response.responseText);
                    if (node.nid) {
                        this.fireEvent('nodeChange', node.nid);
                        this.store.add(new Ext.data.Record({id:node.nid,path:this.getValue()}));
                    }
                },
                scope:this
            });
        }
    },
    setLocation:function(id, path) {
        var record = this.findRecord(this.displayField, path);
        var absPath = path.substr(this.rootPath.length - 1);
        if (!record) {
            this.store.add(new Ext.data.Record({id:id,path:absPath}));
        }
        this.setValue(absPath);
    },
    getLocation:function() {
        return this.getValue();
    },
    setRootPath:function(path) {
        this.rootPath = path;
    }
});