/*
 * Compressed by JSA(www.xidea.org)
 */
/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: DetailPanel.js
 *
 * LastModified: 2009-10-16 09:53:07
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Fc.DetailPanel = function() {

    this.singleTpl = new Ext.XTemplate('<ul class="info">',
            '<tpl if="showRootName"><li style="font-weight:bold;">{name}</li></tpl>',
            '<tpl if="viewName"><li>别名：{viewName}</li></tpl>' +
            '<li style="color:#666">{description:nl2br}</li>',
            '<li>上传者：{owner:nl2br}</li>',
            '<li>时间：{updateTime:date("Y-m-d H:i")}</li>',
            '<tpl if="type==1"><li>大小：{size:fileSize}</li></tpl>',
            '<tpl if="type==2 || type==3">' +
            '<tpl if="size!=-1"><li>总大小：{size:fileSize}</li></tpl>' +
            '<li>已用空间：{usedSize:fileSize}</li>' +
            '<tpl if="size!=-1"><li><div class="fc-use"><div style="width:{[parseInt(values.usedSize/values.size*100)]}%"></div></div></li></tpl></tpl>',
            '<tpl if="type==1"><li style="text-align:center;padding-top:3px;"><img src="{bigIcon}" alt="{name}"/></li></tpl>',
            '<ul>');

    this.multiTpl = new Ext.Template('<ul class="info">',
            '<li>选择了 {count} 个项目</li>',
            '<li>总的文件大小是：{size:fileSize}</li>',
            '<ul>');

    Fc.DetailPanel.superclass.constructor.call(this, {
        height: 200,
        cls:'fc-detail',
        collapsible: true,
        title: '详细信息',
        region: 'south',
        bodyStyle: 'padding-bottom:15px;background:#f3f3f3;',
        autoScroll: true
    });
};

Ext.extend(Fc.DetailPanel, Ext.Panel, {
    showDetail:function(datas) {
        if (datas.length > 1) {
            var size = 0;
            for (var i = 0; i < datas.length; i++) {
                if (datas[i]['type'] == 1)
                    size += datas[i]['size'];
            }
            this.body.update(this.multiTpl.apply({count:datas.length,size:size}));
        } else {
            var data = datas[0];
            data.showRootName = !!data.showRootName;
            this.body.update(this.singleTpl.apply(data));
        }
    }
});



