/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.web;

import com.gtis.config.AppConfig;
import com.gtis.fileCenter.ex.NoPermissionException;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.generic.security.Helper;
import com.gtis.generic.security.User;
import com.gtis.generic.util.SessionUtils;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class NodePermissionInterceptor
extends HandlerInterceptorAdapter {
    private static final String[] CHECK_ID_NAMES = new String[]{"nid", "snid", "dnid", "pnid"};
    @Autowired
    private NodeService nodeService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object object) throws Exception {
        if (AppConfig.getBooleanProperty((String)"token.permission.close", (boolean)false)) {
            return true;
        }
        String token = request.getParameter("token");
        User user = Helper.getCurrentUser();
        ArrayList<Integer> nodeIds = new ArrayList<Integer>();
        for (String idName : CHECK_ID_NAMES) {
            String[] ids = request.getParameterValues(idName);
            if (ids == null || ids.length <= 0) continue;
            for (String nodeId : ids) {
                try {
                    if (!StringUtils.isNotBlank((String)nodeId)) continue;
                    nodeIds.add(Integer.valueOf(nodeId));
                }
                catch (NumberFormatException e) {
                    throw new NodeNotFoundException(nodeId);
                }
            }
        }
        if (nodeIds.size() == 0) {
            return true;
        }
        if (token != null) {
            SecurityContextHolder.clearContext();
            for (Integer nodeId : nodeIds) {
                if (this.nodeService.hasPermission(token, nodeId)) continue;
                throw new NoPermissionException(nodeId);
            }
            return true;
        }
        if (user != null) {
            if (user.isAdmin()) {
                return true;
            }
            Space space = (Space)SessionUtils.get((HttpServletRequest)request, (String)"com.gtis.fileCenter.personalSpace");
            for (Integer nodeId : nodeIds) {
                if (this.nodeService.isChildNode(space.getId(), nodeId) || space.getId().equals(nodeId)) continue;
                throw new NoPermissionException(nodeId);
            }
            return true;
        }
        throw new NoPermissionException("no permission to access node:" + nodeIds);
    }
}

