/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.web;

import com.gtis.config.AppConfig;
import com.gtis.fileCenter.ComparatorNodes;
import com.gtis.fileCenter.NodeHelper;
import com.gtis.fileCenter.ex.NestedRuntimeException;
import com.gtis.fileCenter.ex.NoPermissionException;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.MicroFile;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.NodeImpl;
import com.gtis.fileCenter.service.FileStoreService;
import com.gtis.fileCenter.web.BaseController;
import com.gtis.generic.util.ImageUtils;
import com.gtis.generic.util.JsonUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;

/*
 * Exception performing whole class analysis ignored.
 */
public class NodeController
extends BaseController {
    public static final String WORK_FLOW_STUFF = "WORK_FLOW_STUFF";
    @Autowired
    private FileStoreService fileService;

    @RequestMapping
    public void list(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer nodeId = NodeController.getNodeId((HttpServletRequest)request);
        String query = request.getParameter("query");
        String path = request.getParameter("path");
        String proid = request.getParameter("proid");
        NodeImpl node = new NodeImpl();
        if (nodeId == null && StringUtils.isNotBlank((String)proid)) {
            Space space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", false);
            if (space != null) {
                node = this.nodeService.getNode(space.getId(), proid, false);
            }
        } else {
            Node node2 = node = StringUtils.isNotBlank((String)path) ? this.nodeService.getNode(nodeId, path) : this.nodeService.getNode(nodeId);
        }
        if (node == null) {
            node = new NodeImpl();
        }
        nodeId = node.getId();
        List nodes = StringUtils.isNotBlank((String)query) ? this.nodeService.search(nodeId, query) : this.nodeService.getChildNodes(nodeId);
        String viewFileListField = AppConfig.getProperty((String)"viewFileList.field");
        if (StringUtils.isNotBlank((String)viewFileListField) && StringUtils.equals((String)viewFileListField, (String)"update_time")) {
            ComparatorNodes comparator = new ComparatorNodes();
            Collections.sort(nodes, comparator);
        }
        List list = NodeHelper.nodesToJson((List)nodes);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("items", list);
        map.put("total", list.size());
        Map currentNode = NodeHelper.nodeToJson((Node)node);
        currentNode.put("path", NodeController.getPathString((List)this.nodeService.getPath(nodeId)));
        map.put("node", currentNode);
        JsonUtils.out((HttpServletResponse)response, map);
    }

    @RequestMapping
    public void all(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer nodeId = NodeController.getNodeId((HttpServletRequest)request);
        String query = request.getParameter("query");
        String path = request.getParameter("path");
        String proid = request.getParameter("proid");
        NodeImpl node = new NodeImpl();
        if (nodeId == null && StringUtils.isNotBlank((String)proid)) {
            Space space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", false);
            if (space != null) {
                node = this.nodeService.getNode(space.getId(), proid, false);
            }
        } else {
            Node node2 = node = StringUtils.isNotBlank((String)path) ? this.nodeService.getNode(nodeId, path) : this.nodeService.getNode(nodeId);
        }
        if (node == null) {
            node = new NodeImpl();
        }
        nodeId = node.getId();
        List nodes = this.nodeService.getAllChildNodes(nodeId);
        String viewFileListField = AppConfig.getProperty((String)"viewFileList.field");
        if (StringUtils.isNotBlank((String)viewFileListField) && StringUtils.equals((String)viewFileListField, (String)"update_time")) {
            ComparatorNodes comparator = new ComparatorNodes();
            Collections.sort(nodes, comparator);
        }
        List list = NodeHelper.nodesToJson((List)nodes);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("items", list);
        map.put("total", list.size());
        Map currentNode = NodeHelper.nodeToJson((Node)node);
        currentNode.put("path", NodeController.getPathString((List)this.nodeService.getPath(nodeId)));
        map.put("node", currentNode);
        JsonUtils.out((HttpServletResponse)response, map);
    }

    @RequestMapping
    public void tree(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer nodeId = NodeController.getNodeId((HttpServletRequest)request);
        String proid = request.getParameter("proid");
        NodeImpl node = new NodeImpl();
        if (nodeId == null && StringUtils.isNotBlank((String)proid)) {
            Space space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", false);
            if (space != null) {
                node = this.nodeService.getNode(space.getId(), proid, false);
            }
        } else {
            node = this.nodeService.getNode(nodeId);
        }
        if (node == null) {
            node = new NodeImpl();
        }
        nodeId = node.getId();
        List nodes = this.nodeService.getChildNodes(nodeId);
        String viewFileListField = AppConfig.getProperty((String)"viewFileList.field");
        if (StringUtils.isNotBlank((String)viewFileListField) && StringUtils.equals((String)viewFileListField, (String)"update_time")) {
            ComparatorNodes comparator = new ComparatorNodes();
            Collections.sort(nodes, comparator);
        }
        ArrayList list = new ArrayList(nodes.size());
        for (Node childNode : nodes) {
            if (childNode instanceof com.gtis.fileCenter.model.impl.File) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", childNode.getId());
            map.put("iconCls", childNode instanceof Space ? "fc-space" : "fc-folder");
            map.put("text", childNode.getViewName() == null ? childNode.getName() : childNode.getViewName());
            map.put("name", childNode.getName());
            map.put("title", childNode.getDescription());
            map.put("leaf", Boolean.FALSE);
            list.add(map);
        }
        JsonUtils.out((HttpServletResponse)response, list);
    }

    @RequestMapping
    public void preview(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer nodeId = NodeController.getNodeId((HttpServletRequest)request);
        List nodes = this.nodeService.getChildNodes(this.nodeService.getNode(nodeId).getParentId());
        Document doc = DocumentHelper.createDocument();
        Element files = doc.addElement("files");
        for (Node node : nodes) {
            if (!(node instanceof com.gtis.fileCenter.model.impl.File)) continue;
            StringBuilder url = new StringBuilder(this.fileCenterUrl + "/file/get.do");
            String token = request.getParameter("token");
            if (StringUtils.isNotEmpty((String)token)) {
                url.append("?token=").append(token).append("&");
            } else {
                url.append(";jsessionid=").append(request.getSession().getId()).append("?");
            }
            url.append("fid=").append(node.getId()).append("&inline=true");
            Element file = files.addElement("file").addAttribute("name", node.getViewName() == null ? node.getName() : node.getViewName()).addAttribute("url", url.toString());
            if (!node.getId().equals(nodeId)) continue;
            file.addAttribute("iscurrent", "true");
        }
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(doc.asXML());
        response.getWriter().flush();
    }

    @RequestMapping
    public void rotate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int degree = ServletRequestUtils.getIntParameter((ServletRequest)request, (String)"degree");
        Integer nodeId = NodeController.getNodeId((HttpServletRequest)request);
        com.gtis.fileCenter.model.impl.File file = (com.gtis.fileCenter.model.impl.File)this.nodeService.getNode(nodeId);
        String path = this.fileService.getFile(file).getAbsolutePath();
        String to = path + "-1." + file.getExtension();
        ImageUtils.rotateImage((String)path, (String)to, (double)degree);
        File src = new File(path);
        src.delete();
        this.fileService.getFile((com.gtis.fileCenter.model.impl.File)new MicroFile(file)).delete();
        FileUtils.moveFile((File)new File(to), (File)src);
        JsonUtils.out((HttpServletResponse)response, (Object)"{success:true}");
    }

    @RequestMapping
    public void path(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer nodeId = NodeController.getNodeId((HttpServletRequest)request);
        String path = request.getParameter("path");
        HashMap<String, Integer> map = new HashMap<String, Integer>(1);
        if (StringUtils.isNotBlank((String)path)) {
            try {
                Node node = this.nodeService.getNode(nodeId, path);
                map.put("nid", node.getId());
            }
            catch (NodeNotFoundException ignored) {
                // empty catch block
            }
        }
        JsonUtils.out((HttpServletResponse)response, map);
    }

    @RequestMapping
    public void edit(HttpServletRequest request, HttpServletResponse response) throws Exception {
        NodeImpl node;
        Integer nodeId = NodeController.getNodeId((HttpServletRequest)request);
        this.checkWriteable(request, new Integer[]{nodeId});
        Integer pNodeId = NodeHelper.getIntegerParameter((HttpServletRequest)request, (String)"pnid");
        if (nodeId != null) {
            node = (NodeImpl)this.nodeService.getNode(nodeId);
        } else if (pNodeId != null) {
            node = new NodeImpl();
            node.setParentId(pNodeId);
        } else {
            throw new NestedRuntimeException("nodeId not found");
        }
        String name = request.getParameter("name");
        String viewName = request.getParameter("viewName");
        String description = request.getParameter("description");
        boolean change = false;
        if (StringUtils.isNotBlank((String)name)) {
            node.setName(name);
            change = true;
        }
        if (StringUtils.isNotBlank((String)viewName)) {
            node.setViewName(viewName);
            change = true;
        }
        if (StringUtils.isNotBlank((String)description)) {
            node.setDescription(description);
            change = true;
        }
        if (change) {
            this.nodeService.save((Node)node);
        }
        HashMap<String, Comparable<Boolean>> map = new HashMap<String, Comparable<Boolean>>(2);
        map.put("success", Boolean.TRUE);
        map.put("id", node.getId());
        JsonUtils.out((HttpServletResponse)response, map);
    }

    @RequestMapping
    public void del(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer[] nodeIds = NodeController.getNodeIds((HttpServletRequest)request);
        this.checkWriteable(request, nodeIds);
        this.nodeService.remove(nodeIds);
        JsonUtils.out((HttpServletResponse)response, (Object)"{success:true}");
    }

    @RequestMapping
    public void copy(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer[] nodeIds = NodeController.getNodeIds((HttpServletRequest)request);
        Integer destNodeId = NodeController.getDestNodeId((HttpServletRequest)request);
        this.checkWriteable(request, nodeIds);
        this.checkWriteable(request, new Integer[]{destNodeId});
        boolean isCover = StringUtils.isNotBlank((String)request.getParameter("cover"));
        this.nodeService.copy(nodeIds, destNodeId, isCover);
        JsonUtils.out((HttpServletResponse)response, (Object)"{success:true}");
    }

    @RequestMapping
    public void move(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer[] nodeIds = NodeController.getNodeIds((HttpServletRequest)request);
        Integer destNodeId = NodeController.getDestNodeId((HttpServletRequest)request);
        this.checkWriteable(request, nodeIds);
        this.checkWriteable(request, new Integer[]{destNodeId});
        boolean isCover = StringUtils.isNotBlank((String)request.getParameter("cover"));
        this.nodeService.move(nodeIds, destNodeId, isCover);
        JsonUtils.out((HttpServletResponse)response, (Object)"{success:true}");
    }

    @RequestMapping
    public void zip(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer[] nodeIds = NodeController.getNodeIds((HttpServletRequest)request);
        Integer destNodeId = NodeController.getDestNodeId((HttpServletRequest)request);
        this.checkWriteable(request, nodeIds);
        this.checkWriteable(request, new Integer[]{destNodeId});
        String name = request.getParameter("name");
        this.nodeService.zip(nodeIds, destNodeId, name);
        JsonUtils.out((HttpServletResponse)response, (Object)"{success:true}");
    }

    @RequestMapping
    public void unzip(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer nodeId = NodeController.getNodeId((HttpServletRequest)request);
        this.checkWriteable(request, new Integer[]{nodeId});
        String name = request.getParameter("name");
        boolean isCover = StringUtils.isNotBlank((String)request.getParameter("cover"));
        boolean isCurrent = StringUtils.isNotBlank((String)request.getParameter("current"));
        this.nodeService.unzip(nodeId, isCurrent ? null : name, isCover);
        JsonUtils.out((HttpServletResponse)response, (Object)"{success:true}");
    }

    @RequestMapping
    public void config(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("enablePreview", this.enablePreview);
        map.put("enableCifs", this.enableCifs);
        map.put("enableFtp", this.enableFtp);
        map.put("enableViewClient", this.enableViewClient);
        map.put("fileCenterUrl", this.fileCenterUrl);
        map.put("maxPreviewDialog", this.maxPreviewDialog);
        map.put("pictureFillToDialogSize", this.pictureFillToDialogSize);
        map.put("jsessionid", request.getSession().getId());
        map.put("fileTypes", this.fileTypes);
        map.put("fileTypeDescription", this.fileTypeDescription);
        map.put("enableOtherUpload", AppConfig.getProperty((String)"other.upload.enable"));
        JsonUtils.out((HttpServletResponse)response, map);
    }

    @RequestMapping
    public void cache(HttpServletRequest request, HttpServletResponse response) {
        this.nodeService.clearAll();
    }

    private static Integer getDestNodeId(HttpServletRequest request) {
        return NodeHelper.getIntegerParameter((HttpServletRequest)request, (String)"dnid");
    }

    private static Integer getNodeId(HttpServletRequest request) {
        return NodeHelper.getIntegerParameter((HttpServletRequest)request, (String)"nid");
    }

    private static Integer[] getNodeIds(HttpServletRequest request) {
        return ArrayUtils.toObject((int[])ServletRequestUtils.getIntParameters((ServletRequest)request, (String)"nid"));
    }

    private static String getPathString(List<Node> nodes) {
        StringBuilder sb = new StringBuilder("/");
        for (int i = nodes.size() - 1; i > -1; --i) {
            Node node = nodes.get(i);
            sb.append(node.getName()).append("/");
        }
        return sb.toString();
    }

    private void checkWriteable(HttpServletRequest request, Integer ... nodeIds) {
        String token = request.getParameter("token");
        if (token != null && !this.nodeService.isWriteable(token)) {
            throw new NoPermissionException(Arrays.toString((Object[])nodeIds));
        }
    }
}

