/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.web;

import com.gtis.fileCenter.ex.CapabilityNotEnoughException;
import com.gtis.fileCenter.ex.FileIOException;
import com.gtis.fileCenter.ex.NoPermissionException;
import com.gtis.fileCenter.ex.NodeExistsException;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.generic.util.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class JsonExceptionResolver
implements HandlerExceptionResolver {
    private static final Logger logger = LoggerFactory.getLogger(JsonExceptionResolver.class);
    private Integer defaultStatusCode = 500;

    public void setDefaultStatusCode(Integer defaultStatusCode) {
        this.defaultStatusCode = defaultStatusCode;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        logger.debug("Resolving exception from handler [" + handler + "]", (Throwable)ex);
        HashMap<String, Object> map = new HashMap<String, Object>();
        int errType = 0;
        if (ex instanceof NodeNotFoundException) {
            errType = 1;
        } else if (ex instanceof NodeExistsException) {
            errType = 2;
        } else if (ex instanceof FileIOException) {
            errType = 3;
        } else if (ex instanceof CapabilityNotEnoughException) {
            errType = 4;
        } else if (ex instanceof DataAccessException) {
            errType = 5;
        } else if (ex instanceof NoPermissionException) {
            errType = 6;
        }
        map.put("type", errType);
        map.put("msg", ex.getMessage());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(os));
        map.put("detail", os.toString());
        response.setStatus(this.defaultStatusCode.intValue());
        request.setAttribute("fc_error", (Object)JsonUtils.toString(map));
        return new ModelAndView("error");
    }
}

