/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.web;

import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.PersonalSpace;
import com.gtis.fileCenter.web.BaseController;
import com.gtis.generic.security.Helper;
import com.gtis.generic.util.JsonUtils;
import com.gtis.generic.util.SessionUtils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"/index.do"})
public class IndexController
extends BaseController {
    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView index(HttpServletRequest request) throws Exception {
        String token = request.getParameter("token");
        Map params = this.convertParameters(request);
        if (StringUtils.isBlank((String)token)) {
            Space space = (Space)SessionUtils.get((HttpServletRequest)request, (String)"com.gtis.fileCenter.personalSpace");
            if (space == null) {
                String userId = Helper.getCurrentUserId();
                try {
                    space = this.nodeService.getPersonalSpace(userId);
                }
                catch (NodeNotFoundException e) {
                    space = this.initPersonalSpace(userId);
                }
                SessionUtils.put((HttpServletRequest)request, (String)"com.gtis.fileCenter.personalSpace", (Object)space);
            }
            params.put("rootId", space.getId());
        } else if (!"true".equals(params.get("readOnly"))) {
            params.put("readOnly", !this.nodeService.isWriteable(token));
        }
        params.put("jsessionid", request.getSession().getId());
        request.setAttribute("params", (Object)JsonUtils.toString((Object)params));
        return new ModelAndView("index");
    }

    protected Map<String, Object> convertParameters(HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            Object v;
            String name = (String)names.nextElement();
            String value = request.getParameter(name);
            try {
                v = Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                v = "true".equalsIgnoreCase(value) ? Boolean.TRUE : ("false".equalsIgnoreCase(value) ? Boolean.FALSE : value);
            }
            params.put(name, v);
        }
        return params;
    }

    private Space initPersonalSpace(String userId) {
        PersonalSpace space = new PersonalSpace();
        space.setOwner(userId);
        space.setName(userId);
        space.setSize(-1L);
        this.nodeService.save((Node)space);
        for (String name : new String[]{"\u6211\u7684\u6587\u4ef6", "\u6211\u7684\u97f3\u4e50", "\u56fe\u7247\u6536\u85cf", "\u4e0b\u8f7d\u6587\u4ef6"}) {
            this.nodeService.createNode(space.getId(), name, null, null, null, userId, null);
        }
        return space;
    }
}

