/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.web;

import com.alibaba.fastjson.JSON;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.ComparatorNodes;
import com.gtis.fileCenter.NodeHelper;
import com.gtis.fileCenter.ex.FileIOException;
import com.gtis.fileCenter.ex.FileOverSizeException;
import com.gtis.fileCenter.ex.NestedRuntimeException;
import com.gtis.fileCenter.ex.NoPermissionException;
import com.gtis.fileCenter.ex.NodeExistsException;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.ex.SpaceExhaustException;
import com.gtis.fileCenter.model.MicroFile;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.PreviewFile;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.PersonalSpace;
import com.gtis.fileCenter.service.FileStoreService;
import com.gtis.fileCenter.service.MimeTypeService;
import com.gtis.fileCenter.web.BaseController;
import com.gtis.generic.security.Helper;
import com.gtis.generic.util.JsonUtils;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileController
extends BaseController {
    protected static final Logger logger = LoggerFactory.getLogger(FileController.class);
    public static final String ACCESS_CONTROL_ALLOW_ORIGN = "Access-Control-Allow-Origin";
    public static final String WORK_FLOW_STUFF = "WORK_FLOW_STUFF";
    @Autowired
    private MimeTypeService mimeTypeService;
    @Autowired
    private FileStoreService fileService;
    private boolean useDocServer;

    public void setPreviewServerUrl(String previewServerUrl) {
        this.useDocServer = previewServerUrl.contains("docserver");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(produces={"text/html; charset=utf-8"})
    public void upload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map file;
        if (!"post".equals(request.getMethod().toLowerCase())) return;
        String client = request.getParameter("client");
        String path = request.getParameter("path");
        if ("ke".equals(client)) {
            path = request.getParameter("dir");
        }
        String callBack = request.getParameter("callBack");
        String desc = request.getParameter("desc");
        String viewName = request.getParameter("viewName");
        String userId = request.getParameter("userId");
        boolean cover = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"cover", (boolean)false);
        boolean multi = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"multi", (boolean)false);
        boolean autoRename = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"rename", (boolean)false);
        Integer nodeId = FileController.getNodeId((HttpServletRequest)request);
        this.checkWriteable(request, new Integer[]{nodeId});
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        ArrayList<Map> files = new ArrayList<Map>();
        try {
            Node node = StringUtils.isNotBlank((String)path) ? this.nodeService.getNode(nodeId, path, true) : this.nodeService.getNode(nodeId);
            nodeId = node.getId();
            Space space = this.nodeService.getSpace(nodeId);
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            block8: for (Map.Entry entry : multipartRequest.getMultiFileMap().entrySet()) {
                List filelist = (List)entry.getValue();
                if (filelist == null || filelist.size() <= 0) continue;
                for (int i = 0; i < filelist.size(); ++i) {
                    MultipartFile mFile = (MultipartFile)filelist.get(i);
                    if (mFile.isEmpty()) continue;
                    if (!this.nodeService.hasCapacity(space, mFile.getSize())) {
                        throw new SpaceExhaustException(space.getName());
                    }
                    com.gtis.fileCenter.model.impl.File file2 = new com.gtis.fileCenter.model.impl.File();
                    if (StringUtils.isNotBlank((String)desc)) {
                        file2.setDescription(desc);
                    }
                    if (StringUtils.isNotBlank((String)viewName)) {
                        file2.setViewName(viewName);
                    }
                    file2.setParentId(node.getId());
                    String name = mFile.getOriginalFilename();
                    try {
                        Node sameNameNode = this.nodeService.getChildNode(nodeId, name);
                        if (cover) {
                            if (!(sameNameNode instanceof com.gtis.fileCenter.model.impl.File)) throw new NestedRuntimeException("can not cover a folder");
                            this.fileService.delete((com.gtis.fileCenter.model.impl.File)sameNameNode);
                            file2.setId(sameNameNode.getId());
                        } else if (!autoRename) {
                            throw new NodeExistsException(node.getId(), name);
                        }
                    }
                    catch (NodeNotFoundException ignored) {
                        // empty catch block
                    }
                    file2.setName(name);
                    file2.setSize(mFile.getSize());
                    file2.setOwner(userId);
                    this.nodeService.save((Node)file2, autoRename);
                    this.fileService.save(file2, mFile.getInputStream());
                    this.nodeService.save((Node)file2);
                    logger.info("upload file [{}] success", (Object)file2);
                    files.add(NodeHelper.nodeToJson((Node)file2));
                    if (!multi) continue block8;
                }
            }
            map.put("type", Integer.valueOf(0));
        }
        catch (NodeNotFoundException e) {
            FileController.putError(map, (int)1, (String)e.getMessage(), (Exception)((Object)e));
        }
        catch (NodeExistsException e) {
            FileController.putError(map, (int)2, (String)e.getMessage(), (Exception)((Object)e));
        }
        catch (FileIOException e) {
            FileController.putError(map, (int)3, (String)e.getMessage(), (Exception)((Object)e));
        }
        catch (SpaceExhaustException e) {
            FileController.putError(map, (int)4, (String)e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            FileController.putError(map, (int)5, (String)e.getMessage(), (Exception)e);
        }
        if (multi) {
            map.put("files", files);
        } else if (files.size() == 1) {
            map.put("file", (Serializable)files.get(0));
        }
        if ("js".equals(client)) {
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().write("<script type=\"text/javascript\">try{(opener || parent)." + (StringUtils.isBlank((String)callBack) ? "OnUploadCompleted" : callBack) + "(" + JsonUtils.toString(map) + ");}catch(e){}</script>");
            return;
        } else if ("fck".equals(client)) {
            StringBuilder sb = new StringBuilder("<script type=\"text/javascript\">try{(opener || parent).OnUploadCompleted(");
            Integer type = (Integer)map.get("type");
            if (type.equals(0)) {
                file = (Map)map.get("file");
                String url = request.getContextPath() + "/file/get.do?fid=" + file.get("id");
                sb.append("0,'").append(url).append("','").append(file.get("name")).append("'");
            } else {
                sb.append("1,null,null,'").append(map.get("msg")).append("'");
            }
            sb.append(");}catch(e){}</script>");
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().print(sb);
            return;
        } else if ("ke".equals(client)) {
            Integer type = (Integer)map.get("type");
            StringBuilder sb = new StringBuilder("{\"error\":");
            sb.append(type.equals(0) ? "0" : "1");
            if (type.equals(0)) {
                file = (Map)map.get("file");
                sb.append(",\"url\":\"").append(request.getContextPath()).append("/file/get.do?fid=").append(file.get("id"));
            } else {
                sb.append(",\"message\":\"").append(map.get("msg"));
            }
            sb.append("\"}");
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().print(sb);
            return;
        } else {
            response.setContentType("text/html;charset=utf-8");
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setCharacterEncoding("utf-8");
            response.getWriter().println(JSON.toJSONString(map));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping
    public void uploadByProid(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map file;
        if (!"post".equals(request.getMethod().toLowerCase())) return;
        String client = request.getParameter("client");
        String path = request.getParameter("path");
        if ("ke".equals(client)) {
            path = request.getParameter("dir");
        }
        String callBack = request.getParameter("callBack");
        String desc = request.getParameter("desc");
        String viewName = request.getParameter("viewName");
        String userId = request.getParameter("userId");
        boolean cover = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"cover", (boolean)false);
        boolean multi = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"multi", (boolean)false);
        boolean autoRename = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"rename", (boolean)false);
        String proid = request.getParameter("proid");
        Space space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
        Node rootNode = this.nodeService.getNode(space.getId(), proid, true);
        this.checkWriteable(request, new Integer[]{rootNode.getId()});
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        ArrayList<Map> files = new ArrayList<Map>();
        try {
            Node node = StringUtils.isNotBlank((String)path) ? this.nodeService.getNode(rootNode.getId(), path, true) : this.nodeService.getNode(rootNode.getId());
            Integer nodeId = node.getId();
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            block8: for (Map.Entry entry : multipartRequest.getMultiFileMap().entrySet()) {
                List filelist = (List)entry.getValue();
                if (filelist == null || filelist.size() <= 0) continue;
                for (int i = 0; i < filelist.size(); ++i) {
                    MultipartFile mFile = (MultipartFile)filelist.get(i);
                    if (mFile.isEmpty()) continue;
                    if (!this.nodeService.hasCapacity(space, mFile.getSize())) {
                        throw new SpaceExhaustException(space.getName());
                    }
                    com.gtis.fileCenter.model.impl.File file2 = new com.gtis.fileCenter.model.impl.File();
                    if (StringUtils.isNotBlank((String)desc)) {
                        file2.setDescription(desc);
                    }
                    if (StringUtils.isNotBlank((String)viewName)) {
                        file2.setViewName(viewName);
                    }
                    file2.setParentId(node.getId());
                    String name = mFile.getOriginalFilename();
                    try {
                        Node sameNameNode = this.nodeService.getChildNode(nodeId, name);
                        if (cover) {
                            if (!(sameNameNode instanceof com.gtis.fileCenter.model.impl.File)) throw new NestedRuntimeException("can not cover a folder");
                            this.fileService.delete((com.gtis.fileCenter.model.impl.File)sameNameNode);
                            file2.setId(sameNameNode.getId());
                        } else if (!autoRename) {
                            throw new NodeExistsException(node.getId(), name);
                        }
                    }
                    catch (NodeNotFoundException ignored) {
                        // empty catch block
                    }
                    file2.setName(name);
                    file2.setSize(mFile.getSize());
                    file2.setOwner(userId);
                    this.nodeService.save((Node)file2, autoRename);
                    this.fileService.save(file2, mFile.getInputStream());
                    this.nodeService.save((Node)file2);
                    logger.info("upload file [{}] success", (Object)file2);
                    files.add(NodeHelper.nodeToJson((Node)file2));
                    if (!multi) continue block8;
                }
            }
            map.put("type", Integer.valueOf(0));
        }
        catch (NodeNotFoundException e) {
            FileController.putError(map, (int)1, (String)e.getMessage(), (Exception)((Object)e));
        }
        catch (NodeExistsException e) {
            FileController.putError(map, (int)2, (String)e.getMessage(), (Exception)((Object)e));
        }
        catch (FileIOException e) {
            FileController.putError(map, (int)3, (String)e.getMessage(), (Exception)((Object)e));
        }
        catch (SpaceExhaustException e) {
            FileController.putError(map, (int)4, (String)e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            FileController.putError(map, (int)5, (String)e.getMessage(), (Exception)e);
        }
        if (multi) {
            map.put("files", files);
        } else if (files.size() == 1) {
            map.put("file", (Serializable)files.get(0));
        }
        if ("js".equals(client)) {
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().write("<script type=\"text/javascript\">try{(opener || parent)." + (StringUtils.isBlank((String)callBack) ? "OnUploadCompleted" : callBack) + "(" + JsonUtils.toString(map) + ");}catch(e){}</script>");
            return;
        } else if ("fck".equals(client)) {
            StringBuilder sb = new StringBuilder("<script type=\"text/javascript\">try{(opener || parent).OnUploadCompleted(");
            Integer type = (Integer)map.get("type");
            if (type.equals(0)) {
                file = (Map)map.get("file");
                String url = request.getContextPath() + "/file/get.do?fid=" + file.get("id");
                sb.append("0,'").append(url).append("','").append(file.get("name")).append("'");
            } else {
                sb.append("1,null,null,'").append(map.get("msg")).append("'");
            }
            sb.append(");}catch(e){}</script>");
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().print(sb);
            return;
        } else if ("ke".equals(client)) {
            Integer type = (Integer)map.get("type");
            StringBuilder sb = new StringBuilder("{\"error\":");
            sb.append(type.equals(0) ? "0" : "1");
            if (type.equals(0)) {
                file = (Map)map.get("file");
                sb.append(",\"url\":\"").append(request.getContextPath()).append("/file/get.do?fid=").append(file.get("id"));
            } else {
                sb.append(",\"message\":\"").append(map.get("msg"));
            }
            sb.append("\"}");
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().print(sb);
            return;
        } else {
            JsonUtils.out((HttpServletResponse)response, map);
        }
    }

    private static void putError(Map<String, Object> map, int errType, String msg, Exception e) {
        logger.error("upload error", (Throwable)e);
        map.put("type", errType);
        map.put("msg", msg);
    }

    @RequestMapping
    public void check(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] names = request.getParameterValues("name");
        String path = request.getParameter("path");
        Integer nodeId = FileController.getNodeId((HttpServletRequest)request);
        HashMap<String, Boolean> invalidNames = new HashMap<String, Boolean>();
        for (String name : names) {
            try {
                Node node = this.nodeService.getNode(nodeId, (StringUtils.isNotBlank((String)path) ? path + "/" : "") + name);
                invalidNames.put(name, node instanceof com.gtis.fileCenter.model.impl.File);
            }
            catch (NodeNotFoundException ignored) {
                // empty catch block
            }
        }
        JsonUtils.out((HttpServletResponse)response, invalidNames);
    }

    @RequestMapping
    public void list(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer nodeId = FileController.getFileId((HttpServletRequest)request);
        String path = request.getParameter("path");
        boolean all = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"all", (boolean)false);
        ArrayList<Map> list = new ArrayList<Map>();
        Map currentNode = null;
        try {
            if (!this.hasPermission(nodeId)) {
                throw new NoPermissionException(nodeId);
            }
            Node node = StringUtils.isNotBlank((String)path) ? this.nodeService.getNode(nodeId, path) : this.nodeService.getNode(nodeId);
            nodeId = node.getId();
            currentNode = NodeHelper.nodeToJson((Node)node);
            List nodes = all ? this.nodeService.getAllChildNodes(nodeId) : this.nodeService.getChildNodes(nodeId);
            String viewFileListField = AppConfig.getProperty((String)"viewFileList.field");
            if (StringUtils.isNotBlank((String)viewFileListField) && StringUtils.equals((String)viewFileListField, (String)"update_time")) {
                ComparatorNodes comparator = new ComparatorNodes();
                Collections.sort(nodes, comparator);
            }
            for (Node n : nodes) {
                if (!(n instanceof com.gtis.fileCenter.model.impl.File)) continue;
                list.add(NodeHelper.nodeToJson((Node)n));
            }
        }
        catch (Exception e) {
            logger.error("list file for node [" + nodeId + "] error", (Throwable)e);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("items", list);
        map.put("total", list.size());
        map.put("node", currentNode);
        JsonUtils.out((HttpServletResponse)response, map);
    }

    @RequestMapping
    public ModelAndView get(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String token;
        Integer nodeId = FileController.getFileId((HttpServletRequest)request);
        if (!this.hasPermission(nodeId)) {
            throw new NoPermissionException(nodeId);
        }
        Boolean enablePreview = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"enablePreview", (boolean)Boolean.FALSE);
        Boolean isInline = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"inline", (boolean)Boolean.FALSE);
        String type = request.getParameter("type");
        String page = request.getParameter("page");
        Node node = this.nodeService.getNode(nodeId);
        if (node.getScope() == 1 && this.nodeService.hasPermission(token = request.getParameter("token"), nodeId)) {
            throw new NoPermissionException(nodeId);
        }
        if (node instanceof com.gtis.fileCenter.model.impl.File) {
            long modDate;
            com.gtis.fileCenter.model.impl.File file = (com.gtis.fileCenter.model.impl.File)node;
            if ("micro".equals(type)) {
                file = new MicroFile(file);
            } else if ("preview".equals(type)) {
                file = new PreviewFile(file);
            }
            File diskFile = this.fileService.getFile(file);
            if (!diskFile.exists()) {
                if ("preview".equals(type)) {
                    PreviewFile pf = (PreviewFile)file;
                    request.setAttribute("file", (Object)pf.getFile());
                    if (!this.fileService.getFile(pf.getFile()).exists()) {
                        return new ModelAndView("notExists");
                    }
                    try {
                        this.fileService.createPreviewFile(pf);
                    }
                    catch (FileOverSizeException e) {
                        return new ModelAndView("overSize");
                    }
                    return new ModelAndView("converting");
                }
                if ("micro".equals(type)) {
                    String previewSize = request.getParameter("previewSize");
                    if (StringUtils.isNotBlank((String)previewSize)) {
                        this.fileService.createMicroImage((MicroFile)file, Integer.parseInt(previewSize));
                    } else {
                        this.fileService.createMicroImage((MicroFile)file);
                    }
                    diskFile = this.fileService.getFile(file);
                    if (!diskFile.exists()) {
                        return new ModelAndView("redirect:/images/icon/big/jpg.gif");
                    }
                } else {
                    response.sendError(404, "file [" + node.getName() + "] not found");
                    return null;
                }
            }
            long modified = diskFile.lastModified();
            long modifiedSince = request.getDateHeader("If-Modified-Since");
            if (modifiedSince > 0L && (modDate = modified / 1000L * 1000L) <= modifiedSince) {
                response.setStatus(304);
                return null;
            }
            response.setDateHeader("Last-Modified", modified);
            if ("text".equals(type)) {
                request.setAttribute("file", (Object)file);
                request.setAttribute("content", (Object)this.fileService.toString(file));
                return new ModelAndView("text");
            }
            if ("preview".equals(type)) {
                request.setAttribute("file", (Object)((PreviewFile)file).getFile());
                if (this.useDocServer) {
                    request.setAttribute("useDocServer", (Object)this.useDocServer);
                    return new ModelAndView("redirect:/doc/doc/" + nodeId + "/0.htm?_t=" + file.getUpdateTime().getTime());
                }
                String ext = ((PreviewFile)file).getFile().getExtension();
                if (!"xls".equals(ext) && !"xlsx".equals(ext)) {
                    if (!StringUtils.isBlank((String)page)) {
                        response.reset();
                        response.setContentType(this.mimeTypeService.getMimeType(page));
                        this.fileService.transferZipContainedFileTo(file, page, response.getOutputStream());
                        return null;
                    }
                    return new ModelAndView("preview");
                }
            }
            response.setContentType(this.mimeTypeService.getMimeType(file.getName()));
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("Content-Disposition", (type != null || isInline != false || enablePreview == false && file.isDocument() ? "inline" : "attachment") + "; filename=\"" + new String(file.getName().getBytes("gbk"), "iso8859-1") + "\"");
            long start = 0L;
            long size = diskFile.length();
            String range = request.getHeader("Range");
            if (range != null && range.startsWith("bytes=")) {
                int minus = range.indexOf(45);
                if (minus > -1) {
                    range = range.substring(6, minus);
                }
                try {
                    start = Long.parseLong(range);
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            if (start > 0L) {
                response.setStatus(206);
                StringBuilder sb = new StringBuilder("bytes ");
                sb.append(start).append("-").append(size - 1L).append("/").append(size);
                response.setHeader("Content-Range", sb.toString());
            }
            response.setContentLength((int)(size - start));
            try {
                this.fileService.transferTo(file, start, (OutputStream)response.getOutputStream());
            }
            catch (Exception e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
        throw new NestedRuntimeException("not a file");
        return null;
    }

    @RequestMapping
    public void preview(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer nodeId = FileController.getFileId((HttpServletRequest)request);
        Node node = this.nodeService.getNode(nodeId);
        com.gtis.fileCenter.model.impl.File file = (com.gtis.fileCenter.model.impl.File)node;
        if ("post".equals(request.getMethod().toLowerCase())) {
            MultipartFile mFile;
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Iterator it = multipartRequest.getFileNames();
            if (it.hasNext() && !(mFile = multipartRequest.getFile((String)it.next())).isEmpty()) {
                file = new PreviewFile(file);
                this.fileService.save(file, mFile.getInputStream());
            }
        } else if (this.fileService.exists(file)) {
            this.fileService.transferTo(file, 0L, (OutputStream)response.getOutputStream());
        } else {
            response.sendError(404, "file [" + node.getName() + "] not found");
        }
    }

    @RequestMapping
    public ModelAndView print(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer nodeId = FileController.getFileId((HttpServletRequest)request);
        Node node = this.nodeService.getNode(nodeId);
        com.gtis.fileCenter.model.impl.File file = (com.gtis.fileCenter.model.impl.File)node;
        request.setAttribute("file", (Object)file);
        return new ModelAndView("print");
    }

    @RequestMapping
    public ModelAndView uploadExe(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer nodeId = FileController.getFileId((HttpServletRequest)request);
        Node node = this.nodeService.getNode(nodeId);
        request.setAttribute("node", (Object)node);
        request.setAttribute("fileCenterUrl", (Object)this.fileCenterUrl);
        return new ModelAndView("fileUploadExe");
    }

    private boolean hasPermission(Integer nodeId) {
        Space space = this.nodeService.getSpace(nodeId);
        if (space instanceof PersonalSpace) {
            String userId = Helper.getCurrentUserId();
            if (userId != null) {
                if (!this.nodeService.isChildNode(space.getId(), nodeId)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static Integer getNodeId(HttpServletRequest request) {
        return NodeHelper.getIntegerParameter((HttpServletRequest)request, (String)"nid");
    }

    private static Integer getFileId(HttpServletRequest request) {
        return NodeHelper.getIntegerParameter((HttpServletRequest)request, (String)"fid");
    }

    private void checkWriteable(HttpServletRequest request, Integer ... nodeIds) {
        String token = request.getParameter("token");
        if (token != null && !this.nodeService.isWriteable(token)) {
            throw new NoPermissionException(Arrays.toString((Object[])nodeIds));
        }
    }
}

