/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.web;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.web.BaseController;
import com.gtis.generic.util.JsonUtils;
import java.net.URLDecoder;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"/fc"})
public class FileCenterController
extends BaseController {
    public static final String ACCESS_CONTROL_ALLOW_ORIGN = "Access-Control-Allow-Origin";
    public static final String WORK_FLOW_STUFF = "WORK_FLOW_STUFF";

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public ModelAndView fc(HttpServletResponse response, Model model, String proid, String readOnly, String type, HttpServletRequest request) {
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGN, "*");
        Space space = this.nodeService.getWorkSpace(WORK_FLOW_STUFF, true);
        Node prjNode = this.nodeService.getNode(space.getId(), proid, true);
        Integer rootId = prjNode.getId();
        String token = this.nodeService.getToken(prjNode);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("disable", false);
        params.put("rootId", rootId.toString());
        params.put("token", token);
        params.put("readOnly", readOnly);
        model.addAttribute("rootId", (Object)rootId.toString());
        model.addAttribute("token", (Object)token);
        model.addAttribute("readOnly", (Object)readOnly);
        request.setAttribute("params", (Object)JsonUtils.toString(params));
        return new ModelAndView("fc");
    }

    @RequestMapping(value={"/folder.do"}, method={RequestMethod.GET})
    public ModelAndView folder(HttpServletResponse response, Model model, String proid, String readOnly, String type, HttpServletRequest request) {
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGN, "*");
        Space space = this.nodeService.getWorkSpace(WORK_FLOW_STUFF, true);
        Node prjNode = this.nodeService.getNode(space.getId(), proid, true);
        Integer rootId = prjNode.getId();
        String token = this.nodeService.getToken(prjNode);
        boolean isroot = true;
        String folderName = request.getParameter("folderName");
        try {
            Node childNode;
            if (StringUtils.isNotBlank((String)folderName)) {
                folderName = URLDecoder.decode(folderName, "utf-8");
            }
            if (prjNode != null && StringUtils.isNotBlank((String)folderName) && (childNode = this.nodeService.getChildNode(prjNode.getId(), folderName)) != null) {
                isroot = false;
                rootId = childNode.getId();
                token = this.nodeService.getToken(childNode);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rootId", rootId.toString());
        params.put("token", token);
        params.put("disable", false);
        params.put("readOnly", readOnly);
        model.addAllAttributes(params);
        request.setAttribute("params", (Object)JsonUtils.toString(params));
        if (isroot) {
            return new ModelAndView("fc");
        }
        return new ModelAndView("folder");
    }
}

