/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.service.impl;

import com.gtis.fileCenter.Constants;
import com.gtis.fileCenter.dao.NodeDao;
import com.gtis.fileCenter.ex.NodeExistsException;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.PreviewFile;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.NodeImpl;
import com.gtis.fileCenter.model.impl.PersonalSpace;
import com.gtis.fileCenter.model.impl.SpaceImpl;
import com.gtis.fileCenter.model.impl.WorkSpace;
import com.gtis.fileCenter.service.FileStoreService;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.generic.cache.Cache;
import com.gtis.generic.cache.CacheUtils;
import com.gtis.generic.cache.EntityLoader;
import com.gtis.generic.security.Helper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.FileHeader;
import net.sf.ehcache.Ehcache;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
public class NodeServiceImpl
implements NodeService {
    private static final Logger logger = LoggerFactory.getLogger(NodeServiceImpl.class);
    private static final int MAX_CACHE_NODE = 100;
    @Autowired
    private FileStoreService fileService;
    @Autowired
    private NodeDao nodeDao;
    private Cache<Node> nodeCache;
    private Ehcache tokenCache;
    private String superToken = "whosyourdaddy";
    private boolean enablePreview;

    public void setNodeCache(Ehcache nodeCache) {
        this.nodeCache = new Cache(nodeCache);
    }

    public void setTokenCache(Ehcache tokenCache) {
        this.tokenCache = tokenCache;
    }

    public void setSuperToken(String superToken) {
        this.superToken = superToken;
    }

    public void setEnablePreview(boolean enablePreview) {
        this.enablePreview = enablePreview;
    }

    public String getToken(Node node) {
        return this.getToken(node, null);
    }

    public String getToken(Node node, Integer ttl) {
        return this.getToken(node, true, null);
    }

    public String getToken(Node node, boolean writeable) {
        return this.getToken(node, writeable, null);
    }

    public Integer getTokenRoot(String token) {
        return (Integer)CacheUtils.load((Ehcache)this.tokenCache, (Object)token);
    }

    public String getToken(Node node, boolean writeable, Integer ttl) {
        String key = CacheUtils.getKey((Object[])new Object[]{node.getId(), BooleanUtils.toInteger((boolean)writeable), ttl});
        String token = (String)CacheUtils.load((Ehcache)this.tokenCache, (Object)key);
        if (token != null && CacheUtils.getExpirationTime((Ehcache)this.tokenCache, (Object)key) - 5400000L > System.currentTimeMillis()) {
            return token;
        }
        token = (writeable ? 1 : 0) + RandomStringUtils.randomAlphanumeric((int)12);
        CacheUtils.put((Ehcache)this.tokenCache, (Object)token, (Object)node.getId(), (Integer)ttl);
        CacheUtils.put((Ehcache)this.tokenCache, (Object)CacheUtils.getKey((Object[])new Object[]{node.getId(), BooleanUtils.toInteger((boolean)writeable), ttl}), (Object)token, (Integer)ttl);
        logger.debug("create access token ({}) for node ({})", (Object)token, (Object)node);
        return token;
    }

    public boolean isWriteable(String token) {
        return token.charAt(0) - 48 == 1 || this.superToken.equals(token);
    }

    public boolean hasPermission(String token, Integer nodeId) {
        if (this.superToken.equals(token)) {
            return true;
        }
        Integer tokenNodeId = (Integer)CacheUtils.load((Ehcache)this.tokenCache, (Object)token);
        if (tokenNodeId != null) {
            try {
                return tokenNodeId.equals(nodeId) || this.isChildNode(tokenNodeId, nodeId);
            }
            catch (NodeNotFoundException ignored) {
                // empty catch block
            }
        }
        return false;
    }

    public Node getRootNode() throws NodeNotFoundException {
        return this.getNodeByType(-1);
    }

    public Space getPersonalSpace(String userId) throws NodeNotFoundException {
        return (Space)this.getNodeByType(userId, 3);
    }

    public Space getWorkSpace(String name) throws NodeNotFoundException {
        return (Space)this.getNodeByType(name, 2);
    }

    public Space getWorkSpace(String name, boolean autoCreate) throws NodeNotFoundException {
        Space space;
        try {
            space = this.getWorkSpace(name);
        }
        catch (NodeNotFoundException e) {
            if (autoCreate) {
                try {
                    space = this.createWorkSpace(name);
                }
                catch (NodeExistsException e1) {
                    return this.getWorkSpace(name);
                }
            }
            throw e;
        }
        return space;
    }

    public Space getSpace(Integer nodeId) throws NodeNotFoundException {
        Node node = this.getNode(nodeId);
        if (node instanceof Space) {
            return (Space)node;
        }
        for (String id : Constants.PATH_SEPARATOR.split(node.getPath())) {
            if (!StringUtils.isNotEmpty((String)id) || !((node = this.getNode0(Integer.valueOf(id))) instanceof Space)) continue;
            return (Space)node;
        }
        return null;
    }

    public boolean hasCapacity(Space space, long size) {
        return space.getSize() == -1L || space.getUsedSize() + size < space.getSize();
    }

    public Node getNodeByType(int type) throws NodeNotFoundException {
        return this.getNodeByType(null, type);
    }

    public Node getNodeByType(String name, int type) throws NodeNotFoundException {
        return NodeServiceImpl.clone((Node)((Node)this.nodeCache.load((EntityLoader)new /* Unavailable Anonymous Inner Class!! */, new Object[]{name, type})));
    }

    protected NodeImpl getNode0(Integer nodeId) throws NodeNotFoundException {
        Node node = (Node)this.nodeCache.load(new Object[]{nodeId});
        if (node == null) {
            node = this.nodeDao.getNode(nodeId);
            this.nodeCache.put((Object)node, new Object[]{nodeId});
        }
        return (NodeImpl)node;
    }

    protected static Node clone(Node node) {
        try {
            return node.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Node getNode(Integer nodeId) throws NodeNotFoundException {
        return NodeServiceImpl.clone((Node)this.getNode0(nodeId));
    }

    public Node getNode(Integer parentNodeId, String path) throws NodeNotFoundException {
        return this.getNode(parentNodeId, path, false);
    }

    public Node getNode(Integer parentNodeId, String path, boolean autoCreate) {
        return this.getNode(parentNodeId, path, autoCreate, null);
    }

    public Node getNode(Integer parentNodeId, String path, boolean autoCreate, String userId) {
        NodeImpl node = this.getNode0(parentNodeId);
        if (StringUtils.isNotBlank((String)path)) {
            for (String name : Constants.PATH_SEPARATOR.split(path)) {
                if (node instanceof com.gtis.fileCenter.model.impl.File) {
                    throw new NodeNotFoundException(parentNodeId, path);
                }
                if (StringUtils.isBlank((String)name)) continue;
                int nodeId = node.getId();
                try {
                    node = this.getChildNode(Integer.valueOf(nodeId), name);
                }
                catch (NodeNotFoundException e) {
                    if (autoCreate) {
                        try {
                            node = this.createNode(Integer.valueOf(nodeId), name, userId);
                            continue;
                        }
                        catch (NodeExistsException e1) {
                            return this.getChildNode(Integer.valueOf(nodeId), name);
                        }
                    }
                    throw e;
                }
            }
        }
        return node;
    }

    public List<Node> getNodes(Integer[] nodeIds) {
        ArrayList<Node> nodes = new ArrayList<Node>(nodeIds.length);
        for (Integer nodeId : nodeIds) {
            nodes.add(this.getNode(nodeId));
        }
        return nodes;
    }

    public Node getParentNode(Integer nodeId) throws NodeNotFoundException {
        return this.getNode(this.getNode0(nodeId).getParentId());
    }

    public Node getChildNode(Integer nodeId, String name) throws NodeNotFoundException {
        NodeImpl node = this.getNode0(nodeId);
        if (node.isChildrenUnSet()) {
            return NodeServiceImpl.clone((Node)((Node)this.nodeCache.load((EntityLoader)new /* Unavailable Anonymous Inner Class!! */, new Object[]{nodeId, name})));
        }
        NodeImpl n = node.getChild(name);
        if (n != null) {
            return NodeServiceImpl.clone((Node)n);
        }
        throw new NodeNotFoundException(nodeId, name);
    }

    public List<Node> getChildNodes(Integer nodeId) {
        NodeImpl node = this.getNode0(nodeId);
        List children = node.getChildren();
        if (children == null && (children = this.nodeDao.getChildNodes(nodeId)).size() < 100) {
            node.setChildren(children);
            for (Node n : children) {
                this.nodeCache.put((Object)n, new Object[]{n.getId()});
            }
        }
        return children;
    }

    public List<Node> getAllChildNodes(Integer nodeId) {
        NodeImpl node = this.getNode0(nodeId);
        return this.nodeDao.getAllChildNodes(node.getFullPath());
    }

    public List<com.gtis.fileCenter.model.impl.File> getAllChildFile(Integer nodeId, int start, int size) {
        NodeImpl node = this.getNode0(nodeId);
        return this.nodeDao.getAllChildFiles(node.getFullPath(), start, size);
    }

    public int getAllChildFilesCount(Integer nodeId) {
        NodeImpl node = this.getNode0(nodeId);
        return this.nodeDao.getAllChildFilesCount(node.getFullPath());
    }

    public List<Node> search(Integer nodeId, String keyword) {
        NodeImpl node = this.getNode0(nodeId);
        return this.nodeDao.search(node.getFullPath(), keyword);
    }

    public List<Node> getPath(Integer nodeId) {
        ArrayList<Node> path = new ArrayList<Node>();
        NodeImpl n = this.getNode0(nodeId);
        while (n.getParentId() != null && n.getType() != 2 && n.getType() != 3) {
            path.add((Node)n);
            n = this.getNode0(n.getParentId());
        }
        return path;
    }

    public boolean exists(Integer nodeId) {
        return this.nodeCache.exist(new Object[]{nodeId}) || this.nodeDao.exists(nodeId);
    }

    public boolean isNodeNameUsed(Integer parentNodeId, String name) {
        try {
            return this.getChildNode(parentNodeId, name) != null;
        }
        catch (NodeNotFoundException e) {
            return false;
        }
    }

    public boolean isChildNode(Integer parentNodeId, Integer nodeId) {
        try {
            NodeImpl pNode = this.getNode0(parentNodeId);
            NodeImpl node = this.getNode0(nodeId);
            if (node.getPath().startsWith(pNode.getPath()) && !node.getParentId().equals(pNode.getParentId())) {
                return true;
            }
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public Node save(Node node) throws NodeNotFoundException, NodeExistsException {
        return this.save(node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node save(Node node1, boolean autoRename) throws NodeNotFoundException, NodeExistsException {
        boolean isCreate;
        NodeImpl node = (NodeImpl)node1;
        if (StringUtils.isBlank((String)node.getName())) {
            throw new IllegalArgumentException("node name can not be null");
        }
        if (node.getType() < 0) {
            throw new IllegalArgumentException("type must greater than 0");
        }
        if (node instanceof PersonalSpace) {
            node.setParentId(this.getNodeByType(-2).getId());
        } else if (node instanceof WorkSpace) {
            node.setParentId(this.getNodeByType(-3).getId());
        }
        Integer parentId = node.getParentId();
        boolean needCheckName = isCreate = node.getId() == null;
        String srcName = null;
        long srcSize = 0L;
        NodeServiceImpl nodeServiceImpl = this;
        synchronized (nodeServiceImpl) {
            if (!isCreate) {
                NodeImpl srcNode = this.getNode0(node.getId());
                srcName = srcNode.getName();
                boolean bl = needCheckName = !srcNode.getName().equals(node.getName());
                if (node instanceof com.gtis.fileCenter.model.impl.File && srcNode instanceof com.gtis.fileCenter.model.impl.File) {
                    com.gtis.fileCenter.model.impl.File file = (com.gtis.fileCenter.model.impl.File)node;
                    srcSize = file.getSize();
                }
            }
            if (needCheckName && this.isNodeNameUsed(parentId, node.getName())) {
                if (autoRename) {
                    node.setName(this.rename(parentId, node.getName()));
                } else {
                    throw new NodeExistsException(parentId, node.getName());
                }
            }
            node.setPath(this.getNode0(parentId).getFullPath());
            if (node.getOwner() == null) {
                node.setOwner(Helper.getCurrentUserId());
            }
            node.setUpdateTime(new Date());
            this.nodeDao.save((Node)node);
            this.nodeCache.put((Object)node, new Object[]{node.getId()});
            NodeImpl pNode = this.getNode0(parentId);
            if (srcName != null) {
                pNode.removeChild(srcName);
                if (needCheckName) {
                    this.nodeCache.clear(new Object[]{node.getParentId(), srcName});
                }
            }
            pNode.addChild((Node)node);
        }
        if (node instanceof com.gtis.fileCenter.model.impl.File) {
            try {
                com.gtis.fileCenter.model.impl.File file = (com.gtis.fileCenter.model.impl.File)node;
                ((SpaceImpl)this.getSpace(node.getId())).setUsed(file.getSize() - srcSize);
                if (this.enablePreview && file.isDocument()) {
                    PreviewFile pf = new PreviewFile(file);
                    if (this.fileService.getFile(file).exists() && !this.fileService.getFile((com.gtis.fileCenter.model.impl.File)pf).exists()) {
                        this.fileService.createPreviewFile(pf);
                    }
                }
            }
            catch (Exception e) {
                logger.error("process file error:", (Throwable)e);
            }
        }
        return NodeServiceImpl.clone((Node)node);
    }

    public Node createNode(Integer parentId, String name, String viewName, String description, Integer scope, String owner, Map<String, String> attributes) {
        NodeImpl node = new NodeImpl();
        node.setParentId(parentId);
        node.setName(name);
        node.setViewName(viewName);
        node.setDescription(description);
        if (scope != null) {
            node.setScope(scope.intValue());
        }
        node.setOwner(owner);
        node.setAttributes(attributes);
        return this.save((Node)node);
    }

    public Node createNode(Integer parentId, String name) {
        return this.createNode(parentId, name, null, null, null, null, null);
    }

    public Node createNode(Integer parentId, String name, String userId) {
        return this.createNode(parentId, name, null, null, null, userId, null);
    }

    public Space createWorkSpace(String name, String viewName, Long size, String description, Map<String, String> attributes) {
        WorkSpace node = new WorkSpace();
        node.setName(name);
        node.setViewName(viewName);
        node.setDescription(description);
        node.setAttributes(attributes);
        node.setSize(size.longValue());
        return (Space)this.save((Node)node);
    }

    public Space createWorkSpace(String name) {
        return this.createWorkSpace(name, null, Long.valueOf(-1L), null, null);
    }

    private String rename(Integer nodeId, String fileName) {
        int index = fileName.lastIndexOf(46);
        String name = index > -1 ? fileName.substring(0, index) : fileName;
        String ext = index > -1 ? fileName.substring(index) : "";
        String name1 = name + "_1" + ext;
        int i = 1;
        while (this.isNodeNameUsed(nodeId, name1)) {
            name1 = name + "_" + i + ext;
            ++i;
        }
        return name1;
    }

    public void remove(Integer nodeId) {
        NodeImpl node = this.getNode0(nodeId);
        if (node != null && (node.getType() == 0 || node.getType() == 1)) {
            this.deleteSingleNode((Node)node);
            if (!(node instanceof com.gtis.fileCenter.model.impl.File)) {
                for (Node n : this.getAllChildNodes(nodeId)) {
                    this.deleteSingleNode(n);
                }
            }
            this.getNode0(node.getParentId()).removeChild(node.getName());
        }
        if (logger.isInfoEnabled()) {
            logger.info("***removing node_id:[" + nodeId + "],node_name:[" + node.getViewName() + "]***");
        }
    }

    protected void deleteSingleNode(Node node) {
        try {
            if (node instanceof com.gtis.fileCenter.model.impl.File) {
                com.gtis.fileCenter.model.impl.File file = (com.gtis.fileCenter.model.impl.File)node;
                this.fileService.delete(file);
                ((SpaceImpl)this.getSpace(file.getId())).setUsed(-file.getSize());
            }
            this.nodeCache.clear(new Object[]{node.getId()});
            this.nodeCache.clear(new Object[]{node.getParentId(), node.getName()});
            this.nodeDao.remove(node.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remove(Integer[] nodeIds) {
        for (Integer nodeId : nodeIds) {
            this.remove(nodeId);
        }
    }

    public void copy(Integer[] nodeIds, Integer destNodeId, boolean cover) {
        for (Integer nodeId : nodeIds) {
            try {
                this.copyNode((Node)this.getNode0(nodeId), (Node)this.getNode0(destNodeId), cover);
            }
            catch (NodeNotFoundException ignored) {
                // empty catch block
            }
        }
    }

    private void copyNode(Node node, Node destNode, boolean cover) {
        if (node.getId().equals(destNode.getId()) || node.getParentId().equals(destNode.getId()) || this.isChildNode(node.getId(), destNode.getId())) {
            return;
        }
        boolean isFile = node instanceof com.gtis.fileCenter.model.impl.File;
        NodeImpl sameNameNode = null;
        NodeImpl newNode = (NodeImpl)NodeServiceImpl.clone((Node)node);
        try {
            sameNameNode = (NodeImpl)this.getChildNode(destNode.getId(), node.getName());
        }
        catch (NodeNotFoundException ignored) {
            // empty catch block
        }
        if (sameNameNode != null && cover) {
            if (isFile) {
                if (!(sameNameNode instanceof com.gtis.fileCenter.model.impl.File)) {
                    return;
                }
                this.remove(sameNameNode.getId());
            } else {
                if (sameNameNode instanceof com.gtis.fileCenter.model.impl.File) {
                    return;
                }
                sameNameNode.setViewName(node.getViewName());
                sameNameNode.setOwner(node.getOwner());
                sameNameNode.setScope(node.getScope());
                sameNameNode.setDescription(node.getDescription());
                sameNameNode.setAttributes(node.getAttributes());
                newNode = sameNameNode;
            }
        }
        if (isFile) {
            com.gtis.fileCenter.model.impl.File file = (com.gtis.fileCenter.model.impl.File)newNode;
            file.setStoreUrl(null);
            this.fileService.copyTo((com.gtis.fileCenter.model.impl.File)node, (com.gtis.fileCenter.model.impl.File)newNode);
        } else {
            newNode.setChildren(Collections.emptyList());
        }
        newNode.setId(null);
        newNode.setParentId(destNode.getId());
        if (!cover) {
            this.save((Node)newNode, true);
        } else {
            this.save((Node)newNode);
        }
        if (!isFile) {
            for (Node n : this.getChildNodes(node.getId())) {
                this.copyNode(n, (Node)(sameNameNode != null && !(sameNameNode instanceof com.gtis.fileCenter.model.impl.File) ? sameNameNode : newNode), cover);
            }
        }
    }

    public void move(Integer[] nodeIds, Integer destNodeId, boolean cover) {
        for (Integer nodeId : nodeIds) {
            try {
                this.moveNode((Node)this.getNode0(nodeId), (Node)this.getNode0(destNodeId), cover);
            }
            catch (NodeNotFoundException ignored) {
                // empty catch block
            }
        }
    }

    private void moveNode(Node node, Node destNode, boolean cover) {
        if (node.getId().equals(destNode.getId()) || node.getParentId().equals(destNode.getId()) || this.isChildNode(node.getId(), destNode.getId())) {
            return;
        }
        boolean isFile = node instanceof com.gtis.fileCenter.model.impl.File;
        NodeImpl sameNameNode = null;
        try {
            sameNameNode = (NodeImpl)this.getChildNode(destNode.getId(), node.getName());
        }
        catch (NodeNotFoundException ignored) {
            // empty catch block
        }
        if (sameNameNode != null) {
            if (isFile) {
                if (!(sameNameNode instanceof com.gtis.fileCenter.model.impl.File) || !cover) {
                    return;
                }
                this.remove(sameNameNode.getId());
            } else {
                if (sameNameNode instanceof com.gtis.fileCenter.model.impl.File || !cover) {
                    return;
                }
                sameNameNode.setViewName(node.getViewName());
                sameNameNode.setOwner(node.getOwner());
                sameNameNode.setScope(node.getScope());
                sameNameNode.setDescription(node.getDescription());
                sameNameNode.setAttributes(node.getAttributes());
                node = sameNameNode;
            }
        }
        NodeImpl pNode = this.getNode0(node.getParentId());
        ((NodeImpl)node).setParentId(destNode.getId());
        this.save(node);
        pNode.removeChild(node.getName());
        if (!isFile) {
            for (Node n : this.getChildNodes(node.getId())) {
                this.moveNode(n, (Node)(sameNameNode != null && !(sameNameNode instanceof com.gtis.fileCenter.model.impl.File) ? sameNameNode : node), cover);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip(Integer[] nodeIds, Integer destNodeId, String name) throws NodeExistsException {
        if (this.isNodeNameUsed(destNodeId, name)) {
            throw new NodeExistsException(destNodeId, name);
        }
        com.gtis.fileCenter.model.impl.File file = new com.gtis.fileCenter.model.impl.File();
        file.setParentId(destNodeId);
        file.setName(name);
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(this.fileService.getFileOutputStream(file));
            zos.setEncoding("GBK");
            for (Integer nodeId : nodeIds) {
                NodeImpl topNode = this.getNode0(nodeId);
                if (topNode instanceof com.gtis.fileCenter.model.impl.File) {
                    this.addNodeToZip((com.gtis.fileCenter.model.impl.File)topNode, topNode.getName(), zos);
                    continue;
                }
                List nodes = this.getAllChildNodes(nodeId);
                for (Node node : nodes) {
                    if (!(node instanceof com.gtis.fileCenter.model.impl.File)) continue;
                    this.addNodeToZip((com.gtis.fileCenter.model.impl.File)node, this.getAbsFileName(node.getId(), nodeId), zos);
                }
            }
        }
        catch (Exception e) {
            logger.error("create zip file :[{}] error", (Object)file);
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException ignored) {}
        }
        this.save((Node)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNodeToZip(com.gtis.fileCenter.model.impl.File file, String zipEntryName, ZipOutputStream zos) {
        InputStream is = null;
        try {
            int readLen;
            zos.setEncoding("GBK");
            ZipEntry ze = new ZipEntry(zipEntryName);
            ze.setSize(file.getSize());
            ze.setTime(file.getUpdateTime().getTime());
            ze.setCrc(0L);
            CRC32 crc = new CRC32();
            crc.reset();
            zos.putNextEntry(ze);
            is = this.fileService.getFileInputStream(file);
            byte[] buf = new byte[5120];
            while ((readLen = is.read(buf, 0, 5120)) != -1) {
                zos.write(buf, 0, readLen);
                crc.update(buf, 0, readLen);
            }
            ze.setCrc(crc.getValue());
        }
        catch (IOException e) {
            logger.error("zip error", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private String getAbsFileName(Integer nodeId, Integer topNodeId) {
        ArrayList<String> paths = new ArrayList<String>();
        NodeImpl topNode = this.getNode0(topNodeId);
        if (!nodeId.equals(topNodeId)) {
            NodeImpl node = this.getNode0(nodeId);
            while (!node.getId().equals(topNodeId)) {
                paths.add(node.getName());
                node = this.getNode0(node.getParentId());
            }
        }
        StringBuilder sb = new StringBuilder(topNode.getName());
        for (int i = paths.size() - 1; i > -1; --i) {
            sb.append("/").append((String)paths.get(i));
        }
        return sb.toString();
    }

    public void unzip(Integer nodeId, String name, boolean cover) {
        NodeImpl topNode;
        com.gtis.fileCenter.model.impl.File file = (com.gtis.fileCenter.model.impl.File)this.getNode0(nodeId);
        if (name != null) {
            try {
                Node sameNameNode = this.getChildNode(file.getParentId(), name);
                if (cover && sameNameNode instanceof com.gtis.fileCenter.model.impl.File) {
                    this.remove(sameNameNode.getId());
                    throw new NodeNotFoundException(sameNameNode.getId());
                }
                topNode = sameNameNode;
            }
            catch (NodeNotFoundException ignored) {
                topNode = new NodeImpl();
                topNode.setParentId(file.getParentId());
                topNode.setName(name);
                this.save((Node)topNode);
            }
        } else {
            topNode = this.getNode0(file.getParentId());
        }
        try {
            File f = this.fileService.getFile(file);
            ZipFile zipFile = new ZipFile(f);
            zipFile.setFileNameCharset("GBK");
            List headerList = zipFile.getFileHeaders();
            for (FileHeader fileHeader : headerList) {
                this.saveZipEntry((Node)topNode, zipFile, fileHeader, cover);
            }
        }
        catch (Exception e) {
            logger.error("unzip error", (Throwable)e);
        }
    }

    private void saveZipEntry(Node topNode, ZipFile zipFile, FileHeader fileHeader, boolean cover) {
        try {
            String path = fileHeader.getFileName();
            int index = path.lastIndexOf("/");
            String fileName = path.substring(index + 1);
            Node parent = index == -1 ? topNode : this.getNode(topNode.getId(), path.substring(0, index), true);
            try {
                Node sameNameNode = this.getChildNode(parent.getId(), fileName);
                if (!cover || !(sameNameNode instanceof com.gtis.fileCenter.model.impl.File)) {
                    return;
                }
                this.remove(sameNameNode.getId());
            }
            catch (NodeNotFoundException ignored) {
                // empty catch block
            }
            com.gtis.fileCenter.model.impl.File file = new com.gtis.fileCenter.model.impl.File();
            file.setParentId(parent.getId());
            file.setName(fileName);
            this.fileService.save(file, (InputStream)zipFile.getInputStream(fileHeader));
            this.save((Node)file);
        }
        catch (Exception e) {
            logger.error("unzip error", (Throwable)e);
        }
    }

    private void saveZipEntry(Node topNode, org.apache.tools.zip.ZipFile zipFile, ZipEntry zipEntry, boolean cover) {
        try {
            String path = zipEntry.getName();
            int index = path.lastIndexOf("/");
            String fileName = path.substring(index + 1);
            Node parent = index == -1 ? topNode : this.getNode(topNode.getId(), path.substring(0, index), true);
            try {
                Node sameNameNode = this.getChildNode(parent.getId(), fileName);
                if (!cover || !(sameNameNode instanceof com.gtis.fileCenter.model.impl.File)) {
                    return;
                }
                this.remove(sameNameNode.getId());
            }
            catch (NodeNotFoundException ignored) {
                // empty catch block
            }
            com.gtis.fileCenter.model.impl.File file = new com.gtis.fileCenter.model.impl.File();
            file.setParentId(parent.getId());
            file.setName(fileName);
            file.setSize(zipEntry.getSize());
            this.fileService.save(file, zipFile.getInputStream(zipEntry));
            this.save((Node)file);
        }
        catch (Exception e) {
            logger.error("unzip error", (Throwable)e);
        }
    }

    public void init() {
        this.nodeDao.initRoot();
    }

    public void clearAll() {
        this.nodeCache.clearAll();
    }

    static /* synthetic */ NodeDao access$000(NodeServiceImpl x0) {
        return x0.nodeDao;
    }

    static /* synthetic */ Cache access$100(NodeServiceImpl x0) {
        return x0.nodeCache;
    }
}

