/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.service.impl;

import com.gtis.fileCenter.CharsetDetector;
import com.gtis.fileCenter.dao.NodeDao;
import com.gtis.fileCenter.ex.FileIOException;
import com.gtis.fileCenter.ex.FileOverSizeException;
import com.gtis.fileCenter.file.CallbackFileChannel;
import com.gtis.fileCenter.file.FileStore;
import com.gtis.fileCenter.file.impl.WriteStreamListener;
import com.gtis.fileCenter.model.MicroFile;
import com.gtis.fileCenter.model.PreviewFile;
import com.gtis.fileCenter.service.FileStoreService;
import com.gtis.generic.util.ImageUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import javax.servlet.ServletOutputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.FileCopyUtils;

public class FileStoreServiceImpl
implements FileStoreService {
    private static final Logger logger = LoggerFactory.getLogger(FileStoreServiceImpl.class);
    private static final int MICRO_IMAGE_WIDTH = 96;
    private static final int MICRO_IMAGE_HEIGHT = 96;
    private static final int TRANSFER_SIZE = 16384;
    @Autowired
    FileStore fileStore;
    @Autowired
    NodeDao nodeDao;
    @Autowired
    private TaskExecutor taskExecutor;
    private String previewServerUrl;
    private boolean useDocServer;
    private String fcUrl;
    private int picturePreviewMaxSize;

    public void setPreviewServerUrl(String previewServerUrl) {
        this.previewServerUrl = previewServerUrl;
        this.useDocServer = previewServerUrl.contains("docserver");
    }

    public void setFcUrl(String fcUrl) {
        this.fcUrl = fcUrl;
    }

    public void setPicturePreviewMaxSize(int picturePreviewMaxSize) {
        this.picturePreviewMaxSize = picturePreviewMaxSize;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public String getPreviewServerUrl() {
        return this.previewServerUrl;
    }

    public boolean exists(com.gtis.fileCenter.model.impl.File file) {
        return file.getStoreUrl() != null && this.fileStore.getFile(file.getStoreUrlObject()).exists();
    }

    public File getFile(com.gtis.fileCenter.model.impl.File file) {
        if (file.getStoreUrl() == null) {
            File f = this.fileStore.createFile(file);
            file.setStoreUrl(this.fileStore.getStoreUrl(f).toString());
            return f;
        }
        return this.fileStore.getFile(file.getStoreUrlObject());
    }

    public FileChannel getFileChannel(com.gtis.fileCenter.model.impl.File file) throws FileIOException {
        return this.getFileChannel(file, 0L);
    }

    public FileChannel getFileChannel(com.gtis.fileCenter.model.impl.File file, long skip) throws FileIOException {
        try {
            FileChannel fc;
            if (skip <= 0L) {
                fc = new FileInputStream(this.getFile(file)).getChannel();
            } else {
                fc = new RandomAccessFile(this.getFile(file), "r").getChannel();
                fc.position(skip);
            }
            return fc;
        }
        catch (Throwable e) {
            throw new FileIOException("Failed to open FileChannel:" + file, e);
        }
    }

    public InputStream getFileInputStream(com.gtis.fileCenter.model.impl.File file) throws FileIOException {
        return new BufferedInputStream(Channels.newInputStream(this.getFileChannel(file)));
    }

    public InputStream getFileInputStream(com.gtis.fileCenter.model.impl.File file, long skip) throws FileIOException {
        return new BufferedInputStream(Channels.newInputStream(this.getFileChannel(file, skip)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(com.gtis.fileCenter.model.impl.File file) {
        StringWriter writer = new StringWriter();
        BufferedReader reader = null;
        try {
            int n;
            File f = this.getFile(file);
            reader = new BufferedReader(new InputStreamReader(this.getFileInputStream(file), CharsetDetector.detect((File)f)));
            char[] buffer = new char[16384];
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            reader.close();
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
        return writer.toString();
    }

    public void transferTo(com.gtis.fileCenter.model.impl.File file, OutputStream os) throws FileIOException {
        this.transferTo(file, 0L, os);
    }

    public void transferTo(com.gtis.fileCenter.model.impl.File file, long skip, OutputStream os) throws FileIOException {
        FileChannel in = null;
        try {
            in = this.getFileChannel(file);
            in.transferTo(skip, in.size() - skip, Channels.newChannel(os));
        }
        catch (IOException e) {
            throw new FileIOException("Failed to open transfer file:" + file, (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ignored) {}
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public void transferZipContainedFileTo(com.gtis.fileCenter.model.impl.File file, String name, ServletOutputStream outputStream) throws FileIOException {
        try {
            ZipFile zfile = new ZipFile(this.getFile(file));
            ZipEntry zf = zfile.getEntry(name);
            if (zf != null) {
                FileCopyUtils.copy((InputStream)zfile.getInputStream(zf), (OutputStream)outputStream);
            }
        }
        catch (IOException e) {
            throw new FileIOException("Failed to transfer file:" + file, (Throwable)e);
        }
    }

    public FileChannel getWritableFileChannel(com.gtis.fileCenter.model.impl.File file) throws FileIOException {
        return this.getWritableFileChannel(file, 0L);
    }

    public FileChannel getWritableFileChannel(com.gtis.fileCenter.model.impl.File file, long skip) throws FileIOException {
        try {
            FileChannel fc;
            if (skip <= 0L) {
                fc = new FileOutputStream(this.getFile(file)).getChannel();
            } else {
                fc = new RandomAccessFile(this.getFile(file), "rw").getChannel();
                fc.position(skip);
            }
            ArrayList<WriteStreamListener> listeners = new ArrayList<WriteStreamListener>();
            listeners.add(new WriteStreamListener((FileStoreService)this, file));
            return new CallbackFileChannel(fc, listeners);
        }
        catch (Throwable e) {
            throw new FileIOException("Failed to open FileChannel:" + file, e);
        }
    }

    public OutputStream getFileOutputStream(com.gtis.fileCenter.model.impl.File file) throws FileIOException {
        return this.getFileOutputStream(file, 0L);
    }

    public OutputStream getFileOutputStream(com.gtis.fileCenter.model.impl.File file, long skip) throws FileIOException {
        return new BufferedOutputStream(Channels.newOutputStream(this.getWritableFileChannel(file, skip)));
    }

    public void save(com.gtis.fileCenter.model.impl.File file, InputStream is) throws FileIOException {
        ReadableByteChannel in = null;
        FileChannel out = null;
        try {
            in = Channels.newChannel(is);
            out = this.getWritableFileChannel(file);
            ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
            while (in.read(buffer) != -1) {
                buffer.flip();
                out.write(buffer);
                buffer.clear();
            }
        }
        catch (Exception e) {
            throw new FileIOException("Failed to save file:" + file, (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ignored) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    public void save(com.gtis.fileCenter.model.impl.File file, FileChannel fc) throws FileIOException {
        FileOutputStream fos = null;
        try {
            long size = fc.size();
            WriteStreamListener listener = new WriteStreamListener((FileStoreService)this, file);
            fos = new FileOutputStream(this.getFile(file));
            fc.transferTo(0L, size, fos.getChannel());
            listener.contentStreamClosed(size);
        }
        catch (IOException e) {
            throw new FileIOException("Failed to save file:" + file, (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ignored) {}
            }
            try {
                fc.close();
            }
            catch (IOException ignored) {}
        }
    }

    public void save(com.gtis.fileCenter.model.impl.File file, File diskFile) throws FileIOException {
        try {
            this.save(file, new FileInputStream(diskFile).getChannel());
        }
        catch (IOException e) {
            throw new FileIOException("Failed to save file:" + file, (Throwable)e);
        }
    }

    public void save(com.gtis.fileCenter.model.impl.File file, byte[] bytes) throws FileIOException {
        this.save(file, (InputStream)new ByteArrayInputStream(bytes));
    }

    public void save(com.gtis.fileCenter.model.impl.File file, String s) throws FileIOException {
        this.save(file, s.getBytes());
    }

    public void save(com.gtis.fileCenter.model.impl.File file, String s, String charset) throws FileIOException {
        try {
            this.save(file, s.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new FileIOException("Failed to save file:" + file, (Throwable)e);
        }
    }

    public void copyTo(com.gtis.fileCenter.model.impl.File srcFile, com.gtis.fileCenter.model.impl.File destFile) throws FileIOException {
        destFile.setStoreUrl(srcFile.getStoreUrl());
    }

    public void delete(com.gtis.fileCenter.model.impl.File file) throws FileIOException {
        if (this.hasLinkFile(file)) {
            return;
        }
        this.taskExecutor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void createMicroImage(MicroFile microFile) {
        this.createMicroImage(microFile, 96);
    }

    public void createMicroImage(MicroFile microFile, int fileSize) {
        if (microFile.getSize() > 0x500000L) {
            return;
        }
        String srcPath = this.getFile(microFile.getFile()).getAbsolutePath();
        if (!new File(srcPath).exists()) {
            return;
        }
        String destPath = this.getFile((com.gtis.fileCenter.model.impl.File)microFile).getAbsolutePath();
        try {
            if (microFile.getSize() > 0x100000L) {
                this.taskExecutor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                ImageUtils.resizeImage((String)srcPath, (String)destPath, (int)fileSize, (int)fileSize);
            }
        }
        catch (Exception ex) {
            logger.error("Unable to transform image:[" + srcPath + "] to [" + destPath + "]", (Throwable)ex);
        }
    }

    public void createPreviewFile(PreviewFile previewFile) throws FileOverSizeException {
        File srcFile = this.getFile(previewFile.getFile());
        if (!srcFile.exists() || srcFile.length() == 0L) {
            return;
        }
        if (previewFile.getSize() > (long)this.picturePreviewMaxSize) {
            throw new FileOverSizeException(previewFile.getFile().getName());
        }
        StringBuilder sb = new StringBuilder(this.previewServerUrl);
        try {
            if (this.useDocServer) {
                String ext = previewFile.getFile().getExtension();
                if ("pdf".equals(ext) || "ceb".equals(ext)) {
                    return;
                }
                String src = srcFile.getAbsolutePath();
                String target = this.getFile((com.gtis.fileCenter.model.impl.File)previewFile).getAbsolutePath();
                sb.append("/convert?rsync=true&src=").append(URLEncoder.encode(src, "utf-8")).append("&target=").append(URLEncoder.encode(target, "utf-8"));
            } else {
                String url = this.fcUrl + "/file/preview.do?fid=" + previewFile.getId();
                url = URLEncoder.encode(url, "utf-8");
                sb.append("?fid=").append(previewFile.getId()).append("&url=").append(url).append("&filetype=").append(previewFile.getFile().getExtension());
            }
        }
        catch (UnsupportedEncodingException ignored) {
            // empty catch block
        }
        this.taskExecutor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean hasLinkFile(com.gtis.fileCenter.model.impl.File file) {
        return this.nodeDao.hasLinkFile(file.getStoreUrl());
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

