/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.service.impl;

import com.gtis.fileCenter.NodeHelper;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.fileCenter.service.impl.FileIndexOwnerDetector;
import com.gtis.search.EntityIndexProvider;
import com.gtis.search.Index;
import com.gtis.search.MimeTypeHelper;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FileIndexProviderImpl
extends EntityIndexProvider<File> {
    private NodeService nodeService;
    private List<FileIndexOwnerDetector> detectors;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDetectors(List<FileIndexOwnerDetector> detectors) {
        this.detectors = detectors;
    }

    protected File getEntity(String categoryId, String id) {
        return (File)this.nodeService.getNode(Integer.valueOf(id));
    }

    protected List<File> getEntities(String categoryId, int start, int size) {
        Space space = this.nodeService.getWorkSpace(categoryId);
        return this.nodeService.getAllChildFile(space.getId(), start, size);
    }

    protected Index createIndex(File file) {
        Index index = super.createIndex((Object)file);
        index.setId(NodeHelper.toIndexId((Integer)file.getId()));
        index.setBusinessId(this.defaultBusiness.getId());
        index.setCategoryId(this.nodeService.getSpace(file.getId()).getName());
        return index;
    }

    protected void extractEntity(File file, Index index) {
        FileIndexOwnerDetector detector;
        index.setDate(file.getUpdateTime());
        index.setTitle(StringUtils.isBlank((String)file.getViewName()) ? file.getName() : file.getViewName() + "." + MimeTypeHelper.getExt((String)file.getName()));
        index.setMimeType(MimeTypeHelper.getMimeType((String)file.getName()));
        index.appendBody(file.getDescription());
        index.appendBody(file.getViewName());
        index.addField("size", (Serializable)Long.valueOf(file.getSize()));
        index.addField("fid", (Serializable)file.getId());
        Map attrs = file.getAttributes();
        if (attrs != null) {
            for (Map.Entry entry : attrs.entrySet()) {
                index.addSearchableField((String)entry.getKey(), (Serializable)entry.getValue());
            }
        }
        FileIndexOwnerDetector.Owner owner = null;
        Iterator i$ = this.detectors.iterator();
        while (i$.hasNext() && (owner = (detector = (FileIndexOwnerDetector)i$.next()).detect(file)) == null) {
        }
        if (owner != null) {
            index.addSearchableField("ownerId", (Serializable)((Object)owner.getOwnerId()));
            index.setBusinessId(owner.getBusinessId());
            index.setCategoryId(owner.getCategoryId());
        }
    }

    public int getTotalCount(String categoryId) {
        Space space = this.nodeService.getWorkSpace(categoryId);
        return this.nodeService.getAllChildFilesCount(space.getId());
    }
}

