/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.service.impl;

import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.fileCenter.service.impl.FileIndexOwnerDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class FileIndexOwnerDetector
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(FileIndexOwnerDetector.class);
    private NodeService nodeService;
    private String spaceName;
    private String spacePath;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public Owner detect(File file) {
        String path;
        int i;
        if (this.spacePath != null && (i = (path = file.getPath()).indexOf(this.spacePath)) > -1) {
            int end = path.indexOf("/", i += this.spacePath.length() + 1);
            String idStr = end == -1 ? path.substring(i) : path.substring(i, end);
            return this.getOwner(this.nodeService.getNode(Integer.valueOf(idStr)).getName());
        }
        return null;
    }

    protected abstract Owner getOwner(String var1);

    public void afterPropertiesSet() throws Exception {
        Space space = null;
        try {
            space = this.nodeService.getWorkSpace(this.spaceName);
        }
        catch (NodeNotFoundException e) {
            LOG.error("Index detector form space [" + space + "] init error," + e.getMessage());
        }
        if (space != null) {
            this.spacePath = space.getPath() + space.getId();
        }
    }
}

