/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.service.impl;

import com.gtis.fileCenter.NodeHelper;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.search.Category;
import com.gtis.search.EntityIndexProvider;
import com.gtis.search.Index;
import com.gtis.search.IndexManager;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIndexAspect {
    private static final Logger LOG = LoggerFactory.getLogger(FileIndexAspect.class);
    private NodeService nodeService;
    private IndexManager indexManager;
    private EntityIndexProvider<File> indexProvider;
    private Set<String> spaceNames = new HashSet();

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public void setIndexProvider(EntityIndexProvider<File> indexProvider) {
        this.indexProvider = indexProvider;
        for (Category cat : indexProvider.getDefaultBusiness().getCategories()) {
            this.spaceNames.add(cat.getId());
        }
    }

    public void save(Node node) throws Throwable {
        try {
            if (node instanceof File && this.spaceNames.contains(this.nodeService.getSpace(node.getId()).getName())) {
                this.indexManager.update(new Index[]{this.indexProvider.toIndex((Object)((File)node))});
            }
        }
        catch (Throwable e) {
            LOG.error("Error to save index", e);
        }
    }

    public Object remove(ProceedingJoinPoint joinPoint) throws Throwable {
        Space space;
        Node node = this.nodeService.getNode((Integer)joinPoint.getArgs()[0]);
        boolean needRemoveIndex = false;
        if (node instanceof File && this.spaceNames.contains((space = this.nodeService.getSpace(node.getId())).getName())) {
            needRemoveIndex = true;
        }
        Object retVal = joinPoint.proceed();
        if (needRemoveIndex) {
            this.indexManager.remove(new String[]{NodeHelper.toIndexId((Integer)node.getId())});
        }
        return retVal;
    }
}

