/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.model;

import com.gtis.fileCenter.ex.NestedRuntimeException;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.model.impl.StoreUrl;
import org.springframework.beans.BeanUtils;

public class MicroFile
extends File {
    private static final long serialVersionUID = -4205431081095784883L;
    public static final String MICRO_EXTENSION = ".jpg";
    public static final long MAX_SIZE = 0x500000L;
    public static final long TASK_SIZE = 0x100000L;
    private StoreUrl su;
    private File file;

    public MicroFile(File file) {
        this.file = file;
        if (!file.isImage()) {
            throw new NestedRuntimeException("not a image file");
        }
        BeanUtils.copyProperties((Object)file, (Object)this);
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return super.getName() + MICRO_EXTENSION;
    }

    public String getStoreUrl() {
        return super.getStoreUrl() + MICRO_EXTENSION;
    }

    public StoreUrl getStoreUrlObject() {
        if (this.su == null) {
            this.su = new StoreUrl(this.getStoreUrl());
        }
        return this.su;
    }
}

