/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.fs.webdav;

import com.gtis.fileCenter.ex.NodeExistsException;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.fs.webdav.NodeDirContext;
import com.gtis.fileCenter.fs.webdav.WebdavSessionContext;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.model.impl.PersonalSpace;
import com.gtis.fileCenter.service.FileStoreService;
import com.gtis.fileCenter.service.NodeService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;

public class NodeDirContext
extends BaseDirContext {
    protected Node base;
    private NodeService nodeService;
    private FileStoreService fileService;

    public NodeDirContext(NodeService nodeService, FileStoreService fileService) {
        this.nodeService = nodeService;
        this.fileService = fileService;
    }

    public void setDocBase(String docBase) {
        if (docBase == null) {
            throw new IllegalArgumentException(this.sm.getString("resources.null"));
        }
        this.base = this.nodeService.getNode(Integer.valueOf(docBase));
        if (this.base == null) {
            throw new IllegalArgumentException(this.sm.getString("fileResources.base", (Object)docBase));
        }
        super.setDocBase(docBase);
    }

    public Object lookup(String name) throws NamingException {
        Resource result;
        Node node = this.getNode(name);
        if (node == null) {
            throw new NamingException(this.sm.getString("resources.notFound", (Object)name));
        }
        if (node instanceof File) {
            try {
                result = new Resource(this.fileService.getFileInputStream((File)node));
            }
            catch (Exception e) {
                result = new Resource(new byte[0]);
            }
        } else {
            NodeDirContext tempContext = new NodeDirContext(this.nodeService, this.fileService);
            tempContext.setDocBase(node.getId().toString());
            result = tempContext;
        }
        return result;
    }

    public void unbind(String name) throws NamingException {
        Node node = this.getNode(name);
        if (node == null) {
            throw new NamingException(this.sm.getString("resources.notFound", (Object)name));
        }
        this.nodeService.remove(node.getId());
    }

    public void rename(String oldName, String newName) throws NamingException {
        Node node = this.getNode(oldName);
        if (node == null) {
            throw new NamingException(this.sm.getString("resources.notFound", (Object)oldName));
        }
        node.setName(newName);
        this.nodeService.save(node);
    }

    public NamingEnumeration list(String name) throws NamingException {
        Node node = this.getNode(name);
        if (node == null) {
            throw new NamingException(this.sm.getString("resources.notFound", (Object)name));
        }
        return new NamingContextEnumeration(this.list(node).iterator());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        Node node = this.getNode(name);
        if (node == null) {
            throw new NamingException(this.sm.getString("resources.notFound", (Object)name));
        }
        return new NamingContextBindingsEnumeration(this.list(node).iterator(), (Context)this);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.unbind(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public String getNameInNamespace() throws NamingException {
        return this.docBase;
    }

    public Attributes getAttributes(String name, String[] strings) throws NamingException {
        Node node = this.getNode(name);
        if (node == null) {
            throw new NamingException(this.sm.getString("resources.notFound", (Object)name));
        }
        return new NodeResourceAttributes(this, node);
    }

    public void modifyAttributes(String name, int i, Attributes attributes) throws NamingException {
    }

    public void modifyAttributes(String name, ModificationItem[] modificationItems) throws NamingException {
    }

    public void bind(String name, Object obj, Attributes attributes) throws NamingException {
        Node node = this.getNode(name);
        if (node != null) {
            throw new NameAlreadyBoundException(this.sm.getString("resources.alreadyBound", (Object)name));
        }
        this.rebind(name, obj, attributes);
    }

    public void rebind(String name, Object obj, Attributes attributes) throws NamingException {
        InputStream is = null;
        if (obj instanceof Resource) {
            try {
                is = ((Resource)obj).streamContent();
            }
            catch (IOException ignored) {}
        } else if (obj instanceof InputStream) {
            is = (InputStream)obj;
        }
        if (is == null) {
            throw new NamingException(this.sm.getString("resources.bindFailed", (Object)name));
        }
        int i = name.lastIndexOf(47, name.length() - 2) + 1;
        Node node = this.getNode(name.substring(0, i));
        if (node == null) {
            throw new NamingException(this.sm.getString("resources.bindFailed", (Object)name));
        }
        File file = new File();
        file.setParentId(node.getId());
        file.setName(name.substring(i));
        try {
            this.fileService.delete((File)this.nodeService.getChildNode(node.getId(), name.substring(i)));
        }
        catch (NodeNotFoundException ignored) {
            // empty catch block
        }
        try {
            this.fileService.save(file, is);
            this.nodeService.save((Node)file);
        }
        catch (NodeExistsException e) {
            throw new NameAlreadyBoundException(this.sm.getString("resources.alreadyBound", (Object)name));
        }
        catch (Exception e) {
            NamingException ne = new NamingException(this.sm.getString("resources.bindFailed", (Object)e));
            ne.initCause(e);
            throw ne;
        }
    }

    public DirContext createSubcontext(String name, Attributes attributes) throws NamingException {
        try {
            int i = name.lastIndexOf(47, name.length() - 2) + 1;
            Node node = this.getNode(name.substring(0, i));
            if (node == null) {
                throw new NamingException(this.sm.getString("resources.bindFailed", (Object)name));
            }
            this.nodeService.createNode(node.getId(), name.substring(i));
        }
        catch (NodeExistsException e) {
            throw new NameAlreadyBoundException(this.sm.getString("resources.alreadyBound", (Object)name));
        }
        return (DirContext)this.lookup(name);
    }

    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, Attributes attributes, String[] strings) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String name, Attributes attributes) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String name, String name1, SearchControls searchControls) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String name, String name1, Object[] objects, SearchControls searchControls) throws NamingException {
        return null;
    }

    protected Node getNode(String name) {
        block10: {
            int i = name.indexOf(47, 1);
            if (i == -1) {
                return null;
            }
            int j = name.indexOf(47, i + 1);
            if (j == -1) {
                j = name.length();
            }
            String token = name.substring(1, i);
            String nid = name.substring(i + 1, j);
            String path = name.substring(j);
            if (StringUtils.isBlank((String)token) || StringUtils.isBlank((String)nid)) {
                return null;
            }
            try {
                HttpSession session = WebdavSessionContext.getInstance().getSession(token);
                if (session == null) {
                    Node node = null;
                    try {
                        node = this.nodeService.getNode(Integer.valueOf(Integer.parseInt(nid)), path);
                    }
                    catch (NumberFormatException ignored) {
                        // empty catch block
                    }
                    if (node == null) {
                        return null;
                    }
                    if (this.nodeService.hasPermission(token, node.getId())) {
                        return node;
                    }
                    break block10;
                }
                PersonalSpace space = (PersonalSpace)session.getAttribute("com.gtis.fileCenter.personalSpace");
                return this.nodeService.getNode(space.getId(), path);
            }
            catch (NodeNotFoundException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    protected ArrayList<NamingEntry> list(Node node) {
        ArrayList<NamingEntry> entries = new ArrayList<NamingEntry>();
        if (node instanceof File) {
            return entries;
        }
        for (Node n : this.nodeService.getChildNodes(node.getId())) {
            Resource obj;
            if (n instanceof File) {
                try {
                    obj = new Resource(this.fileService.getFileInputStream((File)n));
                }
                catch (Exception e) {
                    obj = new Resource(new byte[0]);
                }
            } else {
                NodeDirContext tempContext = new NodeDirContext(this.nodeService, this.fileService);
                tempContext.setDocBase(n.getId().toString());
                obj = tempContext;
            }
            NamingEntry entry = new NamingEntry(n.getName(), (Object)obj, 0);
            entries.add(entry);
        }
        return entries;
    }
}

