/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.fs.webdav;

import com.gtis.fileCenter.fs.webdav.DefaultServlet;
import com.gtis.fileCenter.fs.webdav.NodeDirContext;
import com.gtis.fileCenter.fs.webdav.WebdavServlet;
import com.gtis.fileCenter.service.FileStoreService;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.generic.util.SpringContextUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.catalina.util.RequestUtil;
import org.apache.naming.resources.CacheEntry;
import org.apache.naming.resources.ProxyDirContext;

public class FileWebdavServlet
extends WebdavServlet {
    protected static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String TOMCAT_CSS = "*{font: 14px Arial, Helvetica, sans-serif;}\na { color: #336; outline: none; text-decoration: none; }\nh1{font-size:16px;}\nh2{font-size:14px;}\nh3{font-size:12px;}\na:hover { color: #f00; text-decoration: underline; }\n";

    public void init() throws ServletException {
        ServletContext sc = this.getServletContext();
        Object originalResources = sc.getAttribute("org.apache.catalina.resources");
        NodeService nodeService = (NodeService)SpringContextUtils.getBean((String)"nodeService");
        FileStoreService fileService = (FileStoreService)SpringContextUtils.getBean((String)"fileService");
        if (nodeService == null) {
            throw new RuntimeException("error to initialize FileWebdavServlet,nodeService not found.");
        }
        ProxyDirContext dirContext = new ProxyDirContext(new Hashtable(), (DirContext)new NodeDirContext(nodeService, fileService));
        this.getServletContext().setAttribute("org.apache.catalina.resources", (Object)dirContext);
        super.init();
        sc.setAttribute("org.apache.catalina.resources", originalResources);
    }

    protected void serveResource(HttpServletRequest request, HttpServletResponse response, boolean content) throws IOException, ServletException {
        String contentType;
        String path = this.getRelativePath(request);
        if (this.debug > 0) {
            if (content) {
                this.log("DefaultServlet.serveResource:  Serving resource '" + path + "' headers and data");
            } else {
                this.log("DefaultServlet.serveResource:  Serving resource '" + path + "' headers only");
            }
        }
        CacheEntry cacheEntry = this.resources.lookupCache(path);
        if (!cacheEntry.exists) {
            String requestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
            if (requestUri == null) {
                requestUri = request.getRequestURI();
            } else {
                response.getWriter().write(sm.getString("defaultServlet.missingResource", (Object)requestUri));
            }
            response.sendError(404, requestUri);
            return;
        }
        if (cacheEntry.context == null && (path.endsWith("/") || path.endsWith("\\"))) {
            String requestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
            if (requestUri == null) {
                requestUri = request.getRequestURI();
            }
            response.sendError(404, requestUri);
            return;
        }
        if (cacheEntry.context == null) {
            boolean included;
            boolean bl = included = request.getAttribute("javax.servlet.include.context_path") != null;
            if (!included && !this.checkIfHeaders(request, response, cacheEntry.attributes)) {
                return;
            }
        }
        if ((contentType = cacheEntry.attributes.getMimeType()) == null) {
            contentType = this.getServletContext().getMimeType(cacheEntry.name);
            cacheEntry.attributes.setMimeType(contentType);
        }
        ArrayList ranges = null;
        long contentLength = -1L;
        if (cacheEntry.context != null) {
            if (!this.listings) {
                response.sendError(404, request.getRequestURI());
                return;
            }
            contentType = "text/html;charset=UTF-8";
        } else {
            if (this.useAcceptRanges) {
                response.setHeader("Accept-Ranges", "bytes");
            }
            ranges = this.parseRange(request, response, cacheEntry.attributes);
            response.setHeader("ETag", cacheEntry.attributes.getETag());
            response.setHeader("Last-Modified", cacheEntry.attributes.getLastModifiedHttp());
            contentLength = cacheEntry.attributes.getContentLength();
            if (contentLength == 0L) {
                content = false;
            }
        }
        ServletOutputStream ostream = null;
        PrintWriter writer = null;
        if (content) {
            try {
                ostream = response.getOutputStream();
            }
            catch (IllegalStateException e) {
                if (contentType == null || contentType.startsWith("text") || contentType.endsWith("xml")) {
                    writer = response.getWriter();
                }
                throw e;
            }
        }
        if (cacheEntry.context != null || (ranges == null || ranges.isEmpty()) && request.getHeader("Range") == null || ranges == FULL) {
            if (contentType != null) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentType='" + contentType + "'");
                }
                response.setContentType(contentType);
            }
            if (cacheEntry.resource != null && contentLength >= 0L) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentLength=" + contentLength);
                }
                if (contentLength < Integer.MAX_VALUE) {
                    response.setContentLength((int)contentLength);
                } else {
                    response.setHeader("content-length", "" + contentLength);
                }
            }
            InputStream renderResult = null;
            if (cacheEntry.context != null && content) {
                renderResult = this.render(request.getContextPath() + request.getServletPath(), cacheEntry);
            }
            if (content) {
                try {
                    response.setBufferSize(this.output);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
                if (ostream != null) {
                    if (!this.checkSendfile(request, response, cacheEntry, contentLength, null)) {
                        this.copy(cacheEntry, renderResult, ostream);
                    }
                } else {
                    this.copy(cacheEntry, renderResult, writer);
                }
            }
        } else {
            if (ranges == null || ranges.isEmpty()) {
                return;
            }
            response.setStatus(206);
            if (ranges.size() == 1) {
                DefaultServlet.Range range = (DefaultServlet.Range)ranges.get(0);
                response.addHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.length);
                long length = range.end - range.start + 1L;
                if (length < Integer.MAX_VALUE) {
                    response.setContentLength((int)length);
                } else {
                    response.setHeader("content-length", "" + length);
                }
                if (contentType != null) {
                    if (this.debug > 0) {
                        this.log("DefaultServlet.serveFile:  contentType='" + contentType + "'");
                    }
                    response.setContentType(contentType);
                }
                if (content) {
                    try {
                        response.setBufferSize(this.output);
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                    if (ostream != null) {
                        if (!this.checkSendfile(request, response, cacheEntry, range.end - range.start + 1L, range)) {
                            this.copy(cacheEntry, ostream, range);
                        }
                    } else {
                        this.copy(cacheEntry, writer, range);
                    }
                }
            } else {
                response.setContentType("multipart/byteranges; boundary=CATALINA_MIME_BOUNDARY");
                if (content) {
                    try {
                        response.setBufferSize(this.output);
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                    if (ostream != null) {
                        this.copy(cacheEntry, ostream, ranges.iterator(), contentType);
                    } else {
                        this.copy(cacheEntry, writer, ranges.iterator(), contentType);
                    }
                }
            }
        }
    }

    protected InputStream renderXml(String contextPath, CacheEntry cacheEntry, InputStream xsltInputStream) throws IOException, ServletException {
        String name = cacheEntry.name;
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"?>");
        sb.append("<listing ");
        sb.append(" contextPath='");
        sb.append(contextPath);
        sb.append("'");
        sb.append(" directory='");
        sb.append(cacheEntry.name);
        sb.append("' ");
        sb.append(" hasParent='").append(!cacheEntry.name.equals("/"));
        sb.append("'>");
        sb.append("<entries>");
        try {
            NamingEnumeration enumeration = this.resources.list(cacheEntry.name);
            String rewrittenContextPath = this.rewriteUrl(contextPath);
            while (enumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
                String resourceName = ncPair.getName();
                if (resourceName.equalsIgnoreCase("WEB-INF") || resourceName.equalsIgnoreCase("META-INF") || resourceName.equalsIgnoreCase(this.localXsltFile)) continue;
                String childName = name + (name.endsWith("/") ? "" : "/") + resourceName;
                CacheEntry childCacheEntry = this.resources.lookupCache(childName);
                if (!childCacheEntry.exists) continue;
                sb.append("<entry");
                sb.append(" type='").append(childCacheEntry.context != null ? "dir" : "file").append("'");
                sb.append(" urlPath='").append(rewrittenContextPath).append(this.rewriteUrl(childName)).append(childCacheEntry.context != null ? "/" : "").append("'");
                if (childCacheEntry.resource != null) {
                    sb.append(" size='").append(this.renderSize(childCacheEntry.attributes.getContentLength())).append("'");
                }
                sb.append(" date='").append(childCacheEntry.attributes.getLastModifiedHttp()).append("'");
                sb.append(">");
                sb.append(RequestUtil.filter((String)resourceName));
                if (childCacheEntry.context != null) {
                    sb.append("/");
                }
                sb.append("</entry>");
            }
        }
        catch (NamingException e) {
            throw new ServletException("Error accessing resource", (Throwable)e);
        }
        sb.append("</entries>");
        String readme = this.getReadme(cacheEntry.context);
        if (readme != null) {
            sb.append("<readme><![CDATA[");
            sb.append(readme);
            sb.append("]]></readme>");
        }
        sb.append("</listing>");
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource xmlSource = new StreamSource(new StringReader(sb.toString()));
            StreamSource xslSource = new StreamSource(xsltInputStream);
            Transformer transformer = tFactory.newTransformer(xslSource);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)stream, "UTF8");
            StreamResult out = new StreamResult(osWriter);
            transformer.transform(xmlSource, out);
            osWriter.flush();
            return new ByteArrayInputStream(stream.toByteArray());
        }
        catch (TransformerException e) {
            throw new ServletException("XSL transformer error", (Throwable)e);
        }
    }

    protected InputStream renderHtml(String contextPath, CacheEntry cacheEntry) throws IOException, ServletException {
        int slash;
        String name = cacheEntry.name;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)stream, "UTF8");
        PrintWriter writer = new PrintWriter(osWriter);
        StringBuffer sb = new StringBuffer();
        String rewrittenContextPath = this.rewriteUrl(contextPath);
        sb.append("<html>\r\n");
        sb.append("<head>\r\n");
        sb.append("<title>");
        sb.append(sm.getString("directory.title", (Object)name));
        sb.append("</title>\r\n");
        sb.append("<STYLE><!--");
        sb.append(TOMCAT_CSS);
        sb.append("--></STYLE> ");
        sb.append("</head>\r\n");
        sb.append("<body>");
        sb.append("<h1>");
        sb.append(name);
        sb.append("</h1>");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" align=\"center\">\r\n");
        sb.append("<tr>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append("\u6587\u4ef6\u540d");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"center\"><font size=\"+1\"><strong>");
        sb.append("\u6587\u4ef6\u5927\u5c0f");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"right\"><font size=\"+1\"><strong>");
        sb.append("\u4fee\u6539\u65f6\u95f4");
        sb.append("</strong></font></td>\r\n");
        sb.append("</tr>");
        sb.append("<tr bgcolor=\"#f2f2f2\"><td colspan=\"3\" align=\"left\">&nbsp;\r\n");
        String parentDirectory = name;
        if (parentDirectory.endsWith("/")) {
            parentDirectory = parentDirectory.substring(0, parentDirectory.length() - 1);
        }
        if ((slash = parentDirectory.lastIndexOf(47)) >= 0) {
            String parent = name.substring(0, slash);
            sb.append("<a href=\"");
            sb.append(rewrittenContextPath);
            if (parent.equals("")) {
                parent = "/";
            }
            sb.append(this.rewriteUrl(parent));
            if (!parent.endsWith("/")) {
                sb.append("/");
            }
            sb.append("\">");
            sb.append("../");
            sb.append("</a>");
        }
        sb.append("</td></tr>");
        try {
            NamingEnumeration enumeration = this.resources.list(cacheEntry.name);
            boolean shade = false;
            while (enumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
                String resourceName = ncPair.getName();
                String trimmed = resourceName;
                if (trimmed.equalsIgnoreCase("WEB-INF") || trimmed.equalsIgnoreCase("META-INF")) continue;
                String childName = name + (name.endsWith("/") ? "" : "/") + resourceName;
                CacheEntry childCacheEntry = this.resources.lookupCache(childName);
                if (!childCacheEntry.exists) continue;
                sb.append("<tr");
                if (shade) {
                    sb.append(" bgcolor=\"#f2f2f2\"");
                }
                sb.append(">\r\n");
                shade = !shade;
                sb.append("<td align=\"left\">&nbsp;\r\n");
                sb.append("<a href=\"");
                sb.append(rewrittenContextPath);
                resourceName = this.rewriteUrl(childName);
                sb.append(resourceName);
                if (childCacheEntry.context != null) {
                    sb.append("/");
                }
                sb.append("\"><tt>");
                sb.append(RequestUtil.filter((String)trimmed));
                if (childCacheEntry.context != null) {
                    sb.append("/");
                }
                sb.append("</tt></a></td>\r\n");
                sb.append("<td align=\"right\"><tt>");
                if (childCacheEntry.context != null) {
                    sb.append("&nbsp;");
                } else {
                    sb.append(this.renderSize(childCacheEntry.attributes.getContentLength()));
                }
                sb.append("</tt></td>\r\n");
                sb.append("<td align=\"right\"><tt>");
                sb.append(format.format(childCacheEntry.attributes.getLastModifiedDate()));
                sb.append("</tt></td>\r\n");
                sb.append("</tr>\r\n");
            }
        }
        catch (NamingException e) {
            throw new ServletException("Error accessing resource", (Throwable)e);
        }
        sb.append("</table>\r\n");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        String readme = this.getReadme(cacheEntry.context);
        if (readme != null) {
            sb.append(readme);
            sb.append("<HR size=\"1\" noshade=\"noshade\">");
        }
        sb.append("<h3>").append("\u5728IE\u4e0b\uff0c\u70b9\u51fb\u6587\u4ef6->\u6253\u5f00,\u9009\u4e2d\u4ee5web\u6587\u4ef6\u5939\u65b9\u5f0f\u6253\u5f00\uff0c\u6253\u5f00\u5f53\u524d\u5730\u5740\uff0c\u5373\u53ef\u7528webdav\u6765\u7ba1\u7406\u6587\u4ef6\uff0c\u652f\u6301\u590d\u5236\u7c98\u8d34\u5728\u7ebf\u7f16\u8f91offce\u6587\u6863").append("</h3>");
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        writer.write(sb.toString());
        writer.flush();
        return new ByteArrayInputStream(stream.toByteArray());
    }
}

