/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.fs.jlan;

import com.gtis.fileCenter.fs.jlan.FileCenterDiskDriver;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.jlan.app.JLANServer;
import org.alfresco.jlan.app.XMLServerConfiguration;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.io.Resource;

public class JLanServer
extends JLANServer
implements ApplicationListener,
InitializingBean,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(JLanServer.class);
    private ApplicationContext applicationContext;
    private Resource configLocation;
    private List<NetworkServer> servers;
    private boolean cifsEnable;
    private boolean ftpEnable;

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setCifsEnable(boolean cifsEnable) {
        this.cifsEnable = cifsEnable;
    }

    public void setFtpEnable(boolean ftpEnable) {
        this.ftpEnable = ftpEnable;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextClosedEvent && (this.cifsEnable || this.ftpEnable)) {
            this.stop();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.cifsEnable || this.ftpEnable) {
            this.applicationContext.getBean("nodeService");
            this.init();
            this.start();
        }
    }

    protected synchronized void init() {
        XMLServerConfiguration srvConfig = new XMLServerConfiguration();
        try {
            srvConfig.loadConfiguration(this.configLocation.getFile().getAbsolutePath());
            this.servers = new ArrayList();
            if (this.cifsEnable) {
                this.servers.add(this.createSMBServer((ServerConfiguration)srvConfig));
            }
            if (this.ftpEnable) {
                this.servers.add(this.createFTPServer((ServerConfiguration)srvConfig));
            }
        }
        catch (Exception e) {
            logger.error("error to load JlanServer config file:[{}]", (Object)this.configLocation.getDescription(), (Object)e);
        }
    }

    protected synchronized void start() {
        for (NetworkServer server : this.servers) {
            try {
                server.startServer();
            }
            catch (Exception e) {
                logger.error("start server error", (Object)server.getConfiguration().getServerName(), (Object)e);
            }
        }
    }

    protected synchronized void stop() {
        for (NetworkServer server : this.servers) {
            try {
                server.shutdownServer(true);
            }
            catch (Exception e) {
                logger.error("stop server error", (Object)server.getConfiguration().getServerName(), (Object)e);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        FileCenterDiskDriver.setApplicationContext((ApplicationContext)this.applicationContext);
    }
}

