/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.fs.jlan;

import com.gtis.fileCenter.ex.NodeExistsException;
import com.gtis.fileCenter.fs.jlan.FileCenterDiskDriver;
import com.gtis.fileCenter.fs.webdav.WebdavSessionContext;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.impl.NodeImpl;
import com.gtis.fileCenter.model.impl.PersonalSpace;
import com.gtis.fileCenter.service.FileStoreService;
import com.gtis.fileCenter.service.NodeService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.FileExistsException;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.PathNotFoundException;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.locking.FileLockingInterface;
import org.alfresco.jlan.server.locking.LockManager;
import org.alfresco.jlan.smb.server.disk.NIOJavaNetworkFile;
import org.alfresco.jlan.smb.server.disk.NIOLockManager;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.util.FileCopyUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileCenterDiskDriver
implements DiskInterface,
FileLockingInterface {
    private static final char DOS_SEPERATOR = '\\';
    private static LockManager _lockManager = new NIOLockManager();
    private static ApplicationContext applicationContext;
    protected static Date GLOBAL_UPDATEDATE;
    private NodeService nodeService = (NodeService)applicationContext.getBean("nodeService");
    private FileStoreService fileService = (FileStoreService)applicationContext.getBean("fileService");

    public static void setApplicationContext(ApplicationContext context) {
        applicationContext = context;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileService(FileStoreService fileService) {
        this.fileService = fileService;
    }

    public void closeFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        Node node = this.getNode(file.getFullName());
        file.closeFile();
        if (file.getWriteCount() > 0) {
            if (node instanceof com.gtis.fileCenter.model.impl.File) {
                ((com.gtis.fileCenter.model.impl.File)node).setSize(file.getFileSize());
            }
            this.nodeService.save(node);
        }
        if (file.hasDeleteOnClose()) {
            if (file.isDirectory()) {
                this.deleteDirectory(sess, tree, file.getFullName());
            } else {
                this.deleteFile(sess, tree, file.getFullName());
            }
        }
    }

    public void createDirectory(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        String name = params.getPath();
        int i = name.lastIndexOf(92, name.length() - 2) + 1;
        try {
            Node node = this.getNode(name.substring(0, i));
            if (!node.isWriteable()) {
                throw new AccessDeniedException("no write ermission");
            }
            this.nodeService.createNode(node.getId(), name.substring(i));
        }
        catch (NodeExistsException e) {
            throw new FileExistsException("create directory, path exists " + name.substring(i));
        }
    }

    public NetworkFile createFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        String name = params.getPath();
        int i = name.lastIndexOf(92, name.length() - 2) + 1;
        try {
            Node node = this.getNode(name.substring(0, i));
            if (!node.isWriteable()) {
                throw new AccessDeniedException("no write ermission");
            }
            com.gtis.fileCenter.model.impl.File file = new com.gtis.fileCenter.model.impl.File();
            file.setName(name.substring(i));
            file.setParentId(node.getId());
            File f = this.fileService.getFile(file);
            FileWriter newFile = new FileWriter(f, false);
            newFile.close();
            this.nodeService.save((Node)file);
            NIOJavaNetworkFile netFile = new NIOJavaNetworkFile(f, name);
            netFile.setGrantedAccess(2);
            netFile.setFullName(name);
            return netFile;
        }
        catch (NodeExistsException e) {
            throw new FileExistsException("create file, name exists " + name.substring(i));
        }
    }

    public void deleteDirectory(SrvSession sess, TreeConnection tree, String dir) throws IOException {
        this.deleteFile(sess, tree, dir);
    }

    public void deleteFile(SrvSession sess, TreeConnection tree, String name) throws IOException {
        Node node = this.getNode(name);
        if (!node.isWriteable()) {
            throw new AccessDeniedException("no write ermission");
        }
        this.nodeService.remove(node.getId());
    }

    public int fileExists(SrvSession sess, TreeConnection tree, String name) {
        try {
            return this.getNode(name) instanceof com.gtis.fileCenter.model.impl.File ? 1 : 2;
        }
        catch (IOException e) {
            return 0;
        }
    }

    public void flushFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        file.flushFile();
    }

    public FileInfo getFileInformation(SrvSession sess, TreeConnection tree, String name) throws IOException {
        FileInfo info = new FileInfo();
        try {
            return FileCenterDiskDriver.nodeToFileInfo((Node)this.getNode(name), (FileInfo)info);
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isReadOnly(SrvSession sess, DeviceContext ctx) throws IOException {
        return false;
    }

    public NetworkFile openFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        Node node = this.getNode(params.getPath());
        if (!node.isWriteable() && (params.isReadWriteAccess() || params.isWriteOnlyAccess())) {
            throw new AccessDeniedException("File " + node.getName() + " is read-only");
        }
        if (node instanceof com.gtis.fileCenter.model.impl.File) {
            com.gtis.fileCenter.model.impl.File file = (com.gtis.fileCenter.model.impl.File)node;
            File srcFile = this.fileService.getFile(file);
            if (this.fileService.hasLinkFile(file)) {
                file.setStoreUrl(null);
                File copyedFile = this.fileService.getFile(file);
                FileCopyUtils.copy((File)srcFile, (File)copyedFile);
                return new NIOJavaNetworkFile(copyedFile, params.getPath());
            }
            return new NIOJavaNetworkFile(srcFile, params.getPath());
        }
        NIOJavaNetworkFile netFile = new NIOJavaNetworkFile(new File("."), params.getPath());
        netFile.setAttributes(16);
        netFile.setGrantedAccess(params.isReadOnlyAccess() ? 0 : 2);
        netFile.setFullName(params.getPath());
        return netFile;
    }

    public int readFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufPos, int siz, long filePos) throws IOException {
        if (file.isDirectory()) {
            throw new AccessDeniedException();
        }
        int rdlen = file.readFile(buf, siz, bufPos, filePos);
        if (rdlen == -1) {
            rdlen = 0;
        }
        return rdlen;
    }

    public void renameFile(SrvSession sess, TreeConnection tree, String oldName, String newName) throws IOException {
        Node src = this.getNode(oldName);
        int i = newName.lastIndexOf(92, newName.length() - 2) + 1;
        String fName = newName.substring(i);
        String path = newName.substring(0, i);
        Node target = this.getNode(path);
        if (!src.isWriteable() || !target.isWriteable()) {
            throw new AccessDeniedException("no write ermission");
        }
        try {
            if (src.getParentId().equals(target.getId())) {
                src.setName(fName);
                this.nodeService.save(src);
            } else {
                this.nodeService.move(new Integer[]{src.getId()}, target.getId(), true);
            }
        }
        catch (NodeExistsException e) {
            throw new FileExistsException("Rename file, path exists " + newName);
        }
    }

    public long seekFile(SrvSession sess, TreeConnection tree, NetworkFile file, long pos, int typ) throws IOException {
        return file.seekFile(pos, typ);
    }

    public void setFileInformation(SrvSession sess, TreeConnection tree, String name, FileInfo info) throws IOException {
    }

    public SearchContext startSearch(SrvSession sess, TreeConnection tree, String name, int attrib) throws FileNotFoundException {
        List nodes;
        int i = name.lastIndexOf(92, name.length() - 2) + 1;
        String fName = name.substring(i);
        try {
            Node node = this.getNode(name.substring(0, i));
            if (node != null) {
                nodes = fName.indexOf(42) > -1 ? ("*".equals(fName) || "*.*".equals(fName) ? this.nodeService.getChildNodes(node.getId()) : this.nodeService.search(node.getId(), StringUtils.replace((String)StringUtils.replace((String)fName, (String)"*", (String)"%"), (String)"?", (String)"_"))) : (node.getId() == null ? Collections.emptyList() : Collections.singletonList(this.nodeService.getChildNode(node.getId(), fName)));
            } else {
                throw new IOException();
            }
            if (node.isWriteable()) {
                for (Node n : nodes) {
                    ((NodeImpl)n).setWriteable(true);
                }
            }
        }
        catch (Exception e) {
            throw new FileNotFoundException("search file, not found " + fName);
        }
        FileCenterSearchContext sc = new FileCenterSearchContext(this);
        sc.initSearch(nodes.iterator());
        return sc;
    }

    public void truncateFile(SrvSession sess, TreeConnection tree, NetworkFile file, long siz) throws IOException {
        file.truncateFile(siz);
        file.flushFile();
    }

    public int writeFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufoff, int siz, long fileoff) throws IOException {
        if (file.isDirectory()) {
            throw new AccessDeniedException();
        }
        file.writeFile(buf, siz, bufoff, fileoff);
        return siz;
    }

    public DeviceContext createContext(String shareName, ConfigElement args) throws DeviceContextException {
        return new DiskDeviceContext("fileCenter");
    }

    public void treeOpened(SrvSession sess, TreeConnection tree) {
    }

    public void treeClosed(SrvSession sess, TreeConnection tree) {
    }

    public LockManager getLockManager(SrvSession sess, TreeConnection tree) {
        return _lockManager;
    }

    protected Node getNode(String name) throws IOException {
        block9: {
            int i = name.indexOf(92, 1);
            if (i == -1) {
                String token = name.substring(1);
                return FileCenterDiskDriver.newNode((String)(StringUtils.isEmpty((String)token) ? "fileCenter" : token));
            }
            int j = name.indexOf(92, i + 1);
            if (j == -1) {
                j = name.length();
            }
            String token = name.substring(1, i);
            String nid = name.substring(i + 1, j);
            String path = name.substring(j);
            try {
                HttpSession session = WebdavSessionContext.getInstance().getSession(token);
                Node node = null;
                if (session == null) {
                    try {
                        node = this.nodeService.getNode(Integer.valueOf(Integer.parseInt(nid)), path);
                    }
                    catch (NumberFormatException ignored) {
                        // empty catch block
                    }
                    if (node != null && this.nodeService.hasPermission(token, node.getId())) {
                        ((NodeImpl)node).setWriteable(this.nodeService.isWriteable(token));
                        return node;
                    }
                    break block9;
                }
                PersonalSpace space = (PersonalSpace)session.getAttribute("com.gtis.fileCenter.personalSpace");
                node = this.nodeService.getNode(space.getId(), path);
                if (node instanceof PersonalSpace) {
                    node.setName(space.getId().toString());
                }
                ((NodeImpl)node).setWriteable(true);
                return node;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        throw new PathNotFoundException(name);
    }

    protected static Node newNode(String name) {
        NodeImpl node = new NodeImpl();
        node.setWriteable(true);
        node.setName(name);
        node.setUpdateTime(GLOBAL_UPDATEDATE);
        return node;
    }

    private static FileInfo nodeToFileInfo(Node node, FileInfo finfo) {
        int fattr;
        int n = fattr = node.isWriteable() ? 0 : 1;
        if (node instanceof com.gtis.fileCenter.model.impl.File) {
            long flen = ((com.gtis.fileCenter.model.impl.File)node).getSize();
            finfo.setSize(flen);
            finfo.setAllocationSize(flen + 512L & 0xFFFFFFFFFFFFFE00L);
            finfo.setFileType(1);
        } else {
            fattr += 16;
            finfo.setFileType(2);
        }
        finfo.setFileName(node.getName());
        finfo.setFileAttributes(fattr);
        finfo.setFileId(node.hashCode());
        long fdate = node.getUpdateTime().getTime();
        finfo.setModifyDateTime(fdate);
        finfo.setCreationDateTime(fdate);
        finfo.setChangeDateTime(fdate);
        return finfo;
    }

    static /* synthetic */ FileInfo access$000(Node x0, FileInfo x1) {
        return FileCenterDiskDriver.nodeToFileInfo((Node)x0, (FileInfo)x1);
    }

    static {
        GLOBAL_UPDATEDATE = new Date();
    }
}

