/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.file.impl;

import com.gtis.config.AppConfig;
import com.gtis.fileCenter.file.FileStore;
import com.gtis.fileCenter.file.impl.FileStoreImpl;
import com.gtis.fileCenter.file.impl.TrueNameFileStoreImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.ResourceUtils;

public class FileStoresConfigImpl
implements FactoryBean {
    private static final Logger logger = LoggerFactory.getLogger(FileStoresConfigImpl.class);
    private String configLocation;
    List<FileStore> stores;

    public Object getObject() throws Exception {
        return this.stores;
    }

    public Class getObjectType() {
        return List.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() throws Exception {
        File file = ResourceUtils.getFile((String)this.configLocation);
        Properties config = new Properties();
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            config.load(isr);
            int count = Integer.parseInt(config.getProperty("fileStoresCount"));
            this.stores = new ArrayList(count);
            logger.info("file store count:{}", (Object)count);
            for (int i = 1; i <= count; ++i) {
                String name = config.getProperty("fileStore" + i + ".name");
                String path = config.getProperty("fileStore" + i + ".directory");
                path = AppConfig.getPlaceholderValue((String)path);
                String capability = StringUtils.trimToEmpty((String)config.getProperty("fileStore" + i + ".capability"));
                boolean useTruePath = BooleanUtils.toBoolean((String)config.getProperty("fileStore" + i + ".useTruePath"));
                Object fileStore = useTruePath ? new TrueNameFileStoreImpl(name, path, capability) : new FileStoreImpl(name, path, capability);
                logger.info("Use file store:[name={},path={},capability={}]", new Object[]{name, path, capability});
                this.stores.add(fileStore);
            }
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

