/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.file.impl;

import com.gtis.fileCenter.ex.CapabilityNotEnoughException;
import com.gtis.fileCenter.ex.FileIOException;
import com.gtis.fileCenter.file.FileStore;
import com.gtis.fileCenter.model.impl.StoreUrl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class FileStoreImpl
implements FileStore {
    private static final Logger logger = LoggerFactory.getLogger(FileStoreImpl.class);
    public static final String PROP_FILE = "fileStore.properties";
    public static final SimpleDateFormat PATH_SDF = new SimpleDateFormat("yyyy/MM/dd/HH/");
    private String name;
    private File directory;
    private String absolutePath;
    private File properties;
    private long capability = 0L;
    private long used = 0L;

    public FileStoreImpl(String name, String path, String capability) throws Exception {
        this.properties = new File(ResourceUtils.getFile((String)path), PROP_FILE);
        this.directory = this.properties.getParentFile();
        if (!this.properties.exists()) {
            if (!this.directory.exists()) {
                this.directory.mkdirs();
            }
            this.properties.createNewFile();
        }
        this.name = name;
        this.absolutePath = this.directory.getAbsolutePath();
        this.capability = Long.parseLong(capability);
    }

    public String getName() {
        return this.name;
    }

    public File getDirectory() {
        return this.directory;
    }

    public long getCapability() {
        return this.capability;
    }

    public long getUsed() {
        return this.used;
    }

    public boolean isAvailable() {
        return this.capability < 0L || this.capability > this.used;
    }

    public synchronized void increaseUsed(StoreUrl storeUrl, long size) {
        this.used += size;
    }

    public boolean exists(StoreUrl storeUrl) {
        return this.getFile(storeUrl).exists();
    }

    public File createFile(com.gtis.fileCenter.model.impl.File f) throws CapabilityNotEnoughException, FileIOException {
        File dir;
        File file = new File(this.directory, this.generateName(f));
        if (file.exists()) {
            logger.error("createFile error,path is exist:[" + file.getAbsolutePath() + "]");
        }
        if (!(dir = file.getParentFile()).exists()) {
            dir.mkdirs();
        }
        try {
            if (!file.createNewFile()) {
                throw new FileIOException("createFile file " + file.getPath() + "error");
            }
        }
        catch (IOException e) {
            throw new FileIOException("createFile file " + file.getPath() + "error");
        }
        return file;
    }

    protected String generateName(com.gtis.fileCenter.model.impl.File f) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(PATH_SDF.format(new Date())).append(UUID.randomUUID().toString());
        return sb.toString();
    }

    public StoreUrl getStoreUrl(File file) {
        String path = file.getAbsolutePath();
        if (!path.startsWith(this.absolutePath)) {
            return null;
        }
        return new StoreUrl(this.name, path.substring(this.absolutePath.length()).replace('\\', '/'));
    }

    public File getFile(StoreUrl storeUrl) {
        String relativeUrl = storeUrl.getPath();
        return new File(this.directory, relativeUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(StoreUrl storeUrl) {
        File file = this.getFile(storeUrl);
        if (file.exists()) {
            long size = file.length();
            boolean deleted = file.delete();
            FileStoreImpl fileStoreImpl = this;
            synchronized (fileStoreImpl) {
                this.used -= size;
            }
            return deleted;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() throws Exception {
        if (this.properties != null) {
            Properties property = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.properties);
                property.load(fis);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            String usedStr = property.getProperty(this.getName());
            try {
                this.used = Long.parseLong(usedStr);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            if (this.capability != -1L && this.used == 0L) {
                logger.warn("used property in file fileStore.properties is zero,start to scan used size,may take some time");
                this.countUsed(this.directory);
                logger.info("scan complete used:" + this.used + "/" + this.capability);
            }
            if (this.capability != -1L && this.used > this.capability) {
                throw new Exception("The used size has exceed,please extend the capability of the store " + this.name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() throws Exception {
        if (this.properties != null) {
            Properties property = new Properties();
            InputStreamReader isr = null;
            FileOutputStream fos = null;
            try {
                isr = new InputStreamReader((InputStream)new FileInputStream(this.properties), "UTF-8");
                property.load(isr);
                property.setProperty(this.getName(), Long.toString(this.used));
                isr.close();
                isr = null;
                fos = new FileOutputStream(this.properties);
                property.store(fos, "");
            }
            finally {
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException ignored) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
    }

    public synchronized void countUsed() throws Exception {
        if (this.capability != -1L) {
            return;
        }
        this.used = 0L;
        this.countUsed(this.directory);
    }

    private void countUsed(File directory) {
        this.used = directory.getTotalSpace() - directory.getFreeSpace();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

