/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.file;

import com.gtis.fileCenter.ex.CapabilityNotEnoughException;
import com.gtis.fileCenter.ex.FileIOException;
import com.gtis.fileCenter.file.FileStore;
import com.gtis.fileCenter.model.impl.StoreUrl;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class FileStoresWrapper
implements FileStore {
    private Map<String, FileStore> stores;

    public FileStoresWrapper(List<FileStore> stores) {
        this.stores = new HashMap(stores.size());
        for (FileStore fs : stores) {
            this.stores.put(fs.getName(), fs);
        }
    }

    public Map<String, FileStore> getStores() {
        return this.stores;
    }

    public String getName() {
        return "storeWrapper";
    }

    public File getDirectory() {
        return this.getProperStore().getDirectory();
    }

    public long getCapability() {
        long capability = 0L;
        for (FileStore fs : this.stores.values()) {
            capability += fs.getCapability();
        }
        return capability;
    }

    public long getUsed() {
        long used = 0L;
        for (FileStore fs : this.stores.values()) {
            used += fs.getUsed();
        }
        return used;
    }

    public boolean isAvailable() {
        for (FileStore fs : this.stores.values()) {
            if (!fs.isAvailable()) continue;
            return true;
        }
        return false;
    }

    public void increaseUsed(StoreUrl storeUrl, long size) {
        this.getFileStore(storeUrl).increaseUsed(storeUrl, size);
    }

    public boolean exists(StoreUrl storeUrl) {
        return this.getFileStore(storeUrl).exists(storeUrl);
    }

    public File createFile(com.gtis.fileCenter.model.impl.File file) throws CapabilityNotEnoughException, FileIOException {
        FileStore fs = this.getProperStore();
        if (fs == null) {
            throw new CapabilityNotEnoughException("all store has been full.");
        }
        return fs.createFile(file);
    }

    public StoreUrl getStoreUrl(File file) {
        for (FileStore fs : this.stores.values()) {
            StoreUrl storeUrl = fs.getStoreUrl(file);
            if (storeUrl == null) continue;
            return storeUrl;
        }
        return null;
    }

    public File getFile(StoreUrl storeUrl) {
        return this.getFileStore(storeUrl).getFile(storeUrl);
    }

    public boolean delete(StoreUrl storeUrl) {
        return this.getFileStore(storeUrl).delete(storeUrl);
    }

    public void init() throws Exception {
        for (FileStore fs : this.stores.values()) {
            fs.init();
        }
    }

    public void save() throws Exception {
        for (FileStore fs : this.stores.values()) {
            fs.save();
        }
    }

    public void countUsed() throws Exception {
        for (FileStore fs : this.stores.values()) {
            fs.countUsed();
        }
    }

    private FileStore getFileStore(StoreUrl storeUrl) {
        return (FileStore)this.stores.get(storeUrl.getStoreName());
    }

    public abstract FileStore getProperStore();
}

