/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.file;

import com.gtis.fileCenter.file.FileStreamListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;

public class CallbackFileChannel
extends FileChannel {
    private FileChannel delegate;
    private List<FileStreamListener> listeners;

    public CallbackFileChannel(FileChannel delegate, List<FileStreamListener> listeners) {
        if (delegate == null) {
            throw new IllegalArgumentException("FileChannel delegate is required");
        }
        if (delegate instanceof CallbackFileChannel) {
            throw new IllegalArgumentException("FileChannel delegate may not be a CallbackFileChannel");
        }
        this.delegate = delegate;
        this.listeners = listeners;
    }

    protected void implCloseChannel() throws IOException {
        this.fireChannelClosed();
        this.delegate.close();
    }

    private void fireChannelClosed() throws IOException {
        if (this.listeners.size() == 0) {
            return;
        }
        for (FileStreamListener listener : this.listeners) {
            listener.contentStreamClosed(this.size());
        }
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.delegate.force(metaData);
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        return this.delegate.lock(position, size, shared);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        return this.delegate.map(mode, position, size);
    }

    @Override
    public long position() throws IOException {
        return this.delegate.position();
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        return this.delegate.position(newPosition);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.delegate.read(dst);
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        return this.delegate.read(dst, position);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.delegate.read(dsts, offset, length);
    }

    @Override
    public long size() throws IOException {
        return this.delegate.size();
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        return this.delegate.transferFrom(src, position, count);
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        return this.delegate.transferTo(position, count, target);
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        return this.delegate.truncate(size);
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.delegate.tryLock(position, size, shared);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.delegate.write(src);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        return this.delegate.write(src, position);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.delegate.write(srcs, offset, length);
    }
}

