/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.dao.impl;

import com.alibaba.fastjson.JSON;
import com.gtis.common.pagination.PaginationSQLGetter;
import com.gtis.fileCenter.dao.NodeDao;
import com.gtis.fileCenter.dao.impl.GeneralNodeDaoImpl;
import com.gtis.fileCenter.ex.NestedRuntimeException;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.model.impl.NodeImpl;
import com.gtis.fileCenter.service.MimeTypeService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.stereotype.Repository;

@Repository(value="nodeDao")
public class GeneralNodeDaoImpl
implements NodeDao {
    private static final Logger logger = LoggerFactory.getLogger(GeneralNodeDaoImpl.class);
    private SimpleJdbcTemplate simpleJdbcTemplate;
    @Autowired
    private MimeTypeService mimeTypeService;
    @Autowired
    private DataFieldMaxValueIncrementer nodeIdGenerator;
    @Autowired
    private PaginationSQLGetter paginationSQLGetter;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    public void initRoot() {
        try {
            this.getNode(null, -1);
        }
        catch (NodeNotFoundException e) {
            logger.info("ROOT not exist create it");
            this.simpleJdbcTemplate.update("insert into t_fc_node (id,node_name,node_type,update_time,path) values (1,'ROOT',-1,'2011-01-01','/')", new Object[0]);
        }
        try {
            this.getNode(null, -2);
        }
        catch (NodeNotFoundException e) {
            logger.info("PERSONAL_ROOT not exist create it");
            this.simpleJdbcTemplate.update("insert into t_fc_node (id,parent_id,node_name,node_type,update_time,path) values (2,1,'PERSONALROOT',-2,'2011-01-01','/1/')", new Object[0]);
        }
        try {
            this.getNode(null, -3);
        }
        catch (NodeNotFoundException e) {
            logger.info("WORK_ROOT not exist create it");
            this.simpleJdbcTemplate.update("insert into t_fc_node (id,parent_id,node_name,node_type,update_time,path) values (3,1,'WORKROOT',-3,'2011-01-01','/1/')", new Object[0]);
        }
    }

    public Node save(Node node1) throws NodeNotFoundException {
        NodeImpl node = (NodeImpl)node1;
        if (node.getId() == null) {
            node.setId(Integer.valueOf(this.nodeIdGenerator.nextIntValue()));
            return this.insert(node);
        }
        return this.update(node);
    }

    private Node insert(NodeImpl node) {
        String sql = "insert into t_fc_node (id,parent_id,node_name,view_name,node_type,scope,description,owner,update_time,path,node_size,store_url,attributes) values (:id,:parent_id,:name,:view_name,:type,:scope,:description,:owner,:update_time,:path,:size,:store_url,:attributes)";
        this.simpleJdbcTemplate.update("insert into t_fc_node (id,parent_id,node_name,view_name,node_type,scope,description,owner,update_time,path,node_size,store_url,attributes) values (:id,:parent_id,:name,:view_name,:type,:scope,:description,:owner,:update_time,:path,:size,:store_url,:attributes)", (SqlParameterSource)this.createNodeParameterSource(node));
        logger.debug("insert node ({}) success", (Object)node);
        return this.completeNode(node);
    }

    private Node update(NodeImpl node) throws NodeNotFoundException {
        String sql = "update t_fc_node set parent_id=:parent_id,node_name=:name,view_name=:view_name,node_type=:type,scope=:scope,description=:description,owner=:owner,update_time=:update_time,path=:path,node_size=:size,store_url=:store_url,attributes=:attributes where id=:id";
        if (this.simpleJdbcTemplate.update("update t_fc_node set parent_id=:parent_id,node_name=:name,view_name=:view_name,node_type=:type,scope=:scope,description=:description,owner=:owner,update_time=:update_time,path=:path,node_size=:size,store_url=:store_url,attributes=:attributes where id=:id", (SqlParameterSource)this.createNodeParameterSource(node)) == 0) {
            throw new NodeNotFoundException(node.getId());
        }
        logger.debug("update node ({}) success", (Object)node);
        return this.completeNode(node);
    }

    private MapSqlParameterSource createNodeParameterSource(NodeImpl node) {
        Map attrs = node.getAttributes();
        Long size = null;
        String storeUrl = null;
        if (node instanceof Space) {
            size = ((Space)node).getSize();
        } else if (node instanceof File) {
            size = ((File)node).getSize();
            storeUrl = ((File)node).getStoreUrl();
        }
        return new MapSqlParameterSource().addValue("id", (Object)node.getId()).addValue("parent_id", (Object)node.getParentId()).addValue("name", (Object)node.getName()).addValue("view_name", (Object)node.getViewName()).addValue("type", (Object)node.getType()).addValue("description", (Object)node.getDescription()).addValue("owner", (Object)node.getOwner()).addValue("update_time", (Object)node.getUpdateTime()).addValue("path", (Object)node.getPath()).addValue("scope", (Object)node.getScope()).addValue("size", (Object)size).addValue("store_url", (Object)storeUrl).addValue("attributes", attrs != null && attrs.size() > 0 ? JSON.toJSONString((Object)attrs) : null);
    }

    public boolean exists(Integer nodeId) {
        String sql = "select count(0) from t_fc_node where id=?";
        return this.simpleJdbcTemplate.queryForInt("select count(0) from t_fc_node where id=?", new Object[]{nodeId}) > 0;
    }

    public void remove(Integer nodeId) {
        String sql = "delete from t_fc_node where id=?";
        this.simpleJdbcTemplate.update("delete from t_fc_node where id=?", new Object[]{nodeId});
        logger.debug("remove node,id:({})", (Object)nodeId);
    }

    public Node getParentNode(Integer nodeId) throws NodeNotFoundException {
        String sql = "select t1.* from t_fc_node t1 left join t_fc_node t2 on t2.parent_id=t1.id where t2.id=?";
        try {
            return (Node)this.simpleJdbcTemplate.queryForObject("select t1.* from t_fc_node t1 left join t_fc_node t2 on t2.parent_id=t1.id where t2.id=?", (ParameterizedRowMapper)new NodeRowMapper(this, null), new Object[]{nodeId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new NodeNotFoundException(nodeId);
        }
    }

    public Node getNode(String name, int type) throws NodeNotFoundException {
        try {
            if (type == 3) {
                String sql = "select * from t_fc_node where node_type=? and owner=?";
                return (Node)this.simpleJdbcTemplate.queryForObject(sql, (ParameterizedRowMapper)new NodeRowMapper(this, null), new Object[]{type, name});
            }
            if (StringUtils.isNotBlank((String)name)) {
                String sql = "select * from t_fc_node where node_type=? and node_name=?";
                return (Node)this.simpleJdbcTemplate.queryForObject(sql, (ParameterizedRowMapper)new NodeRowMapper(this, null), new Object[]{type, name});
            }
            String sql = "select * from t_fc_node where node_type=?";
            return (Node)this.simpleJdbcTemplate.queryForObject(sql, (ParameterizedRowMapper)new NodeRowMapper(this, null), new Object[]{type});
        }
        catch (EmptyResultDataAccessException e) {
            throw new NodeNotFoundException("type:[" + type + "] name:[" + name + "]");
        }
    }

    public Node getNode(Integer nodeId) throws NodeNotFoundException {
        String sql = "select * from t_fc_node where id=?";
        try {
            return (Node)this.simpleJdbcTemplate.queryForObject("select * from t_fc_node where id=?", (ParameterizedRowMapper)new NodeRowMapper(this, null), new Object[]{nodeId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new NodeNotFoundException(nodeId);
        }
    }

    public Node getChildNode(Integer parentNodeId, String name) {
        String sql = "select * from t_fc_node where parent_id=? and node_name=?";
        try {
            return (Node)this.simpleJdbcTemplate.queryForObject("select * from t_fc_node where parent_id=? and node_name=?", (ParameterizedRowMapper)new NodeRowMapper(this, null), new Object[]{parentNodeId, name});
        }
        catch (EmptyResultDataAccessException e) {
            throw new NodeNotFoundException(parentNodeId, name);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            logger.error("node [{}] under [{}] duplicate", (Object)new Object[]{name, parentNodeId}, (Object)e);
            throw new NestedRuntimeException("node [" + name + "] under [" + parentNodeId + "] duplicate", (Throwable)e);
        }
    }

    public List<Node> search(String path, String keyword) {
        String sql = "select * from t_fc_node where path like ? and (node_name like ? or description like ?) order by node_type asc,node_name asc";
        return this.simpleJdbcTemplate.query("select * from t_fc_node where path like ? and (node_name like ? or description like ?) order by node_type asc,node_name asc", (ParameterizedRowMapper)new NodeRowMapper(this, null), new Object[]{path + "%", "%" + keyword + "%", "%" + keyword + "%"});
    }

    public List<Node> getChildNodes(Integer nodeId) {
        String sql = "select * from t_fc_node where parent_id=? order by node_type asc,node_name asc";
        String countSql = "select t1.id,count(t2.id) as node_count from t_fc_node t1 left join t_fc_node t2 on t2.parent_id=t1.id where t1.parent_id=? group by t1.id";
        List nodes = this.simpleJdbcTemplate.query("select * from t_fc_node where parent_id=? order by node_type asc,node_name asc", (ParameterizedRowMapper)new NodeRowMapper(this, null), new Object[]{nodeId});
        if (nodes.size() > 0) {
            HashMap map = new HashMap(nodes.size());
            this.simpleJdbcTemplate.getJdbcOperations().query("select t1.id,count(t2.id) as node_count from t_fc_node t1 left join t_fc_node t2 on t2.parent_id=t1.id where t1.parent_id=? group by t1.id", new Object[]{nodeId}, (RowCallbackHandler)new /* Unavailable Anonymous Inner Class!! */);
            for (Node node : nodes) {
                ((NodeImpl)node).setChildCount((Integer)map.get(node.getId()));
            }
        }
        return nodes;
    }

    public List<Node> getAllChildNodes(String path) {
        String sql = "select * from t_fc_node where path like ? order by node_type asc,node_name asc";
        return this.simpleJdbcTemplate.query("select * from t_fc_node where path like ? order by node_type asc,node_name asc", (ParameterizedRowMapper)new NodeRowMapper(this, null), new Object[]{path + "%"});
    }

    public List<File> getAllChildFiles(String path, int start, int size) {
        String sql = "select * from t_fc_node where node_type=1 and path like ? order by node_type asc,node_name asc";
        List nodes = this.simpleJdbcTemplate.query(this.paginationSQLGetter.getPaginationSQL("select * from t_fc_node where node_type=1 and path like ? order by node_type asc,node_name asc", start, size), (ParameterizedRowMapper)new NodeRowMapper(this, null), new Object[]{path + "%"});
        ArrayList<File> files = new ArrayList<File>(nodes.size());
        for (Node node : nodes) {
            files.add((File)node);
        }
        return files;
    }

    public int getAllChildFilesCount(String path) {
        String sql = "select count(0) from t_fc_node where node_type=1 and path like ?";
        return this.simpleJdbcTemplate.queryForInt("select count(0) from t_fc_node where node_type=1 and path like ?", new Object[]{path + "%"});
    }

    public long getUsedSize(String path) {
        String sql = "select sum(node_size) from t_fc_node where path like ?";
        return this.simpleJdbcTemplate.queryForLong("select sum(node_size) from t_fc_node where path like ?", new Object[]{path + "%"});
    }

    public boolean hasLinkFile(String path) {
        String sql = "select count(0) from t_fc_node where store_url=?";
        return this.simpleJdbcTemplate.queryForInt("select count(0) from t_fc_node where store_url=?", new Object[]{path}) > 1;
    }

    private NodeImpl completeNode(NodeImpl node) {
        if (node instanceof Space) {
            node.setIcon("space.gif");
        } else if (node instanceof File) {
            node.setIcon(this.mimeTypeService.getIcon(node.getName()));
        } else {
            node.setIcon("folder.gif");
        }
        return node;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ NodeImpl access$200(GeneralNodeDaoImpl x0, NodeImpl x1) {
        return x0.completeNode(x1);
    }
}

