/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class NodeHelper {
    public static final String PREFIX = "fc_";

    public static Map<String, Object> nodeToJson(Node node) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", node.getId());
        map.put("parentId", node.getParentId());
        map.put("name", node.getName());
        map.put("viewName", node.getViewName());
        map.put("icon", node.getIcon());
        map.put("type", node.getType());
        map.put("scope", node.getScope());
        map.put("description", node.getDescription());
        map.put("owner", node.getOwner());
        map.put("updateTime", node.getUpdateTime());
        if (node.getAttributes() != null) {
            map.put("attrs", node.getAttributes());
        }
        if (node instanceof Space) {
            Space space = (Space)node;
            map.put("size", space.getSize());
            map.put("usedSize", space.getUsedSize());
        } else if (node instanceof File) {
            File file = (File)node;
            map.put("size", file.getSize());
            if (file.isImage()) {
                map.put("isImage", Boolean.TRUE);
            } else if (file.isDocument()) {
                map.put("isDoc", Boolean.TRUE);
            }
        } else if (node.getChildCount() != null) {
            map.put("childCount", node.getChildCount());
        }
        return map;
    }

    public static List<Map<String, Object>> nodesToJson(List<Node> nodes) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(nodes.size());
        for (Node node : nodes) {
            list.add(NodeHelper.nodeToJson((Node)node));
        }
        return list;
    }

    public static Integer getIntegerParameter(HttpServletRequest request, String name) {
        String i = request.getParameter(name);
        if (StringUtils.isNotBlank((String)i)) {
            try {
                return Integer.valueOf(i);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String toIndexId(Integer id) {
        return "fc_" + id;
    }

    public static Integer toFileId(String id) {
        return Integer.valueOf(id.substring(3));
    }
}

