/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.emapserver.core.web.BaseAction;
import com.gtis.emapserver.utils.JxlCellUtils;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import jxl.CellType;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletRequestAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportAction
extends BaseAction
implements ServletRequestAware {
    private Map<String, Object> data;
    private HttpServletRequest request;

    public String execute() throws Exception {
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        String fileName = this.data.get("alias") + "\u5206\u6790\u62a5\u8868.xls";
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        try {
            ServletOutputStream os = ServletActionContext.getResponse().getOutputStream();
            WritableWorkbook wb = Workbook.createWorkbook((OutputStream)os);
            WritableSheet ws = wb.createSheet("sheet1", 0);
            ws.setColumnView(0, 10);
            ws.setColumnView(1, 20);
            ws.setColumnView(2, 15);
            WritableFont titleFont = new WritableFont(WritableFont.createFont((String)"\u5b8b\u4f53"), 11, WritableFont.NO_BOLD);
            WritableCellFormat cellFormat = new WritableCellFormat(titleFont);
            cellFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
            cellFormat.setAlignment(Alignment.CENTRE);
            cellFormat.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.BLACK);
            int startRow = 1;
            JSONArray value = (JSONArray)this.data.get("dict");
            for (int i = 0; i < value.size(); ++i) {
                JSONObject groupObj = (JSONObject)value.get(i);
                String groupTitle = (String)groupObj.get((Object)"title");
                JSONArray groupValue = (JSONArray)groupObj.get((Object)"value");
                ws.addCell((WritableCell)new Label(0, startRow, groupTitle, (CellFormat)cellFormat));
                ws.mergeCells(0, startRow, 0, groupValue.size() + startRow - 1);
                for (int j = 0; j < groupValue.size(); ++j) {
                    JSONObject singleObj = (JSONObject)groupValue.get(j);
                    String singleTitle = (String)singleObj.get((Object)"title");
                    BigDecimal areaValue = (BigDecimal)singleObj.get((Object)"value");
                    ws.addCell((WritableCell)new Label(1, startRow + j, singleTitle, (CellFormat)cellFormat));
                    if (areaValue == null) {
                        ws.addCell((WritableCell)new Number(2, startRow + j, 0.0, (CellFormat)cellFormat));
                        continue;
                    }
                    ws.addCell((WritableCell)new Number(2, startRow + j, areaValue.doubleValue(), (CellFormat)cellFormat));
                }
                startRow += groupValue.size();
            }
            wb.write();
            wb.close();
            os.close();
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faexcel\u8868\u51fa\u9519\uff01", (Object)e.getLocalizedMessage());
            this.logger.error("\u9519\u8bef\u8be6\u7ec6\uff1a" + e.toString());
        }
        return null;
    }

    public void exportExcel() throws Exception {
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        String type = this.data.get("type").toString();
        String fileName = type.equals("1") ? "\u519c\u6751\u571f\u5730\u5229\u7528\u73b0\u72b6\u4e00\u7ea7\u5206\u7c7b\u9762\u79ef\u6c47\u603b\u8868" : "\u519c\u6751\u571f\u5730\u5229\u7528\u73b0\u72b6\u4e8c\u7ea7\u5206\u7c7b\u9762\u79ef\u6c47\u603b\u8868";
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        try {
            ServletOutputStream os = ServletActionContext.getResponse().getOutputStream();
            WritableWorkbook wb = Workbook.createWorkbook((OutputStream)os);
            WritableSheet ws = wb.createSheet(fileName, 0);
            WritableCellFormat cellFormat = JxlCellUtils.getNormolCell();
            if (type.equals("1")) {
                ws.setColumnView(0, 45);
                ws.setColumnView(1, 25);
                ws.setColumnView(2, 20);
                ws.setColumnView(3, 15);
                ws.setColumnView(4, 15);
                ws.setColumnView(5, 15);
                ws.setColumnView(6, 15);
                ws.setColumnView(7, 15);
                ws.setColumnView(8, 20);
                ws.setColumnView(9, 15);
                ws.setColumnView(10, 30);
                ws.setColumnView(11, 20);
                ws.setColumnView(12, 20);
                ws.setColumnView(13, 20);
                ws.setColumnView(14, 20);
                ws.setColumnView(15, 30);
                ws.setRowView(0, 1000);
                ws.setRowView(1, 500);
                ws.addCell((WritableCell)new Label(0, 0, fileName, (CellFormat)JxlCellUtils.getHeader()));
                ws.addCell((WritableCell)new Label(12, 1, "\u5355\u4f4d\uff1a \u5e73\u65b9\u7c73\uff080.00\uff09", (CellFormat)JxlCellUtils.getCustomizeCell((int)12, (Border)Border.NONE)));
                ws.addCell((WritableCell)new Label(14, 1, "\u7b2c1\u9875 \u51711\u9875", (CellFormat)JxlCellUtils.getCustomizeCell((int)12, (Border)Border.NONE)));
                ws.addCell((WritableCell)new Label(0, 2, "\u884c\u653f\u533a\u57df", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(2, 2, "\u884c\u653f\u533a\u57df\u603b\u9762\u79ef", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(3, 2, "\u8015\u5730(01)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(4, 2, "\u56ed\u5730(02)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(5, 2, "\u6797\u5730(03)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(6, 2, "\u8349\u5730(04)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(7, 2, "\u5546\u670d\u7528\u5730(05)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(8, 2, "\u5de5\u77ff\u4ed3\u50a8\u7528\u5730(06)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(9, 2, "\u4f4f\u5b85\u7528\u5730(07)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(10, 2, "\u516c\u5171\u7ba1\u7406\u4e0e\u516c\u5171\u670d\u52a1\u7528\u5730(08)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(11, 2, "\u7279\u6b8a\u7528\u5730(09)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(12, 2, "\u4ea4\u901a\u8fd0\u8f93\u7528\u5730(10)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(13, 2, "\u6c34\u57df\u53ca\u6c34\u5229\u8bbe\u65bd\u7528\u5730(11)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(14, 2, "\u5176\u4ed6\u571f\u5730(12)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(15, 2, "\u57ce\u9547\u6751\u53ca\u5de5\u77ff\u7528\u5730(20)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(0, 3, "\u540d\u79f0", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(1, 3, "\u4ee3\u7801", (CellFormat)cellFormat));
                ws.mergeCells(0, 0, 14, 0);
                ws.mergeCells(12, 1, 13, 1);
                ws.mergeCells(14, 1, 15, 1);
                ws.mergeCells(0, 2, 1, 2);
                ws.mergeCells(2, 2, 2, 3);
                ws.mergeCells(3, 2, 3, 3);
                ws.mergeCells(4, 2, 4, 3);
                ws.mergeCells(5, 2, 5, 3);
                ws.mergeCells(6, 2, 6, 3);
                ws.mergeCells(7, 2, 7, 3);
                ws.mergeCells(8, 2, 8, 3);
                ws.mergeCells(9, 2, 9, 3);
                ws.mergeCells(10, 2, 10, 3);
                ws.mergeCells(11, 2, 11, 3);
                ws.mergeCells(12, 2, 12, 3);
                ws.mergeCells(13, 2, 13, 3);
                ws.mergeCells(14, 2, 14, 3);
                ws.mergeCells(15, 2, 15, 3);
                JSONArray array = (JSONArray)this.data.get("data");
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject obj = (JSONObject)array.get(i);
                    String str1 = obj.get((Object)"QSDWMC").toString();
                    String str2 = obj.get((Object)"QSDWDM").toString();
                    double area = Double.valueOf(obj.get((Object)"AREA").toString());
                    JSONArray arr = (JSONArray)obj.get((Object)"DLTB");
                    ws.addCell((WritableCell)new Label(0, i + 4, str1, (CellFormat)cellFormat));
                    ws.addCell((WritableCell)new Label(1, i + 4, str2, (CellFormat)JxlCellUtils.getCustomizeCell((Alignment)Alignment.LEFT, (DisplayFormat)NumberFormats.TEXT)));
                    ws.addCell((WritableCell)new Number(2, i + 4, area, (CellFormat)JxlCellUtils.getNumberCell()));
                    for (int j = 0; j < arr.size(); ++j) {
                        Number number;
                        JSONObject object = (JSONObject)arr.get(j);
                        int code = Integer.valueOf(object.get((Object)"dlbm").toString().substring(0, 2));
                        double dltbArea = Double.valueOf(object.get((Object)"area").toString());
                        if (code == 20) {
                            if (StringUtils.isBlank((String)ws.getCell(15, i + 4).getContents())) {
                                ws.addCell((WritableCell)new Number(15, i + 4, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                continue;
                            }
                            number = (Number)ws.getWritableCell(15, i + 4);
                            number.setValue(number.getValue() + dltbArea);
                            continue;
                        }
                        if (StringUtils.isBlank((String)ws.getCell(code + 2, i + 4).getContents())) {
                            ws.addCell((WritableCell)new Number(code + 2, i + 4, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                            continue;
                        }
                        number = (Number)ws.getWritableCell(code + 2, i + 4);
                        number.setValue(number.getValue() + dltbArea);
                    }
                    for (int m = 3; m < 16; ++m) {
                        if (ws.getCell(m, i + 4).getType() != CellType.EMPTY) continue;
                        ws.addCell((WritableCell)new Label(m, i + 4, "", (CellFormat)cellFormat));
                    }
                    ws.setRowView(i + 4, 400);
                }
                ws.insertColumn(0);
            } else if (type.equals("2")) {
                ws.setColumnView(0, 45);
                for (int i = 1; i < 48; ++i) {
                    ws.setColumnView(i, 25);
                }
                ws.setRowView(0, 1000);
                ws.setRowView(1, 500);
                ws.addCell((WritableCell)new Label(0, 0, fileName, (CellFormat)JxlCellUtils.getHeader()));
                ws.mergeCells(0, 0, 47, 0);
                ws.addCell((WritableCell)new Label(44, 1, "\u5355\u4f4d\uff1a \u5e73\u65b9\u7c73\uff080.00\uff09", (CellFormat)JxlCellUtils.getCustomizeCell((int)12, (Border)Border.NONE)));
                ws.addCell((WritableCell)new Label(46, 1, "\u7b2c1\u9875 \u51711\u9875", (CellFormat)JxlCellUtils.getCustomizeCell((int)12, (Border)Border.NONE)));
                ws.mergeCells(44, 1, 45, 1);
                ws.mergeCells(46, 1, 47, 1);
                ws.addCell((WritableCell)new Label(0, 2, "\u884c\u653f\u533a\u57df", (CellFormat)cellFormat));
                ws.mergeCells(0, 2, 1, 2);
                ws.addCell((WritableCell)new Label(0, 3, "\u540d\u79f0", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(1, 3, "\u4ee3\u7801", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(2, 2, "\u8015\u5730(01)", (CellFormat)cellFormat));
                ws.mergeCells(2, 2, 2, 3);
                ws.addCell((WritableCell)new Label(3, 2, "\u5176\u4e2d", (CellFormat)cellFormat));
                ws.mergeCells(3, 2, 5, 2);
                ws.addCell((WritableCell)new Label(3, 3, "\u6c34\u7530(011)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(4, 3, "\u6c34\u6d47\u5730(012)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(5, 3, "\u65f1\u5730(013)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(6, 2, "\u56ed\u5730(02)", (CellFormat)cellFormat));
                ws.mergeCells(6, 2, 6, 3);
                ws.addCell((WritableCell)new Label(7, 2, "\u5176\u4e2d", (CellFormat)cellFormat));
                ws.mergeCells(7, 2, 9, 2);
                ws.addCell((WritableCell)new Label(7, 3, "\u679c\u56ed(021)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(8, 3, "\u8336\u56ed(022)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(9, 3, "\u5176\u4ed6\u56ed\u5730(023)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(10, 2, "\u6797\u5730(03)", (CellFormat)cellFormat));
                ws.mergeCells(10, 2, 10, 3);
                ws.addCell((WritableCell)new Label(11, 2, "\u5176\u4e2d", (CellFormat)cellFormat));
                ws.mergeCells(11, 2, 13, 2);
                ws.addCell((WritableCell)new Label(11, 3, "\u6709\u6797\u5730(031)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(12, 3, "\u704c\u6728\u6797\u5730(032)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(13, 3, "\u5176\u4ed6\u6797\u5730(033)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(14, 2, "\u8349\u5730(04)", (CellFormat)cellFormat));
                ws.mergeCells(14, 2, 14, 3);
                ws.addCell((WritableCell)new Label(15, 2, "\u5176\u4e2d", (CellFormat)cellFormat));
                ws.mergeCells(15, 2, 17, 2);
                ws.addCell((WritableCell)new Label(15, 3, "\u5929\u7136\u7267\u8349\u5730(041)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(16, 3, "\u4eba\u5de5\u7267\u8349\u5730(042)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(17, 3, "\u5176\u4ed6\u8349\u5730(043)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(18, 2, "\u57ce\u9547\u6751\u53ca\u5de5\u77ff\u7528\u5730(20)", (CellFormat)cellFormat));
                ws.mergeCells(18, 2, 18, 3);
                ws.addCell((WritableCell)new Label(19, 2, "\u5176\u4e2d", (CellFormat)cellFormat));
                ws.mergeCells(19, 2, 23, 2);
                ws.addCell((WritableCell)new Label(19, 3, "\u57ce\u5e02(201)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(20, 3, "\u5efa\u5236\u9547(202)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(21, 3, "\u6751\u5e84(203)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(22, 3, "\u91c7\u77ff\u7528\u5730(204)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(23, 3, "\u98ce\u666f\u540d\u80dc\u53ca\u7279\u6b8a\u7528\u5730(205)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(24, 2, "\u4ea4\u901a\u8fd0\u8f93\u7528\u5730(10)", (CellFormat)cellFormat));
                ws.mergeCells(24, 2, 24, 3);
                ws.addCell((WritableCell)new Label(25, 2, "\u5176\u4e2d", (CellFormat)cellFormat));
                ws.mergeCells(25, 2, 30, 2);
                ws.addCell((WritableCell)new Label(25, 3, "\u94c1\u8def\u7528\u5730(101)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(26, 3, "\u516c\u8def\u7528\u5730(102)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(27, 3, "\u519c\u6751\u9053\u8def(104)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(28, 3, "\u673a\u573a\u7528\u5730(105)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(29, 3, "\u6e2f\u53e3\u7801\u5934\u7528\u5730(106)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(30, 3, "\u7ba1\u9053\u8fd0\u8f93\u7528\u5730(107)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(31, 2, "\u6c34\u57df\u53ca\u6c34\u5229\u8bbe\u65bd\u7528\u5730(11)", (CellFormat)cellFormat));
                ws.mergeCells(31, 2, 31, 3);
                ws.addCell((WritableCell)new Label(32, 2, "\u5176\u4e2d", (CellFormat)cellFormat));
                ws.mergeCells(32, 2, 40, 2);
                ws.addCell((WritableCell)new Label(32, 3, "\u6cb3\u6d41\u6c34\u9762(111)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(33, 3, "\u6e56\u6cca\u6c34\u9762(112)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(34, 3, "\u6c34\u5e93\u6c34\u9762(113)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(35, 3, "\u5751\u5858\u6c34\u9762(114)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(36, 3, "\u6cbf\u6d77\u6ee9\u6d82(115)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(37, 3, "\u5185\u9646\u6ee9\u6d82(116)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(38, 3, "\u6c9f\u6e20(117)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(39, 3, "\u6c34\u5de5\u5efa\u7b51\u7528\u5730(118)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(40, 3, "\u51b0\u5ddd\u53ca\u6c38\u4e45\u79ef\u96ea(119)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(41, 2, "\u5176\u4ed6\u571f\u5730(12)", (CellFormat)cellFormat));
                ws.mergeCells(41, 2, 41, 3);
                ws.addCell((WritableCell)new Label(42, 2, "\u5176\u4e2d", (CellFormat)cellFormat));
                ws.mergeCells(42, 2, 47, 2);
                ws.addCell((WritableCell)new Label(42, 3, "\u8bbe\u65bd\u519c\u7528\u5730(122)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(43, 3, "\u7530\u574e(123)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(44, 3, "\u76d0\u78b1\u5730(124)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(45, 3, "\u6cbc\u6cfd\u5730(125)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(46, 3, "\u6c99\u5730(126)", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(47, 3, "\u88f8\u5730(127)", (CellFormat)cellFormat));
                JSONArray array = (JSONArray)this.data.get("data");
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject obj = (JSONObject)array.get(i);
                    String str1 = obj.get((Object)"QSDWMC").toString();
                    String str2 = obj.get((Object)"QSDWDM").toString();
                    JSONArray arr = (JSONArray)obj.get((Object)"DLTB");
                    ws.addCell((WritableCell)new Label(0, i + 4, str1, (CellFormat)cellFormat));
                    ws.addCell((WritableCell)new Label(1, i + 4, str2, (CellFormat)JxlCellUtils.getCustomizeCell((Alignment)Alignment.LEFT, (DisplayFormat)NumberFormats.TEXT)));
                    for (int j = 0; j < arr.size(); ++j) {
                        JSONObject object = (JSONObject)arr.get(j);
                        int preCode = Integer.valueOf(object.get((Object)"dlbm").toString().substring(0, 2));
                        int lastCode = Integer.valueOf(object.get((Object)"dlbm").toString().substring(2, 3));
                        double dltbArea = Double.valueOf(object.get((Object)"area").toString());
                        int startCol = 0;
                        switch (preCode) {
                            case 1: {
                                startCol = 2;
                                break;
                            }
                            case 2: {
                                startCol = 6;
                                break;
                            }
                            case 3: {
                                startCol = 10;
                                break;
                            }
                            case 4: {
                                startCol = 14;
                                break;
                            }
                            case 20: {
                                startCol = 18;
                                break;
                            }
                            case 10: {
                                startCol = 24;
                                break;
                            }
                            case 11: {
                                startCol = 31;
                                break;
                            }
                            case 12: {
                                startCol = 41;
                            }
                        }
                        ws.addCell((WritableCell)new Number(startCol + lastCode, i + 4, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                        if (StringUtils.isBlank((String)ws.getCell(startCol, i + 4).getContents())) {
                            ws.addCell((WritableCell)new Number(startCol, i + 4, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                            continue;
                        }
                        Number number = (Number)ws.getWritableCell(startCol, i + 4);
                        number.setValue(number.getValue() + dltbArea);
                    }
                    for (int m = 2; m < 48; ++m) {
                        if (ws.getCell(m, i + 4).getType() != CellType.EMPTY) continue;
                        ws.addCell((WritableCell)new Label(m, i + 4, "", (CellFormat)cellFormat));
                    }
                    ws.setRowView(i + 4, 400);
                }
            }
            wb.write();
            wb.close();
            os.close();
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa" + fileName + "excel\u8868\u51fa\u9519\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.logger.error("\u9519\u8bef\u8be6\u7ec6\uff1a" + e.toString());
        }
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
        this.setData(request.getParameter("param"));
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = (Map)JSONObject.parseObject((String)data, Map.class);
    }
}

