/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web.map;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.emapserver.core.web.BaseAction;
import com.gtis.emapserver.entity.Function;
import com.gtis.emapserver.entity.Service;
import com.gtis.emapserver.service.MapService;
import com.gtis.emapserver.service.QueryService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class QueryAction
extends BaseAction {
    @Autowired
    private QueryService queryService;
    @Autowired
    private MapService mapService;
    private String[] serviceIds;
    private String serverType;
    private String url;
    private String param;

    public String execute() throws Exception {
        if ("ags".equals(this.serverType)) {
            this.sendString(this.queryService.executeAgsQuery(this.url, this.param));
        } else if ("gtmap".equals(this.serverType)) {
            this.sendString(this.queryService.executeGtMapQuery(this.url, this.param));
        }
        return null;
    }

    public void queryConfig() throws IOException {
        try {
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            for (String serviceId : this.serviceIds) {
                Function function = this.mapService.getFunctionByType(new Function(serviceId, Function.Type.SEARCH.getId()));
                if (function == null) continue;
                JSONArray layers = function.getConfigLayers();
                for (int i = 0; i < layers.size(); ++i) {
                    JSONObject layer = (JSONObject)layers.get(i);
                    Service service = this.mapService.findService(serviceId);
                    URL url = new URL(service.getUrl() + "/" + layer.get((Object)"layerIndex"));
                    layer.put("url", (Object)url.toExternalForm());
                    layer.put("layerType", (Object)service.getType());
                    list.add(layer);
                }
            }
            this.sendJson(list);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u67e5\u8be2\u914d\u7f6e\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError(e.getLocalizedMessage());
        }
    }

    public void identifyConfig() throws IOException {
        ArrayList list = new ArrayList();
        HashMap<String, String> service = null;
        try {
            for (String serviceId : this.serviceIds) {
                Function function = this.mapService.getFunctionByType(new Function(serviceId, Function.Type.IDENTIFY.getId()));
                if (function == null) continue;
                service = new HashMap<String, String>();
                service.put("serviceId", serviceId);
                service.put("url", this.mapService.findService(serviceId).getUrl());
                service.put("config", (String)function.getConfigLayers());
                list.add(service);
            }
            this.sendJson(list);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5c5e\u6027\u67e5\u770b\u914d\u7f6e\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError(e.getLocalizedMessage());
        }
    }

    public void locationConfig() throws IOException {
        try {
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            for (String serviceId : this.serviceIds) {
                Function function = this.mapService.getFunctionByType(new Function(serviceId, Function.Type.LOCATION.getId()));
                if (function == null) continue;
                JSONArray layers = function.getConfigLayers();
                for (int i = 0; i < layers.size(); ++i) {
                    JSONObject layer = (JSONObject)layers.get(i);
                    Service service = this.mapService.findService(serviceId);
                    URL url = new URL(service.getUrl() + "/" + layer.get((Object)"layerIndex"));
                    layer.put("url", (Object)url.toExternalForm());
                    layer.put("layerType", (Object)service.getType());
                    list.add(layer);
                }
            }
            this.sendJson(list);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5b9a\u4f4d\u914d\u7f6e\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError("\u83b7\u53d6\u5b9a\u4f4d\u914d\u7f6e\u5f02\u5e38\u3010{" + e.getLocalizedMessage() + "}\u3011");
        }
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public void setUrl(String url) throws UnsupportedEncodingException {
        this.url = url;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public void setServiceIds(String serviceIds) {
        this.serviceIds = serviceIds.split(";");
    }
}

