/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web.map;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.emapserver.core.event.DictNoteFoundException;
import com.gtis.emapserver.core.ogc.GeometryOperation;
import com.gtis.emapserver.core.web.BaseAction;
import com.gtis.emapserver.entity.Function;
import com.gtis.emapserver.entity.dict.Item;
import com.gtis.emapserver.service.DictService;
import com.gtis.emapserver.service.GISManager;
import com.gtis.emapserver.service.MapService;
import com.gtis.emapserver.utils.ArrayUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AnalysisAction
extends BaseAction {
    private static final String GROUP_DICT = "groupDict";
    private static final String GROUP_FIELD = "groupField";
    @Autowired
    private GISManager gisManager;
    @Autowired
    private MapService mapService;
    @Autowired
    private GeometryOperation geometryOperation;
    @Autowired
    private DictService dictService;
    private String[] serviceIds;
    private String[] layerNames;
    private String polygon;
    private String[] dataSources;
    private String[] returnFields;

    public String execute() throws Exception {
        this.prepareParams();
        Map result = null;
        result = this.dataSources != null ? this.gisManager.getGISService().intersectAnalysis(this.layerNames, this.polygon, this.returnFields, this.dataSources) : this.gisManager.getGISService().intersectAnalysis(this.layerNames, this.polygon, this.returnFields);
        if (result != null) {
            this.logger.debug(result.toString());
            this.sendJson((Object)result);
        } else {
            this.logger.debug("\u65e0\u5206\u6790\u7ed3\u679c\uff01");
            this.sendError("\u65e0\u5206\u6790\u7ed3\u679c\uff01");
        }
        return null;
    }

    private void prepareParams() {
        if (this.empty(this.layerNames)) {
            this.logger.info("\u672a\u63a5\u6536\u5230\u5206\u6790\u56fe\u5c42\uff01");
        }
        if (StringUtils.isBlank((String)this.polygon)) {
            this.logger.info("\u5206\u6790\u591a\u8fb9\u5f62\u4e3a\u7a7a\uff01");
        } else {
            try {
                this.geometryOperation.readGeo(this.polygon);
            }
            catch (Exception e) {
                this.logger.info(this.polygon);
                this.logger.error("\u89e3\u6790\u5750\u6807\u4e32\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            }
        }
        if (this.empty(this.returnFields)) {
            this.logger.info("\u672a\u914d\u7f6e\u8fd4\u56de\u5b57\u6bb5\uff01");
        }
        if (!this.empty(this.dataSources)) {
            this.logger.info("\u5df2\u914d\u7f6e\u591a\u6570\u636e\u6e90\uff01");
        }
    }

    public void config() throws IOException {
        ArrayList<JSONObject> functions = new ArrayList<JSONObject>();
        for (String serviceId : this.serviceIds) {
            Function function = this.mapService.getFunctionByType(new Function(serviceId, Function.Type.ANALYSIS.getId()));
            if (function == null) continue;
            JSONArray array = function.getConfigLayers();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject layer = (JSONObject)array.get(i);
                if (layer.containsKey((Object)GROUP_DICT)) {
                    layer.put(GROUP_DICT, (Object)this.getAnalysisCategory((String)layer.get((Object)GROUP_DICT)));
                } else if (layer.containsKey((Object)GROUP_FIELD)) {
                    // empty if block
                }
                functions.add(layer);
            }
        }
        this.sendJson(functions);
    }

    private List getAnalysisCategory(String groupDict) throws IOException {
        ArrayList results = new ArrayList();
        try {
            List items = this.dictService.getDictItemsByName(groupDict);
            HashMap<String, Object> result = null;
            for (Item item : items) {
                result = new HashMap<String, Object>();
                result.put("name", item.getName());
                result.put("title", item.getTitle());
                ArrayList<Map> list = new ArrayList<Map>();
                List subItems = this.dictService.getDictItemsByName(item.getName());
                for (Item subItem : subItems) {
                    list.add(subItem.toMap());
                }
                result.put("value", list);
                results.add(result);
            }
        }
        catch (DictNoteFoundException e) {
            this.logger.error("\u5206\u6790\u5206\u7ec4\u5b57\u5178\u3010{}\u3011\u4fe1\u606f\u672a\u914d\u7f6e", (Object)groupDict);
        }
        catch (Exception e) {
            this.logger.error("\u5206\u6790\u5206\u7ec4\u5b57\u5178\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
        return results;
    }

    private boolean empty(String[] values) {
        return ArrayUtils.empty((String[])values);
    }

    public void setServiceIds(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.serviceIds = value.split(";");
        }
    }

    public void setLayerNames(String layerNames) {
        if (StringUtils.isNotBlank((String)layerNames)) {
            this.layerNames = layerNames.split(";");
        }
    }

    public void setPolygon(String polygon) {
        this.polygon = polygon;
    }

    public void setDataSources(String dataSources) {
        if (StringUtils.isNotBlank((String)dataSources)) {
            this.dataSources = dataSources.split(";");
        }
    }

    public void setReturnFields(String returnFields) {
        if (StringUtils.isNotBlank((String)returnFields)) {
            this.returnFields = returnFields.split(";");
        }
    }
}

