/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web;

import com.alibaba.fastjson.JSON;
import com.gtis.emapserver.core.web.BaseAction;
import com.gtis.emapserver.service.GISManager;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.annotation.Action;
import org.springframework.beans.factory.annotation.Autowired;

public class GatewayAction
extends BaseAction {
    @Autowired
    private GISManager gisManager;
    private Map data;

    @Action(value="/gateway/edit/insert")
    public void insert() throws IOException {
        try {
            if (this.data != null) {
                String layerName = (String)this.data.get("layerName");
                Map columns = (Map)this.data.get("columns");
                String dataSource = (String)this.data.get("dataSource");
                boolean success = false;
                success = this.gisManager.getGISService().edit(layerName, columns, dataSource);
                if (success) {
                    this.sendOk("\u7f16\u8f91\u6210\u529f!");
                } else {
                    this.sendError("\u7531\u4e8e\u67d0\u79cd\u5f3a\u5927\u7684\u672a\u77e5\u539f\u56e0\u7f16\u8f91\u5931\u8d25\u4e86-_-!");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u7f16\u8f91\u5f02\u5e38\uff1a\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError("\u7f16\u8f91\u8c8c\u4f3c\u5931\u8d25\u4e86\uff0c\u539f\u56e0\uff1a\u3010{" + e.getLocalizedMessage() + "}\u3011");
        }
    }

    @Action(value="/gateway/edit/update")
    public void update() throws IOException {
        try {
            if (this.data != null) {
                String layerName = (String)this.data.get("layerName");
                String id = String.valueOf(this.data.get("id"));
                Map columns = (Map)this.data.get("columns");
                String dataSource = (String)this.data.get("dataSource");
                boolean success = false;
                success = this.gisManager.getGISService().update(layerName, id, columns, dataSource);
                if (success) {
                    this.sendOk("\u66f4\u65b0\u6210\u529f\uff01");
                } else {
                    this.sendError("\u66f4\u65b0\u5931\u8d25\uff01");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError("\u66f4\u65b0\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
        }
    }

    @Action(value="/gateway/edit/delete")
    public void delete() throws IOException {
        try {
            if (this.data != null) {
                String layerName = (String)this.data.get("layerName");
                String id = String.valueOf(this.data.get("id"));
                String dataSource = (String)this.data.get("dataSource");
                boolean success = false;
                success = this.gisManager.getGISService().delete(layerName, id, dataSource);
                if (success) {
                    this.sendOk("\u5220\u9664\u6210\u529f\uff01");
                } else {
                    this.sendError("\u5220\u9664\u5931\u8d25\uff01");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError("\u5220\u9664\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
        }
    }

    @Action(value="/gateway/query")
    public void query() throws IOException {
        try {
            if (this.data != null) {
                String layerName = (String)this.data.get("layerName");
                String where = (String)this.data.get("where");
                String[] columns = String.valueOf(this.data.get("columns")).split(",");
                boolean returnGeometry = Boolean.valueOf(String.valueOf(this.data.get("returnGeometry")));
                String dataSource = (String)this.data.get("dataSource");
                List results = this.gisManager.getGISService().query(layerName, where, columns, returnGeometry, dataSource);
                if (results != null) {
                    this.sendJson((Object)results);
                } else {
                    this.sendError("\u67e5\u8be2\u5f02\u5e38");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError("\u67e5\u8be2\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
        }
    }

    @Action(value="/gateway/query/spatial")
    public void spatialQuery() throws IOException {
        try {
            if (this.data != null) {
                String layerName = (String)this.data.get("layerName");
                String shape = (String)this.data.get("shape");
                String[] columns = String.valueOf(this.data.get("columns")).split(",");
                String dataSource = (String)this.data.get("dataSource");
                List results = this.gisManager.getGISService().query(layerName, shape, columns, dataSource);
                if (results != null) {
                    this.sendJson((Object)results);
                } else {
                    this.sendError("\u7a7a\u95f4\u67e5\u8be2\u5f02\u5e38");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u7a7a\u95f4\u67e5\u8be2\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError("\u7a7a\u95f4\u67e5\u8be2\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
        }
    }

    public void setData(String data) {
        try {
            this.logger.info("data\uff1a\u3010{}\u3011", (Object)data);
            this.data = (Map)JSON.parseObject((String)data, Map.class);
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790JSON\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }
}

