/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.service.impl;

import com.alibaba.fastjson.JSON;
import com.gtis.emapserver.core.event.TemplateNotFoundException;
import com.gtis.emapserver.core.service.TemplateService;
import com.gtis.emapserver.service.GISManager;
import com.gtis.emapserver.service.SearchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchServiceImpl
implements SearchService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map config;
    private List<Map> layers;
    @Autowired
    private GISManager gisManager;
    @Autowired
    private TemplateService templateService;

    @PostConstruct
    private void init() {
        try {
            String content = this.templateService.getTemplate("search.json");
            this.config = (Map)JSON.parseObject((String)content, Map.class);
            this.layers = (List)this.config.get("layers");
        }
        catch (TemplateNotFoundException e) {
            this.logger.info("\u67e5\u8be2\u6a21\u677f[search.json]\u672a\u914d\u7f6e");
        }
        catch (Exception ex) {
            this.logger.error("\u8bfb\u53d6\u67e5\u8be2\u6a21\u677f\u5f02\u5e38\u3010{}\u3011", (Object)ex.getLocalizedMessage());
        }
    }

    public List immediate(String key) {
        ArrayList results = new ArrayList();
        for (Map item : this.layers) {
            List result = this.gisManager.getGISService().immediateSearch((String)item.get("layer"), String.valueOf(item.get("fields")).split(","), key);
            if (result == null) continue;
            results.addAll(result);
        }
        return results;
    }

    public List search(String key) {
        ArrayList results = new ArrayList();
        for (Map item : this.layers) {
            List result = this.gisManager.getGISService().fullSearch((String)item.get("layer"), String.valueOf(item.get("fields")).split(","), key);
            if (result == null) continue;
            results.addAll(result);
        }
        return results;
    }
}

